/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.aws.outbound;

import io.awspring.cloud.sqs.QueueAttributesResolver;
import io.awspring.cloud.sqs.listener.QueueAttributes;
import io.awspring.cloud.sqs.listener.QueueNotFoundStrategy;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.springframework.expression.Expression;
import org.springframework.expression.common.LiteralExpression;
import org.springframework.integration.aws.outbound.AbstractAwsMessageHandler;
import org.springframework.integration.aws.support.SqsHeaderMapper;
import org.springframework.integration.expression.ValueExpression;
import org.springframework.integration.mapping.HeaderMapper;
import org.springframework.messaging.Message;
import org.springframework.messaging.converter.GenericMessageConverter;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import software.amazon.awssdk.awscore.AwsRequest;
import software.amazon.awssdk.awscore.AwsResponse;
import software.amazon.awssdk.services.sqs.SqsAsyncClient;
import software.amazon.awssdk.services.sqs.model.MessageAttributeValue;
import software.amazon.awssdk.services.sqs.model.SendMessageBatchRequest;
import software.amazon.awssdk.services.sqs.model.SendMessageRequest;
import software.amazon.awssdk.services.sqs.model.SendMessageResponse;

public class SqsMessageHandler
extends AbstractAwsMessageHandler<Map<String, MessageAttributeValue>> {
    private final SqsAsyncClient amazonSqs;
    private MessageConverter messageConverter;
    private Expression queueExpression;
    private QueueNotFoundStrategy queueNotFoundStrategy = QueueNotFoundStrategy.FAIL;
    private Expression delayExpression;
    private Expression messageGroupIdExpression;
    private Expression messageDeduplicationIdExpression;

    public SqsMessageHandler(SqsAsyncClient amazonSqs) {
        Assert.notNull((Object)amazonSqs, (String)"'amazonSqs' must not be null");
        this.amazonSqs = amazonSqs;
    }

    public void setQueue(String queue) {
        Assert.hasText((String)queue, (String)"'queue' must not be empty");
        this.setQueueExpression((Expression)new LiteralExpression(queue));
    }

    public void setQueueExpressionString(String queueExpression) {
        this.setQueueExpression(EXPRESSION_PARSER.parseExpression(queueExpression));
    }

    public void setQueueExpression(Expression queueExpression) {
        Assert.notNull((Object)queueExpression, (String)"'queueExpression' must not be null");
        this.queueExpression = queueExpression;
    }

    public void setQueueNotFoundStrategy(QueueNotFoundStrategy queueNotFoundStrategy) {
        Assert.notNull((Object)queueNotFoundStrategy, (String)"'queueNotFoundStrategy' must not be null");
        this.queueNotFoundStrategy = queueNotFoundStrategy;
    }

    public void setDelay(int delaySeconds) {
        this.setDelayExpression((Expression)new ValueExpression((Object)delaySeconds));
    }

    public void setDelayExpressionString(String delayExpression) {
        this.setDelayExpression(EXPRESSION_PARSER.parseExpression(delayExpression));
    }

    public void setDelayExpression(Expression delayExpression) {
        Assert.notNull((Object)delayExpression, (String)"'delayExpression' must not be null");
        this.delayExpression = delayExpression;
    }

    public void setMessageGroupId(String messageGroupId) {
        this.setMessageGroupIdExpression((Expression)new LiteralExpression(messageGroupId));
    }

    public void setMessageGroupIdExpressionString(String groupIdExpression) {
        this.setMessageGroupIdExpression(EXPRESSION_PARSER.parseExpression(groupIdExpression));
    }

    public void setMessageGroupIdExpression(Expression messageGroupIdExpression) {
        Assert.notNull((Object)messageGroupIdExpression, (String)"'messageGroupIdExpression' must not be null");
        this.messageGroupIdExpression = messageGroupIdExpression;
    }

    public void setMessageDeduplicationId(String messageDeduplicationId) {
        this.setMessageDeduplicationIdExpression((Expression)new LiteralExpression(messageDeduplicationId));
    }

    public void setMessageDeduplicationIdExpressionString(String messageDeduplicationIdExpression) {
        this.setMessageDeduplicationIdExpression(EXPRESSION_PARSER.parseExpression(messageDeduplicationIdExpression));
    }

    public void setMessageDeduplicationIdExpression(Expression messageDeduplicationIdExpression) {
        Assert.notNull((Object)messageDeduplicationIdExpression, (String)"'messageDeduplicationIdExpression' must not be null");
        this.messageDeduplicationIdExpression = messageDeduplicationIdExpression;
    }

    public void setMessageConverter(MessageConverter messageConverter) {
        this.messageConverter = messageConverter;
    }

    @Override
    protected void onInit() {
        super.onInit();
        if (!this.isHeaderMapperSet()) {
            this.setHeaderMapper(new SqsHeaderMapper());
        }
        if (this.messageConverter == null) {
            this.messageConverter = new GenericMessageConverter(this.getConversionService());
        }
    }

    @Override
    protected AwsRequest messageToAwsRequest(Message<?> message) {
        Object payload = message.getPayload();
        if (payload instanceof SendMessageBatchRequest) {
            return (SendMessageBatchRequest)payload;
        }
        if (payload instanceof SendMessageRequest) {
            return (SendMessageRequest)payload;
        }
        SendMessageRequest.Builder sendMessageRequest = SendMessageRequest.builder();
        String queue = (String)message.getHeaders().get((Object)"aws_queue", String.class);
        if (!StringUtils.hasText((String)queue) && this.queueExpression != null) {
            queue = (String)this.queueExpression.getValue(this.getEvaluationContext(), message, String.class);
        }
        Assert.state((queue != null ? 1 : 0) != 0, (String)"'queue' must not be null for sending an SQS message. Consider configuring this handler with a 'queue'( or 'queueExpression') or supply an 'aws_queue' message header");
        String queueUrl = this.resolveQueueUrl(queue);
        String messageBody = (String)this.messageConverter.fromMessage(message, String.class);
        sendMessageRequest.queueUrl(queueUrl).messageBody(messageBody);
        if (this.delayExpression != null) {
            Integer delay = (Integer)this.delayExpression.getValue(this.getEvaluationContext(), message, Integer.class);
            sendMessageRequest.delaySeconds(delay);
        }
        if (this.messageGroupIdExpression != null) {
            String messageGroupId = (String)this.messageGroupIdExpression.getValue(this.getEvaluationContext(), message, String.class);
            sendMessageRequest.messageGroupId(messageGroupId);
        }
        if (this.messageDeduplicationIdExpression != null) {
            String messageDeduplicationId = (String)this.messageDeduplicationIdExpression.getValue(this.getEvaluationContext(), message, String.class);
            sendMessageRequest.messageDeduplicationId(messageDeduplicationId);
        }
        this.mapHeaders(message, sendMessageRequest);
        return (AwsRequest)sendMessageRequest.build();
    }

    private String resolveQueueUrl(String queue) {
        return ((QueueAttributes)QueueAttributesResolver.builder().sqsAsyncClient(this.amazonSqs).queueNotFoundStrategy(this.queueNotFoundStrategy).queueAttributeNames(Collections.emptyList()).queueName(queue).build().resolveQueueAttributes().join()).getQueueUrl();
    }

    private void mapHeaders(Message<?> message, SendMessageRequest.Builder sendMessageRequest) {
        HeaderMapper headerMapper = this.getHeaderMapper();
        if (headerMapper != null) {
            HashMap messageAttributes = new HashMap();
            headerMapper.fromHeaders(message.getHeaders(), messageAttributes);
            if (!messageAttributes.isEmpty()) {
                sendMessageRequest.messageAttributes(messageAttributes);
            }
        }
    }

    @Override
    protected CompletableFuture<? extends AwsResponse> handleMessageToAws(Message<?> message, AwsRequest request) {
        if (request instanceof SendMessageBatchRequest) {
            SendMessageBatchRequest sendMessageBatchRequest = (SendMessageBatchRequest)request;
            return this.amazonSqs.sendMessageBatch(sendMessageBatchRequest);
        }
        return this.amazonSqs.sendMessage((SendMessageRequest)request);
    }

    @Override
    protected Map<String, ?> additionalOnSuccessHeaders(AwsRequest request, AwsResponse response) {
        if (response instanceof SendMessageResponse) {
            SendMessageResponse sendMessageResponse = (SendMessageResponse)response;
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("aws_messageId", sendMessageResponse.messageId());
            String sequenceNumber = sendMessageResponse.sequenceNumber();
            if (StringUtils.hasText((String)sequenceNumber)) {
                headers.put("aws_sequenceNumber", sequenceNumber);
            }
            return headers;
        }
        return null;
    }
}

