/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.amqp.support;

import com.rabbitmq.client.ConfirmCallback;
import java.lang.reflect.UndeclaredThrowableException;
import java.time.Duration;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jspecify.annotations.Nullable;
import org.springframework.amqp.rabbit.core.RabbitOperations;
import org.springframework.integration.handler.advice.HandleMessageAdvice;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

public class BoundRabbitChannelAdvice
implements HandleMessageAdvice {
    private final Log logger = LogFactory.getLog(this.getClass());
    private final RabbitOperations operations;
    private final @Nullable Duration waitForConfirmsTimeout;
    private final ConfirmCallback ackCallback = this::handleAcks;
    private final ConfirmCallback nackCallback = this::handleNacks;

    public BoundRabbitChannelAdvice(RabbitOperations operations) {
        this(operations, null);
    }

    public BoundRabbitChannelAdvice(RabbitOperations operations, @Nullable Duration waitForConfirmsTimeout) {
        Assert.notNull((Object)operations, (String)"'operations' cannot be null");
        this.operations = operations;
        this.waitForConfirmsTimeout = waitForConfirmsTimeout;
        if (this.waitForConfirmsTimeout != null) {
            Assert.isTrue((boolean)operations.getConnectionFactory().isSimplePublisherConfirms(), (String)"'waitForConfirmsTimeout' requires a connection factory with simple publisher confirms enabled");
        }
    }

    public @Nullable Object invoke(MethodInvocation invocation) throws Throwable {
        try {
            return this.operations.invoke(operations -> {
                try {
                    Object result = invocation.proceed();
                    if (this.waitForConfirmsTimeout != null) {
                        this.operations.waitForConfirmsOrDie(this.waitForConfirmsTimeout.toMillis());
                    }
                    return result;
                }
                catch (Throwable t) {
                    ReflectionUtils.rethrowRuntimeException((Throwable)t);
                    return null;
                }
            }, this.ackCallback, this.nackCallback);
        }
        catch (UndeclaredThrowableException ute) {
            throw ute.getCause();
        }
    }

    private void handleAcks(long deliveryTag, boolean multiple) {
        this.doHandleAcks(deliveryTag, multiple, true);
    }

    private void handleNacks(long deliveryTag, boolean multiple) {
        this.doHandleAcks(deliveryTag, multiple, false);
    }

    private void doHandleAcks(long deliveryTag, boolean multiple, boolean ack) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Publisher confirm " + (!ack ? "n" : "") + "ack: " + deliveryTag + ", multiple: " + multiple));
        }
    }
}

