/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.amqp.dsl;

import org.jspecify.annotations.Nullable;
import org.springframework.amqp.core.AmqpTemplate;
import org.springframework.amqp.core.Queue;
import org.springframework.amqp.rabbit.AsyncRabbitTemplate;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.listener.DirectMessageListenerContainer;
import org.springframework.amqp.rabbit.listener.SimpleMessageListenerContainer;
import org.springframework.integration.amqp.channel.PollableAmqpChannel;
import org.springframework.integration.amqp.dsl.AmqpAsyncOutboundGatewaySpec;
import org.springframework.integration.amqp.dsl.AmqpInboundChannelAdapterDMLCSpec;
import org.springframework.integration.amqp.dsl.AmqpInboundChannelAdapterSMLCSpec;
import org.springframework.integration.amqp.dsl.AmqpInboundGatewayDMLCSpec;
import org.springframework.integration.amqp.dsl.AmqpInboundGatewaySMLCSpec;
import org.springframework.integration.amqp.dsl.AmqpInboundPolledChannelAdapterSpec;
import org.springframework.integration.amqp.dsl.AmqpMessageChannelSpec;
import org.springframework.integration.amqp.dsl.AmqpOutboundChannelAdapterSpec;
import org.springframework.integration.amqp.dsl.AmqpOutboundGatewaySpec;
import org.springframework.integration.amqp.dsl.AmqpPollableMessageChannelSpec;
import org.springframework.integration.amqp.dsl.AmqpPublishSubscribeMessageChannelSpec;
import org.springframework.integration.amqp.inbound.AmqpMessageSource;

public final class Amqp {
    public static AmqpInboundGatewaySMLCSpec inboundGateway(ConnectionFactory connectionFactory, String ... queueNames) {
        SimpleMessageListenerContainer listenerContainer = new SimpleMessageListenerContainer(connectionFactory);
        listenerContainer.setQueueNames(queueNames);
        return Amqp.inboundGateway(listenerContainer);
    }

    public static AmqpInboundGatewaySMLCSpec inboundGateway(ConnectionFactory connectionFactory, AmqpTemplate amqpTemplate, String ... queueNames) {
        SimpleMessageListenerContainer listenerContainer = new SimpleMessageListenerContainer(connectionFactory);
        listenerContainer.setQueueNames(queueNames);
        return Amqp.inboundGateway(listenerContainer, amqpTemplate);
    }

    public static AmqpInboundGatewaySMLCSpec inboundGateway(ConnectionFactory connectionFactory, Queue ... queues) {
        SimpleMessageListenerContainer listenerContainer = new SimpleMessageListenerContainer(connectionFactory);
        listenerContainer.setQueues(queues);
        return Amqp.inboundGateway(listenerContainer);
    }

    public static AmqpInboundGatewaySMLCSpec inboundGateway(ConnectionFactory connectionFactory, AmqpTemplate amqpTemplate, Queue ... queues) {
        SimpleMessageListenerContainer listenerContainer = new SimpleMessageListenerContainer(connectionFactory);
        listenerContainer.setQueues(queues);
        return Amqp.inboundGateway(listenerContainer, amqpTemplate);
    }

    public static AmqpInboundGatewaySMLCSpec inboundGateway(SimpleMessageListenerContainer listenerContainer) {
        return new AmqpInboundGatewaySMLCSpec(listenerContainer);
    }

    public static AmqpInboundGatewaySMLCSpec inboundGateway(SimpleMessageListenerContainer listenerContainer, AmqpTemplate amqpTemplate) {
        return new AmqpInboundGatewaySMLCSpec(listenerContainer, amqpTemplate);
    }

    public static AmqpInboundGatewayDMLCSpec inboundGateway(DirectMessageListenerContainer listenerContainer) {
        return new AmqpInboundGatewayDMLCSpec(listenerContainer);
    }

    public static AmqpInboundGatewayDMLCSpec inboundGateway(DirectMessageListenerContainer listenerContainer, AmqpTemplate amqpTemplate) {
        return new AmqpInboundGatewayDMLCSpec(listenerContainer, amqpTemplate);
    }

    public static AmqpInboundPolledChannelAdapterSpec inboundPolledAdapter(ConnectionFactory connectionFactory, String queue) {
        return new AmqpInboundPolledChannelAdapterSpec(connectionFactory, queue);
    }

    public static AmqpInboundPolledChannelAdapterSpec inboundPolledAdapter(ConnectionFactory connectionFactory, AmqpMessageSource.AmqpAckCallbackFactory ackCallbackFactory, String queue) {
        return new AmqpInboundPolledChannelAdapterSpec(connectionFactory, ackCallbackFactory, queue);
    }

    public static AmqpInboundChannelAdapterSMLCSpec inboundAdapter(ConnectionFactory connectionFactory, String ... queueNames) {
        SimpleMessageListenerContainer listenerContainer = new SimpleMessageListenerContainer(connectionFactory);
        listenerContainer.setQueueNames(queueNames);
        return new AmqpInboundChannelAdapterSMLCSpec(listenerContainer);
    }

    public static AmqpInboundChannelAdapterSMLCSpec inboundAdapter(ConnectionFactory connectionFactory, Queue ... queues) {
        SimpleMessageListenerContainer listenerContainer = new SimpleMessageListenerContainer(connectionFactory);
        listenerContainer.setQueues(queues);
        return new AmqpInboundChannelAdapterSMLCSpec(listenerContainer);
    }

    public static AmqpInboundChannelAdapterSMLCSpec inboundAdapter(SimpleMessageListenerContainer listenerContainer) {
        return new AmqpInboundChannelAdapterSMLCSpec(listenerContainer);
    }

    public static AmqpInboundChannelAdapterDMLCSpec inboundAdapter(DirectMessageListenerContainer listenerContainer) {
        return new AmqpInboundChannelAdapterDMLCSpec(listenerContainer);
    }

    public static AmqpOutboundChannelAdapterSpec outboundAdapter(AmqpTemplate amqpTemplate) {
        return new AmqpOutboundChannelAdapterSpec(amqpTemplate);
    }

    public static AmqpOutboundGatewaySpec outboundGateway(AmqpTemplate amqpTemplate) {
        return new AmqpOutboundGatewaySpec(amqpTemplate);
    }

    public static AmqpAsyncOutboundGatewaySpec asyncOutboundGateway(AsyncRabbitTemplate asyncRabbitTemplate) {
        return new AmqpAsyncOutboundGatewaySpec(asyncRabbitTemplate);
    }

    public static AmqpPollableMessageChannelSpec<?, PollableAmqpChannel> pollableChannel(ConnectionFactory connectionFactory) {
        return Amqp.pollableChannel(null, connectionFactory);
    }

    public static AmqpPollableMessageChannelSpec<?, PollableAmqpChannel> pollableChannel(@Nullable String id, ConnectionFactory connectionFactory) {
        AmqpPollableMessageChannelSpec spec = new AmqpPollableMessageChannelSpec(connectionFactory);
        return spec.id(id);
    }

    public static AmqpMessageChannelSpec<?, ?> channel(ConnectionFactory connectionFactory) {
        return Amqp.channel(null, connectionFactory);
    }

    public static AmqpMessageChannelSpec<?, ?> channel(@Nullable String id, ConnectionFactory connectionFactory) {
        return (AmqpMessageChannelSpec)((Object)new AmqpMessageChannelSpec(connectionFactory).id(id));
    }

    public static AmqpPublishSubscribeMessageChannelSpec publishSubscribeChannel(ConnectionFactory connectionFactory) {
        return Amqp.publishSubscribeChannel(null, connectionFactory);
    }

    public static AmqpPublishSubscribeMessageChannelSpec publishSubscribeChannel(@Nullable String id, ConnectionFactory connectionFactory) {
        return (AmqpPublishSubscribeMessageChannelSpec)((Object)new AmqpPublishSubscribeMessageChannelSpec(connectionFactory).id(id));
    }

    private Amqp() {
    }
}

