/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.mediatype.alps;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.Objects;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.NullUnmarked;
import org.springframework.hateoas.mediatype.alps.Format;
import org.springframework.util.Assert;

@JsonPropertyOrder(value={"format", "href", "value"})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@NullUnmarked
public final class Doc {
    private final String href;
    private final String value;
    private final Format format;

    public Doc(@NonNull String value, @NonNull Format format) {
        Assert.hasText((String)value, (String)"Value must not be null or empty!");
        Assert.notNull((Object)((Object)format), (String)"Format must not be null!");
        this.href = null;
        this.value = value;
        this.format = format;
    }

    @JsonCreator
    private Doc(@JsonProperty(value="href") String href, @JsonProperty(value="value") String value, @JsonProperty(value="format") Format format) {
        this.href = href;
        this.value = value;
        this.format = format;
    }

    public static DocBuilder builder() {
        return new DocBuilder();
    }

    @JsonProperty
    public String getHref() {
        return this.href;
    }

    @JsonProperty
    public String getValue() {
        return this.value;
    }

    @JsonProperty
    public Format getFormat() {
        return this.format;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Doc)) {
            return false;
        }
        Doc that = (Doc)obj;
        return Objects.equals(this.href, that.href) && Objects.equals(this.value, that.value) && this.format == that.format;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.href, this.value, this.format});
    }

    public String toString() {
        return "Doc(href=" + this.href + ", value=" + this.value + ", format=" + String.valueOf((Object)this.format) + ")";
    }

    public static class DocBuilder {
        private String href;
        private String value;
        private Format format;

        DocBuilder() {
        }

        public DocBuilder href(@NonNull String href) {
            this.href = href;
            return this;
        }

        public DocBuilder value(@NonNull String value) {
            this.value = value;
            return this;
        }

        public DocBuilder format(@NonNull Format format) {
            this.format = format;
            return this;
        }

        public Doc build() {
            return new Doc(this.href, this.value, this.format);
        }

        public String toString() {
            return "Doc.DocBuilder(href=" + this.href + ", value=" + this.value + ", format=" + String.valueOf((Object)this.format) + ")";
        }
    }
}

