/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.mediatype;

import java.util.function.Supplier;
import java.util.stream.Stream;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.hateoas.mediatype.MediaTypeConfigurationCustomizer;
import org.springframework.util.Assert;

public class MediaTypeConfigurationFactory<T, S extends MediaTypeConfigurationCustomizer<T>> {
    private final Supplier<T> supplier;
    private final Supplier<Stream<S>> customizers;
    private @Nullable T resolved;

    MediaTypeConfigurationFactory(Supplier<T> supplier, Supplier<Stream<S>> customizers) {
        Assert.notNull(supplier, (String)"Supplier must not be null!");
        Assert.notNull(customizers, (String)"Customizers must not be null!");
        this.supplier = supplier;
        this.customizers = customizers;
    }

    public MediaTypeConfigurationFactory(Supplier<T> supplier, ObjectProvider<S> customizers) {
        this(supplier, () -> customizers.orderedStream());
    }

    public T getConfiguration() {
        if (this.resolved == null) {
            T source = this.supplier.get();
            Assert.notNull(source, (String)"Source instance must not be null!");
            this.resolved = this.customizers.get().reduce(source, (config, customizer) -> customizer.customize(config), (__, r) -> r);
        }
        return this.resolved;
    }
}

