/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.mediatype.uber;

import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Arrays;
import org.jspecify.annotations.Nullable;
import org.springframework.hateoas.mediatype.uber.Jackson2UberModule;
import org.springframework.http.HttpMethod;

@JsonDeserialize(using=Jackson2UberModule.UberActionDeserializer.class)
enum UberAction {
    APPEND(HttpMethod.POST),
    PARTIAL(HttpMethod.PATCH),
    READ(HttpMethod.GET),
    REMOVE(HttpMethod.DELETE),
    REPLACE(HttpMethod.PUT);

    private final HttpMethod httpMethod;

    private UberAction(HttpMethod method) {
        this.httpMethod = method;
    }

    HttpMethod getMethod() {
        return this.httpMethod;
    }

    @JsonValue
    public String toString() {
        return this.name().toLowerCase();
    }

    static UberAction fromMethod(HttpMethod method) {
        return Arrays.stream(UberAction.values()).filter(action -> action.httpMethod == method).findFirst().orElseThrow(() -> new IllegalArgumentException("Unsupported method: " + String.valueOf(method)));
    }

    static @Nullable UberAction forRequestMethod(HttpMethod method) {
        return HttpMethod.GET == method ? null : UberAction.fromMethod(method);
    }
}

