/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.mediatype.hal.forms;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import org.jspecify.annotations.Nullable;
import org.springframework.core.ResolvableType;
import org.springframework.hateoas.AffordanceModel;
import org.springframework.hateoas.MediaTypes;
import org.springframework.hateoas.mediatype.hal.HalConfiguration;
import org.springframework.hateoas.mediatype.hal.forms.HalFormsOptions;
import org.springframework.hateoas.mediatype.hal.forms.HalFormsOptionsFactory;
import org.springframework.http.MediaType;
import org.springframework.lang.Contract;
import org.springframework.util.Assert;

public class HalFormsConfiguration {
    private final HalConfiguration halConfiguration;
    private final Map<Class<?>, String> patterns;
    private final Consumer<ObjectMapper> objectMapperCustomizer;
    private final HalFormsOptionsFactory options;
    private final List<MediaType> mediaTypes;
    private final boolean defaultSingleTemplate;

    public HalFormsConfiguration() {
        this(new HalConfiguration());
    }

    public HalFormsConfiguration(HalConfiguration halConfiguration) {
        this(halConfiguration, new HashMap(), new HalFormsOptionsFactory(), __ -> {}, Collections.singletonList(MediaTypes.HAL_FORMS_JSON), false);
    }

    private HalFormsConfiguration(HalConfiguration halConfiguration, Map<Class<?>, String> patterns, HalFormsOptionsFactory options, @Nullable Consumer<ObjectMapper> objectMapperCustomizer, List<MediaType> mediaTypes, boolean defaultSingleTemplate) {
        Assert.notNull((Object)halConfiguration, (String)"HalConfiguration must not be null!");
        Assert.notNull(patterns, (String)"Patterns must not be null!");
        Assert.notNull(objectMapperCustomizer, (String)"ObjectMapper customizer must not be null!");
        Assert.notNull((Object)options, (String)"HalFormsSuggests must not be null!");
        Assert.notNull(mediaTypes, (String)"Media types must not be null!");
        this.halConfiguration = halConfiguration;
        this.patterns = patterns;
        this.objectMapperCustomizer = objectMapperCustomizer;
        this.options = options;
        this.mediaTypes = new ArrayList<MediaType>(mediaTypes);
        this.defaultSingleTemplate = defaultSingleTemplate;
    }

    public HalFormsConfiguration withPattern(Class<?> type, String pattern) {
        Assert.notNull(type, (String)"Type must not be null!");
        Assert.hasText((String)pattern, (String)"Pattern must not be null or empty!");
        HashMap newPatterns = new HashMap(this.patterns);
        newPatterns.put(type, pattern);
        return new HalFormsConfiguration(this.halConfiguration, newPatterns, this.options, this.objectMapperCustomizer, this.mediaTypes, this.defaultSingleTemplate);
    }

    public HalFormsConfiguration withObjectMapperCustomizer(Consumer<ObjectMapper> objectMapperCustomizer) {
        Assert.notNull(objectMapperCustomizer, (String)"ObjectMapper customizer must not be null!");
        return this.objectMapperCustomizer == objectMapperCustomizer ? this : new HalFormsConfiguration(this.halConfiguration, this.patterns, this.options, objectMapperCustomizer, this.mediaTypes, this.defaultSingleTemplate);
    }

    public HalFormsConfiguration withMediaType(MediaType mediaType) {
        Assert.notNull((Object)mediaType, (String)"MediaType must not be null!");
        if (this.mediaTypes.contains(mediaType)) {
            return this;
        }
        ArrayList<MediaType> newMediaTypes = new ArrayList<MediaType>(this.mediaTypes);
        newMediaTypes.add(this.mediaTypes.size() - 1, mediaType);
        return new HalFormsConfiguration(this.halConfiguration, this.patterns, this.options, this.objectMapperCustomizer, newMediaTypes, this.defaultSingleTemplate);
    }

    @Contract(value="_ -> this")
    public HalFormsConfiguration customize(ObjectMapper mapper) {
        Assert.notNull((Object)mapper, (String)"ObjectMapper must not be null!");
        this.objectMapperCustomizer.accept(mapper);
        return this;
    }

    public <T> HalFormsConfiguration withOptions(Class<T> type, String property, Function<AffordanceModel.PropertyMetadata, HalFormsOptions> creator) {
        return new HalFormsConfiguration(this.halConfiguration, this.patterns, this.options.withOptions(type, property, creator), this.objectMapperCustomizer, this.mediaTypes, this.defaultSingleTemplate);
    }

    public HalFormsConfiguration withDefaultSingleTemplate(boolean defaultSingleTemplate) {
        return new HalFormsConfiguration(this.halConfiguration, this.patterns, this.options, this.objectMapperCustomizer, this.mediaTypes, defaultSingleTemplate);
    }

    public HalConfiguration getHalConfiguration() {
        return this.halConfiguration;
    }

    HalFormsOptionsFactory getOptionsFactory() {
        return this.options;
    }

    Optional<String> getTypePatternFor(ResolvableType type) {
        return Optional.ofNullable(this.patterns.get(type.resolve(Object.class)));
    }

    List<MediaType> getMediaTypes() {
        return Collections.unmodifiableList(this.mediaTypes);
    }

    boolean isDefaultSingleTemplate() {
        return this.defaultSingleTemplate;
    }
}

