/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.aot;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aot.hint.MemberCategory;
import org.springframework.aot.hint.ReflectionHints;
import org.springframework.aot.hint.TypeReference;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.ResolvableType;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.core.type.classreading.MetadataReaderFactory;
import org.springframework.core.type.filter.AssignableTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.hateoas.CollectionModel;
import org.springframework.hateoas.EntityModel;
import org.springframework.http.HttpEntity;
import org.springframework.util.ClassUtils;

class AotUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(AotUtils.class);
    private static final List<Class<?>> MODEL_TYPES = List.of(EntityModel.class, CollectionModel.class);
    private static final Set<Class<?>> SEEN_TYPES = new HashSet();

    AotUtils() {
    }

    public static void registerModelDomainTypesForReflection(ResolvableType type, ReflectionHints reflection, Class<?> context) {
        if (HttpEntity.class.isAssignableFrom(type.resolve(Object.class))) {
            AotUtils.registerModelDomainTypesForReflection(type.as(HttpEntity.class).getGeneric(new int[]{0}), reflection, context);
        }
        MODEL_TYPES.stream().flatMap(it -> AotUtils.extractGenerics(it, type).stream()).forEach(it -> AotUtils.registerTypeForReflection(it, reflection, context));
    }

    public static void registerTypeForReflection(Class<?> type, ReflectionHints reflection, Class<?> context) {
        if (SEEN_TYPES.contains(type)) {
            return;
        }
        LOGGER.info("Registering {} for reflection (for {})", (Object)type.getName(), (Object)context.getName());
        reflection.registerType(type, new MemberCategory[]{MemberCategory.INVOKE_DECLARED_METHODS, MemberCategory.INTROSPECT_DECLARED_CONSTRUCTORS});
        SEEN_TYPES.add(type);
    }

    public static void registerTypesForReflection(String packageName, ReflectionHints reflection, TypeFilter ... filters) {
        FullTypeScanner provider = AotUtils.getScanner(packageName, filters);
        LOGGER.info("Registering Spring HATEOAS types in {} for reflection.", (Object)packageName);
        provider.findClasses().sorted(Comparator.comparing(TypeReference::getName)).peek(type -> LOGGER.debug("> {}", (Object)type.getName())).forEach(reference -> reflection.registerType(reference, new MemberCategory[]{MemberCategory.INVOKE_DECLARED_CONSTRUCTORS, MemberCategory.INVOKE_DECLARED_METHODS}));
    }

    private static Optional<Class<?>> extractGenerics(Class<?> modelType, ResolvableType type) {
        if (!modelType.isAssignableFrom(type.resolve(Object.class))) {
            return Optional.empty();
        }
        ResolvableType unresolved = type.as(modelType).getGeneric(new int[]{0});
        Class resolved = unresolved.resolve();
        if (resolved == null) {
            return Optional.empty();
        }
        List<Class> nested = MODEL_TYPES.stream().filter(it -> it.isAssignableFrom(resolved)).toList();
        if (nested.isEmpty()) {
            return Optional.of(resolved);
        }
        return nested.stream().flatMap(it -> AotUtils.extractGenerics(it, unresolved).stream()).findFirst();
    }

    public static FullTypeScanner getScanner(String packageName, TypeFilter ... includeFilters) {
        ClassPathScanningCandidateComponentProvider provider = new ClassPathScanningCandidateComponentProvider(false){

            protected boolean isCandidateComponent(AnnotatedBeanDefinition beanDefinition) {
                return super.isCandidateComponent(beanDefinition) || beanDefinition.getMetadata().isAbstract();
            }
        };
        ArrayList<TypeFilter> filters = new ArrayList<TypeFilter>();
        filters.add(new EnforcedPackageFilter(packageName));
        filters.add((TypeFilter)new AssignableTypeFilter(Object.class));
        if (includeFilters.length == 0) {
            provider.addIncludeFilter(AotUtils.all(filters));
        }
        for (TypeFilter filter : includeFilters) {
            ArrayList<TypeFilter> includeFilterComponents = new ArrayList<TypeFilter>(filters);
            includeFilterComponents.add(filter);
            provider.addIncludeFilter(AotUtils.all(includeFilterComponents));
        }
        return () -> AotUtils.lambda$getScanner$6(provider, packageName);
    }

    private static TypeFilter all(final Collection<TypeFilter> filters) {
        return new TypeFilter(){

            public boolean match(MetadataReader metadataReader, MetadataReaderFactory metadataReaderFactory) throws IOException {
                for (TypeFilter filter : filters) {
                    if (filter.match(metadataReader, metadataReaderFactory)) continue;
                    return false;
                }
                return true;
            }
        };
    }

    private static /* synthetic */ Stream lambda$getScanner$6(1 provider, String packageName) {
        return provider.findCandidateComponents(packageName).stream().map(BeanDefinition::getBeanClassName).map(TypeReference::of);
    }

    static interface FullTypeScanner {
        public Stream<TypeReference> findClasses();
    }

    static class EnforcedPackageFilter
    implements TypeFilter {
        private final String referencePackage;

        public EnforcedPackageFilter(String referencePackage) {
            this.referencePackage = referencePackage;
        }

        public boolean match(MetadataReader metadataReader, MetadataReaderFactory metadataReaderFactory) throws IOException {
            return this.referencePackage.equals(ClassUtils.getPackageName((String)metadataReader.getClassMetadata().getClassName()));
        }
    }
}

