/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import org.springframework.core.ResolvableType;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.QueryParameter;
import org.springframework.http.HttpMethod;
import org.springframework.util.Assert;

public abstract class AffordanceModel {
    private String name;
    private Link link;
    private HttpMethod httpMethod;
    private InputPayloadMetadata input;
    private List<QueryParameter> queryMethodParameters;
    private PayloadMetadata output;

    public AffordanceModel(String name, Link link, HttpMethod httpMethod, InputPayloadMetadata input, List<QueryParameter> queryMethodParameters, PayloadMetadata output) {
        this.name = name;
        this.link = link;
        this.httpMethod = httpMethod;
        this.input = input;
        this.queryMethodParameters = queryMethodParameters;
        this.output = output;
    }

    public String getURI() {
        return this.link.expand(new Object[0]).getHref();
    }

    public boolean hasHttpMethod(HttpMethod method) {
        Assert.notNull((Object)method, (String)"HttpMethod must not be null!");
        return this.httpMethod.equals((Object)method);
    }

    public boolean pointsToTargetOf(Link link) {
        Assert.notNull((Object)link, (String)"Link must not be null!");
        return this.getURI().equals(link.expand(new Object[0]).getHref());
    }

    public String getName() {
        return this.name;
    }

    public Link getLink() {
        return this.link;
    }

    public HttpMethod getHttpMethod() {
        return this.httpMethod;
    }

    public InputPayloadMetadata getInput() {
        return this.input;
    }

    public List<QueryParameter> getQueryMethodParameters() {
        return this.queryMethodParameters;
    }

    public PayloadMetadata getOutput() {
        return this.output;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AffordanceModel that = (AffordanceModel)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.link, that.link) && this.httpMethod == that.httpMethod && Objects.equals(this.input, that.input) && Objects.equals(this.queryMethodParameters, that.queryMethodParameters) && Objects.equals(this.output, that.output);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.link, this.httpMethod, this.input, this.queryMethodParameters, this.output);
    }

    private static enum NoPayloadMetadata implements PayloadMetadata
    {
        INSTANCE;


        @Override
        public Stream<PropertyMetadata> stream() {
            return Stream.empty();
        }
    }

    public static interface Named {
        public String getName();
    }

    public static interface PropertyMetadataConfigured<T> {
        public T apply(PropertyMetadata var1);
    }

    public static interface PropertyMetadata {
        public String getName();

        default public boolean hasName(String name) {
            Assert.hasText((String)name, (String)"Name must not be null or empty!");
            return this.getName().equals(name);
        }

        public boolean isRequired();

        public boolean isReadOnly();

        public Optional<String> getPattern();

        public ResolvableType getType();
    }

    private static class DelegatingInputPayloadMetadata
    implements InputPayloadMetadata {
        private final PayloadMetadata metadata;

        public static DelegatingInputPayloadMetadata of(PayloadMetadata metadata) {
            return new DelegatingInputPayloadMetadata(metadata);
        }

        private DelegatingInputPayloadMetadata(PayloadMetadata metadata) {
            this.metadata = metadata;
        }

        @Override
        public Stream<PropertyMetadata> stream() {
            return this.metadata.stream();
        }

        @Override
        public <T extends PropertyMetadataConfigured<T> & Named> T applyTo(T target) {
            return target;
        }

        @Override
        public <T extends Named> T customize(T target, Function<PropertyMetadata, T> customizer) {
            return target;
        }

        @Override
        public List<String> getI18nCodes() {
            return Collections.emptyList();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DelegatingInputPayloadMetadata that = (DelegatingInputPayloadMetadata)o;
            return Objects.equals(this.metadata, that.metadata);
        }

        public int hashCode() {
            return Objects.hash(this.metadata);
        }

        public String toString() {
            return "AffordanceModel.DelegatingInputPayloadMetadata(metadata=" + this.metadata + ")";
        }
    }

    public static interface InputPayloadMetadata
    extends PayloadMetadata {
        public static final InputPayloadMetadata NONE = InputPayloadMetadata.from(PayloadMetadata.NONE);

        public static InputPayloadMetadata from(PayloadMetadata metadata) {
            return InputPayloadMetadata.class.isInstance(metadata) ? (InputPayloadMetadata)InputPayloadMetadata.class.cast(metadata) : DelegatingInputPayloadMetadata.of(metadata);
        }

        public <T extends PropertyMetadataConfigured<T> & Named> T applyTo(T var1);

        public <T extends Named> T customize(T var1, Function<PropertyMetadata, T> var2);

        public List<String> getI18nCodes();
    }

    public static interface PayloadMetadata {
        public static final PayloadMetadata NONE = NoPayloadMetadata.INSTANCE;

        public Stream<PropertyMetadata> stream();

        default public Optional<PropertyMetadata> getPropertyMetadata(String name) {
            return this.stream().filter(it -> it.hasName(name)).findFirst();
        }
    }
}

