/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.mediatype.hal.forms;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.Links;
import org.springframework.hateoas.PagedModel;
import org.springframework.hateoas.RepresentationModel;
import org.springframework.hateoas.mediatype.PropertyUtils;
import org.springframework.hateoas.mediatype.hal.HalLinkRelation;
import org.springframework.hateoas.mediatype.hal.Jackson2HalModule;
import org.springframework.hateoas.mediatype.hal.forms.HalFormsTemplate;
import org.springframework.hateoas.mediatype.hal.forms.Jackson2HalFormsModule;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

@JsonPropertyOrder(value={"attributes", "entity", "entities", "embedded", "links", "templates", "metadata"})
public final class HalFormsDocument<T> {
    @Nullable
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private final Map<String, Object> attributes;
    @Nullable
    @JsonUnwrapped
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private final T entity;
    @Nullable
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonIgnore
    private final Collection<T> entities;
    @JsonProperty(value="_embedded")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private final Map<HalLinkRelation, Object> embedded;
    @Nullable
    @JsonProperty(value="page")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private final PagedModel.PageMetadata pageMetadata;
    @JsonProperty(value="_links")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonSerialize(using=Jackson2HalModule.HalLinkListSerializer.class)
    @JsonDeserialize(using=Jackson2HalFormsModule.HalFormsLinksDeserializer.class)
    private final Links links;
    @JsonProperty(value="_templates")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private final Map<String, HalFormsTemplate> templates;

    private HalFormsDocument() {
        this(null, null, null, Collections.emptyMap(), null, Links.NONE, Collections.emptyMap());
    }

    public static HalFormsDocument<?> forRepresentationModel(RepresentationModel<?> model) {
        Map<String, Object> attributes = PropertyUtils.extractPropertyValues(model);
        attributes.remove("links");
        return super.withAttributes(attributes);
    }

    public static <T> HalFormsDocument<T> forEntity(@Nullable T resource) {
        return super.withEntity(resource);
    }

    public static <T> HalFormsDocument<T> forEntities(Collection<T> entities) {
        Assert.notNull(entities, (String)"Resources must not be null!");
        return super.withEntities(entities);
    }

    public static HalFormsDocument<?> empty() {
        return new HalFormsDocument();
    }

    @JsonIgnore
    public HalFormsTemplate getDefaultTemplate() {
        return this.getTemplate("default");
    }

    @JsonIgnore
    public HalFormsTemplate getTemplate(String key) {
        Assert.notNull((Object)key, (String)"Template key must not be null!");
        return this.templates.get(key);
    }

    public HalFormsDocument<T> withPageMetadata(@Nullable PagedModel.PageMetadata metadata) {
        return new HalFormsDocument<T>(this.attributes, this.entity, this.entities, this.embedded, metadata, this.links, this.templates);
    }

    private HalFormsDocument<T> withEntity(@Nullable T entity) {
        return new HalFormsDocument<T>(this.attributes, entity, this.entities, this.embedded, this.pageMetadata, this.links, this.templates);
    }

    public HalFormsDocument<T> andLink(Link link) {
        Assert.notNull((Object)link, (String)"Link must not be null!");
        return new HalFormsDocument<T>(this.attributes, this.entity, this.entities, this.embedded, this.pageMetadata, this.links.and(link), this.templates);
    }

    public HalFormsDocument<T> andTemplate(String name, HalFormsTemplate template) {
        Assert.hasText((String)name, (String)"Template name must not be null or empty!");
        Assert.notNull((Object)template, (String)"Template must not be null!");
        HashMap<String, HalFormsTemplate> templates = new HashMap<String, HalFormsTemplate>(this.templates);
        templates.put(name, template);
        return new HalFormsDocument<T>(this.attributes, this.entity, this.entities, this.embedded, this.pageMetadata, this.links, templates);
    }

    public HalFormsDocument<T> andEmbedded(HalLinkRelation key, Object value) {
        Assert.notNull((Object)key, (String)"Embedded key must not be null!");
        Assert.notNull((Object)value, (String)"Embedded value must not be null!");
        HashMap<HalLinkRelation, Object> embedded = new HashMap<HalLinkRelation, Object>(this.embedded);
        embedded.put(key, value);
        return new HalFormsDocument<T>(this.attributes, this.entity, this.entities, embedded, this.pageMetadata, this.links, this.templates);
    }

    @Nullable
    @Generated
    public T getEntity() {
        return this.entity;
    }

    @Nullable
    @Generated
    public Collection<T> getEntities() {
        return this.entities;
    }

    @Generated
    public Map<HalLinkRelation, Object> getEmbedded() {
        return this.embedded;
    }

    @Nullable
    @Generated
    public PagedModel.PageMetadata getPageMetadata() {
        return this.pageMetadata;
    }

    @Generated
    public Links getLinks() {
        return this.links;
    }

    @Generated
    public Map<String, HalFormsTemplate> getTemplates() {
        return this.templates;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HalFormsDocument)) {
            return false;
        }
        HalFormsDocument other = (HalFormsDocument)o;
        Map<String, Object> this$attributes = this.getAttributes();
        Map<String, Object> other$attributes = other.getAttributes();
        if (this$attributes == null ? other$attributes != null : !((Object)this$attributes).equals(other$attributes)) {
            return false;
        }
        T this$entity = this.getEntity();
        T other$entity = other.getEntity();
        if (this$entity == null ? other$entity != null : !this$entity.equals(other$entity)) {
            return false;
        }
        Collection<T> this$entities = this.getEntities();
        Collection<T> other$entities = other.getEntities();
        if (this$entities == null ? other$entities != null : !((Object)this$entities).equals(other$entities)) {
            return false;
        }
        Map<HalLinkRelation, Object> this$embedded = this.getEmbedded();
        Map<HalLinkRelation, Object> other$embedded = other.getEmbedded();
        if (this$embedded == null ? other$embedded != null : !((Object)this$embedded).equals(other$embedded)) {
            return false;
        }
        PagedModel.PageMetadata this$pageMetadata = this.getPageMetadata();
        PagedModel.PageMetadata other$pageMetadata = other.getPageMetadata();
        if (this$pageMetadata == null ? other$pageMetadata != null : !((Object)this$pageMetadata).equals(other$pageMetadata)) {
            return false;
        }
        Links this$links = this.getLinks();
        Links other$links = other.getLinks();
        if (this$links == null ? other$links != null : !((Object)this$links).equals(other$links)) {
            return false;
        }
        Map<String, HalFormsTemplate> this$templates = this.getTemplates();
        Map<String, HalFormsTemplate> other$templates = other.getTemplates();
        return !(this$templates == null ? other$templates != null : !((Object)this$templates).equals(other$templates));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, Object> $attributes = this.getAttributes();
        result = result * 59 + ($attributes == null ? 43 : ((Object)$attributes).hashCode());
        T $entity = this.getEntity();
        result = result * 59 + ($entity == null ? 43 : $entity.hashCode());
        Collection<T> $entities = this.getEntities();
        result = result * 59 + ($entities == null ? 43 : ((Object)$entities).hashCode());
        Map<HalLinkRelation, Object> $embedded = this.getEmbedded();
        result = result * 59 + ($embedded == null ? 43 : ((Object)$embedded).hashCode());
        PagedModel.PageMetadata $pageMetadata = this.getPageMetadata();
        result = result * 59 + ($pageMetadata == null ? 43 : ((Object)$pageMetadata).hashCode());
        Links $links = this.getLinks();
        result = result * 59 + ($links == null ? 43 : ((Object)$links).hashCode());
        Map<String, HalFormsTemplate> $templates = this.getTemplates();
        result = result * 59 + ($templates == null ? 43 : ((Object)$templates).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "HalFormsDocument(attributes=" + this.getAttributes() + ", entity=" + this.getEntity() + ", entities=" + this.getEntities() + ", embedded=" + this.getEmbedded() + ", pageMetadata=" + this.getPageMetadata() + ", links=" + this.getLinks() + ", templates=" + this.getTemplates() + ")";
    }

    @Generated
    public HalFormsDocument<T> withEmbedded(Map<HalLinkRelation, Object> embedded) {
        return this.embedded == embedded ? this : new HalFormsDocument<T>(this.attributes, this.entity, this.entities, embedded, this.pageMetadata, this.links, this.templates);
    }

    @Generated
    public HalFormsDocument<T> withLinks(Links links) {
        return this.links == links ? this : new HalFormsDocument<T>(this.attributes, this.entity, this.entities, this.embedded, this.pageMetadata, links, this.templates);
    }

    @Generated
    public HalFormsDocument<T> withTemplates(Map<String, HalFormsTemplate> templates) {
        return this.templates == templates ? this : new HalFormsDocument<T>(this.attributes, this.entity, this.entities, this.embedded, this.pageMetadata, this.links, templates);
    }

    @Generated
    HalFormsDocument(@Nullable Map<String, Object> attributes, @Nullable T entity, @Nullable Collection<T> entities, Map<HalLinkRelation, Object> embedded, @Nullable PagedModel.PageMetadata pageMetadata, Links links, Map<String, HalFormsTemplate> templates) {
        this.attributes = attributes;
        this.entity = entity;
        this.entities = entities;
        this.embedded = embedded;
        this.pageMetadata = pageMetadata;
        this.links = links;
        this.templates = templates;
    }

    @JsonAnyGetter
    @Nullable
    @Generated
    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    @Generated
    private HalFormsDocument<T> withAttributes(@Nullable Map<String, Object> attributes) {
        return this.attributes == attributes ? this : new HalFormsDocument<T>(attributes, this.entity, this.entities, this.embedded, this.pageMetadata, this.links, this.templates);
    }

    @Generated
    private HalFormsDocument<T> withEntities(@Nullable Collection<T> entities) {
        return this.entities == entities ? this : new HalFormsDocument<T>(this.attributes, this.entity, entities, this.embedded, this.pageMetadata, this.links, this.templates);
    }
}

