/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.client;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.springframework.http.HttpHeaders;
import org.springframework.util.Assert;

public final class Hop {
    private final String rel;
    private final Map<String, Object> parameters;
    private final HttpHeaders headers;

    public static Hop rel(String rel) {
        Assert.hasText((String)rel, (String)"Relation must not be null or empty!");
        return new Hop(rel, Collections.emptyMap(), HttpHeaders.EMPTY);
    }

    public Hop withParameter(String name, Object value) {
        Assert.hasText((String)name, (String)"Name must not be null or empty!");
        HashMap<String, Object> parameters = new HashMap<String, Object>(this.parameters);
        parameters.put(name, value);
        return new Hop(this.rel, parameters, this.headers);
    }

    public Hop header(String headerName, String headerValue) {
        Assert.hasText((String)headerName, (String)"headerName must not be null or empty!");
        if (this.headers == HttpHeaders.EMPTY) {
            HttpHeaders newHeaders = new HttpHeaders();
            newHeaders.add(headerName, headerValue);
            return new Hop(this.rel, this.parameters, newHeaders);
        }
        this.headers.add(headerName, headerValue);
        return this;
    }

    boolean hasParameters() {
        return !this.parameters.isEmpty();
    }

    Map<String, Object> getMergedParameters(Map<String, Object> globalParameters) {
        Assert.notNull(globalParameters, (String)"Global parameters must not be null!");
        HashMap<String, Object> mergedParameters = new HashMap<String, Object>();
        mergedParameters.putAll(globalParameters);
        mergedParameters.putAll(this.parameters);
        return mergedParameters;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Hop)) {
            return false;
        }
        Hop other = (Hop)o;
        String this$rel = this.getRel();
        String other$rel = other.getRel();
        if (this$rel == null ? other$rel != null : !this$rel.equals(other$rel)) {
            return false;
        }
        Map<String, Object> this$parameters = this.getParameters();
        Map<String, Object> other$parameters = other.getParameters();
        if (this$parameters == null ? other$parameters != null : !((Object)this$parameters).equals(other$parameters)) {
            return false;
        }
        HttpHeaders this$headers = this.getHeaders();
        HttpHeaders other$headers = other.getHeaders();
        return !(this$headers == null ? other$headers != null : !this$headers.equals(other$headers));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $rel = this.getRel();
        result = result * 59 + ($rel == null ? 43 : $rel.hashCode());
        Map<String, Object> $parameters = this.getParameters();
        result = result * 59 + ($parameters == null ? 43 : ((Object)$parameters).hashCode());
        HttpHeaders $headers = this.getHeaders();
        result = result * 59 + ($headers == null ? 43 : $headers.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Hop(rel=" + this.getRel() + ", parameters=" + this.getParameters() + ", headers=" + this.getHeaders() + ")";
    }

    @Generated
    private Hop(String rel, Map<String, Object> parameters, HttpHeaders headers) {
        this.rel = rel;
        this.parameters = parameters;
        this.headers = headers;
    }

    @Generated
    String getRel() {
        return this.rel;
    }

    @Generated
    Map<String, Object> getParameters() {
        return this.parameters;
    }

    @Generated
    HttpHeaders getHeaders() {
        return this.headers;
    }

    @Generated
    public Hop withParameters(Map<String, Object> parameters) {
        return this.parameters == parameters ? this : new Hop(this.rel, parameters, this.headers);
    }

    @Generated
    public Hop withHeaders(HttpHeaders headers) {
        return this.headers == headers ? this : new Hop(this.rel, this.parameters, headers);
    }
}

