/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.springframework.context.annotation.Configuration;
import org.springframework.hateoas.config.HypermediaMappingInformation;
import org.springframework.http.codec.json.Jackson2JsonDecoder;
import org.springframework.http.codec.json.Jackson2JsonEncoder;
import org.springframework.util.MimeType;
import org.springframework.web.reactive.function.client.ExchangeStrategies;
import org.springframework.web.reactive.function.client.WebClient;

@Configuration
public class WebClientConfigurer {
    private final ObjectMapper mapper;
    private final List<HypermediaMappingInformation> hypermediaTypes;

    public ExchangeStrategies hypermediaExchangeStrategies() {
        ArrayList encoders = new ArrayList();
        ArrayList decoders = new ArrayList();
        this.hypermediaTypes.forEach(hypermedia -> {
            ObjectMapper objectMapper = hypermedia.configureObjectMapper(this.mapper.copy());
            MimeType[] mimeTypes = hypermedia.getMediaTypes().toArray(new MimeType[0]);
            encoders.add(new Jackson2JsonEncoder(objectMapper, mimeTypes));
            decoders.add(new Jackson2JsonDecoder(objectMapper, mimeTypes));
        });
        return ExchangeStrategies.builder().codecs(clientCodecConfigurer -> {
            encoders.forEach(encoder -> clientCodecConfigurer.customCodecs().encoder(encoder));
            decoders.forEach(decoder -> clientCodecConfigurer.customCodecs().decoder(decoder));
        }).build();
    }

    public WebClient registerHypermediaTypes(WebClient webClient) {
        return webClient.mutate().exchangeStrategies(this.hypermediaExchangeStrategies()).build();
    }

    @Generated
    public WebClientConfigurer(ObjectMapper mapper, List<HypermediaMappingInformation> hypermediaTypes) {
        this.mapper = mapper;
        this.hypermediaTypes = hypermediaTypes;
    }
}

