/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.mvc;

import java.beans.ConstructorProperties;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.hateoas.TemplateVariables;
import org.springframework.hateoas.core.AnnotationMappingDiscoverer;
import org.springframework.hateoas.core.DummyInvocationUtils;
import org.springframework.hateoas.core.LinkBuilderSupport;
import org.springframework.hateoas.core.MappingDiscoverer;
import org.springframework.hateoas.mvc.ControllerLinkBuilderFactory;
import org.springframework.hateoas.mvc.ForwardedHeader;
import org.springframework.util.Assert;
import org.springframework.util.ConcurrentReferenceHashMap;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;
import org.springframework.web.util.DefaultUriTemplateHandler;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;
import org.springframework.web.util.UriTemplate;

public class ControllerLinkBuilder
extends LinkBuilderSupport<ControllerLinkBuilder> {
    private static final String REQUEST_ATTRIBUTES_MISSING = "Could not find current request via RequestContextHolder. Is this being called from a Spring MVC handler?";
    private static final CachingAnnotationMappingDiscoverer DISCOVERER = new CachingAnnotationMappingDiscoverer(new AnnotationMappingDiscoverer(RequestMapping.class));
    private static final ControllerLinkBuilderFactory FACTORY = new ControllerLinkBuilderFactory();
    private static final CustomUriTemplateHandler HANDLER = new CustomUriTemplateHandler();
    private final TemplateVariables variables;

    ControllerLinkBuilder(UriComponentsBuilder builder) {
        super(builder);
        this.variables = TemplateVariables.NONE;
    }

    ControllerLinkBuilder(UriComponents uriComponents) {
        this(uriComponents, TemplateVariables.NONE);
    }

    ControllerLinkBuilder(UriComponents uriComponents, TemplateVariables variables) {
        super(uriComponents);
        this.variables = variables;
    }

    public static ControllerLinkBuilder linkTo(Class<?> controller) {
        return ControllerLinkBuilder.linkTo(controller, new Object[0]);
    }

    public static ControllerLinkBuilder linkTo(Class<?> controller, Object ... parameters) {
        Assert.notNull(controller, (String)"Controller must not be null!");
        Assert.notNull((Object)parameters, (String)"Parameters must not be null!");
        String mapping = DISCOVERER.getMapping(controller);
        UriComponentsBuilder builder = UriComponentsBuilder.fromUriString((String)(mapping == null ? "/" : mapping));
        UriComponents uriComponents = HANDLER.expandAndEncode(builder, parameters);
        return (ControllerLinkBuilder)new ControllerLinkBuilder(ControllerLinkBuilder.getBuilder()).slash(uriComponents, true);
    }

    public static ControllerLinkBuilder linkTo(Class<?> controller, Map<String, ?> parameters) {
        Assert.notNull(controller, (String)"Controller must not be null!");
        Assert.notNull(parameters, (String)"Parameters must not be null!");
        String mapping = DISCOVERER.getMapping(controller);
        UriComponentsBuilder builder = UriComponentsBuilder.fromUriString((String)(mapping == null ? "/" : mapping));
        UriComponents uriComponents = HANDLER.expandAndEncode(builder, parameters);
        return (ControllerLinkBuilder)new ControllerLinkBuilder(ControllerLinkBuilder.getBuilder()).slash(uriComponents, true);
    }

    public static ControllerLinkBuilder linkTo(Method method, Object ... parameters) {
        return ControllerLinkBuilder.linkTo(method.getDeclaringClass(), method, parameters);
    }

    public static ControllerLinkBuilder linkTo(Class<?> controller, Method method, Object ... parameters) {
        Assert.notNull(controller, (String)"Controller type must not be null!");
        Assert.notNull((Object)method, (String)"Method must not be null!");
        UriTemplate template = DISCOVERER.getMappingAsUriTemplate(controller, method);
        URI uri = template.expand(parameters);
        return (ControllerLinkBuilder)new ControllerLinkBuilder(ControllerLinkBuilder.getBuilder()).slash(uri);
    }

    public static ControllerLinkBuilder linkTo(Object invocationValue) {
        return FACTORY.linkTo(invocationValue);
    }

    public static <T> T methodOn(Class<T> controller, Object ... parameters) {
        return DummyInvocationUtils.methodOn(controller, parameters);
    }

    @Override
    protected ControllerLinkBuilder getThis() {
        return this;
    }

    @Override
    protected ControllerLinkBuilder createNewInstance(UriComponentsBuilder builder) {
        return new ControllerLinkBuilder(builder);
    }

    public UriComponentsBuilder toUriComponentsBuilder() {
        return UriComponentsBuilder.fromUri((URI)this.toUri());
    }

    @Override
    public String toString() {
        String result = super.toString();
        if (this.variables == TemplateVariables.NONE) {
            return result;
        }
        if (!result.contains("#")) {
            return result.concat(this.variables.toString());
        }
        String[] parts = result.split("#");
        return parts[0].concat(this.variables.toString()).concat("#").concat(parts[0]);
    }

    static UriComponentsBuilder getBuilder() {
        String proto;
        if (RequestContextHolder.getRequestAttributes() == null) {
            return UriComponentsBuilder.fromPath((String)"/");
        }
        HttpServletRequest request = ControllerLinkBuilder.getCurrentRequest();
        ServletUriComponentsBuilder builder = ServletUriComponentsBuilder.fromServletMapping((HttpServletRequest)request);
        String forwardedSsl = request.getHeader("X-Forwarded-Ssl");
        ForwardedHeader forwarded = ForwardedHeader.of(request.getHeader(ForwardedHeader.NAME));
        String string = proto = StringUtils.hasText((String)forwarded.getProto()) ? forwarded.getProto() : request.getHeader("X-Forwarded-Proto");
        if (!StringUtils.hasText((String)proto) && StringUtils.hasText((String)forwardedSsl) && forwardedSsl.equalsIgnoreCase("on")) {
            builder.scheme("https");
        }
        return builder;
    }

    private static HttpServletRequest getCurrentRequest() {
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        Assert.state((requestAttributes != null ? 1 : 0) != 0, (String)REQUEST_ATTRIBUTES_MISSING);
        Assert.isInstanceOf(ServletRequestAttributes.class, (Object)requestAttributes);
        HttpServletRequest servletRequest = ((ServletRequestAttributes)requestAttributes).getRequest();
        Assert.state((servletRequest != null ? 1 : 0) != 0, (String)"Could not find current HttpServletRequest");
        return servletRequest;
    }

    private static class CustomUriTemplateHandler
    extends DefaultUriTemplateHandler {
        public CustomUriTemplateHandler() {
            this.setStrictEncoding(true);
        }

        public UriComponents expandAndEncode(UriComponentsBuilder builder, Map<String, ?> uriVariables) {
            return super.expandAndEncode(builder, uriVariables);
        }

        public UriComponents expandAndEncode(UriComponentsBuilder builder, Object[] uriVariables) {
            return super.expandAndEncode(builder, uriVariables);
        }
    }

    private static class CachingAnnotationMappingDiscoverer
    implements MappingDiscoverer {
        private final AnnotationMappingDiscoverer delegate;
        private final Map<String, UriTemplate> templates = new ConcurrentReferenceHashMap();

        public UriTemplate getMappingAsUriTemplate(Class<?> type, Method method) {
            String mapping = this.delegate.getMapping(type, method);
            UriTemplate template = this.templates.get(mapping);
            if (template == null) {
                template = new UriTemplate(mapping);
                this.templates.put(mapping, template);
            }
            return template;
        }

        @ConstructorProperties(value={"delegate"})
        public CachingAnnotationMappingDiscoverer(AnnotationMappingDiscoverer delegate) {
            this.delegate = delegate;
        }

        @Override
        public String getMapping(Class<?> type) {
            return this.delegate.getMapping(type);
        }

        @Override
        public String getMapping(Method method) {
            return this.delegate.getMapping(method);
        }

        @Override
        public String getMapping(Class<?> type, Method method) {
            return this.delegate.getMapping(type, method);
        }
    }
}

