/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.jaxrs;

import java.util.Map;
import javax.ws.rs.Path;
import org.springframework.hateoas.core.AnnotationMappingDiscoverer;
import org.springframework.hateoas.core.LinkBuilderSupport;
import org.springframework.hateoas.core.MappingDiscoverer;
import org.springframework.util.Assert;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

public class JaxRsLinkBuilder
extends LinkBuilderSupport<JaxRsLinkBuilder> {
    private static final MappingDiscoverer DISCOVERER = new AnnotationMappingDiscoverer(Path.class);

    private JaxRsLinkBuilder(UriComponentsBuilder builder) {
        super(builder);
    }

    public static JaxRsLinkBuilder linkTo(Class<?> service) {
        return JaxRsLinkBuilder.linkTo(service, new Object[0]);
    }

    public static JaxRsLinkBuilder linkTo(Class<?> resourceType, Object ... parameters) {
        Assert.notNull(resourceType, (String)"Controller type must not be null!");
        Assert.notNull((Object)parameters, (String)"Parameters must not be null!");
        UriComponents uriComponents = UriComponentsBuilder.fromUriString((String)DISCOVERER.getMapping(resourceType)).build();
        UriComponents expandedComponents = uriComponents.expand(parameters);
        return (JaxRsLinkBuilder)new JaxRsLinkBuilder((UriComponentsBuilder)ServletUriComponentsBuilder.fromCurrentServletMapping()).slash(expandedComponents);
    }

    public static JaxRsLinkBuilder linkTo(Class<?> resourceType, Map<String, ?> parameters) {
        Assert.notNull(resourceType, (String)"Controller type must not be null!");
        Assert.notNull(parameters, (String)"Parameters must not be null!");
        UriComponents uriComponents = UriComponentsBuilder.fromUriString((String)DISCOVERER.getMapping(resourceType)).build();
        UriComponents expandedComponents = uriComponents.expand(parameters);
        return (JaxRsLinkBuilder)new JaxRsLinkBuilder((UriComponentsBuilder)ServletUriComponentsBuilder.fromCurrentServletMapping()).slash(expandedComponents);
    }

    @Override
    protected JaxRsLinkBuilder getThis() {
        return this;
    }

    @Override
    protected JaxRsLinkBuilder createNewInstance(UriComponentsBuilder builder) {
        return new JaxRsLinkBuilder(builder);
    }
}

