/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graphql.execution;

import graphql.GraphQLError;
import graphql.schema.DataFetchingEnvironment;
import org.jspecify.annotations.Nullable;
import org.springframework.graphql.execution.DataFetcherExceptionResolverAdapter;
import org.springframework.graphql.execution.SecurityExceptionResolverUtils;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.authentication.AuthenticationTrustResolver;
import org.springframework.security.authentication.AuthenticationTrustResolverImpl;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;

public class SecurityDataFetcherExceptionResolver
extends DataFetcherExceptionResolverAdapter {
    private AuthenticationTrustResolver trustResolver = new AuthenticationTrustResolverImpl();

    public SecurityDataFetcherExceptionResolver() {
        this.setThreadLocalContextAware(true);
    }

    public void setAuthenticationTrustResolver(AuthenticationTrustResolver trustResolver) {
        this.trustResolver = trustResolver;
    }

    @Override
    protected @Nullable GraphQLError resolveToSingleError(Throwable ex, DataFetchingEnvironment environment) {
        if (ex instanceof AuthenticationException) {
            return SecurityExceptionResolverUtils.resolveUnauthorized(environment);
        }
        if (ex instanceof AccessDeniedException) {
            SecurityContext securityContext = SecurityContextHolder.getContext();
            return SecurityExceptionResolverUtils.resolveAccessDenied(environment, this.trustResolver, securityContext);
        }
        return null;
    }
}

