/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graphql.client;

import java.util.Collections;
import java.util.Map;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.graphql.GraphQlRequest;
import org.springframework.graphql.GraphQlResponse;
import org.springframework.graphql.MediaTypes;
import org.springframework.graphql.client.ClientGraphQlRequest;
import org.springframework.graphql.client.GraphQlTransport;
import org.springframework.graphql.client.ResponseMapGraphQlResponse;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.codec.ServerSentEvent;
import org.springframework.util.Assert;
import org.springframework.web.reactive.function.client.ClientResponse;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

final class HttpGraphQlTransport
implements GraphQlTransport {
    private static final ParameterizedTypeReference<Map<String, Object>> MAP_TYPE = new ParameterizedTypeReference<Map<String, Object>>(){};
    private static final ParameterizedTypeReference<ServerSentEvent<Map<String, Object>>> SSE_TYPE = new ParameterizedTypeReference<ServerSentEvent<Map<String, Object>>>(){};
    private static final MediaType APPLICATION_GRAPHQL = new MediaType("application", "graphql+json");
    private final WebClient webClient;
    private final MediaType contentType;

    HttpGraphQlTransport(WebClient webClient) {
        Assert.notNull((Object)webClient, (String)"WebClient is required");
        this.webClient = webClient;
        this.contentType = HttpGraphQlTransport.initContentType(webClient);
    }

    private static MediaType initContentType(WebClient webClient) {
        HttpHeaders headers = new HttpHeaders();
        webClient.mutate().defaultHeaders(arg_0 -> ((HttpHeaders)headers).putAll(arg_0));
        MediaType contentType = headers.getContentType();
        return contentType != null ? contentType : MediaType.APPLICATION_JSON;
    }

    @Override
    public Mono<GraphQlResponse> execute(GraphQlRequest request) {
        return ((WebClient.RequestBodySpec)this.webClient.post().contentType(this.contentType).accept(new MediaType[]{MediaType.APPLICATION_JSON, MediaTypes.APPLICATION_GRAPHQL_RESPONSE, APPLICATION_GRAPHQL})).bodyValue(request.toMap()).attributes(attributes -> {
            if (request instanceof ClientGraphQlRequest) {
                ClientGraphQlRequest clientRequest = (ClientGraphQlRequest)request;
                attributes.putAll(clientRequest.getAttributes());
            }
        }).exchangeToMono(response -> {
            if (response.statusCode().equals((Object)HttpStatus.OK)) {
                return response.bodyToMono(MAP_TYPE);
            }
            if (response.statusCode().is4xxClientError() && HttpGraphQlTransport.isGraphQlResponse(response)) {
                return response.bodyToMono(MAP_TYPE);
            }
            return response.createError();
        }).map(ResponseMapGraphQlResponse::new);
    }

    private static boolean isGraphQlResponse(ClientResponse clientResponse) {
        return MediaTypes.APPLICATION_GRAPHQL_RESPONSE.isCompatibleWith((MediaType)clientResponse.headers().contentType().orElse(null));
    }

    @Override
    public Flux<GraphQlResponse> executeSubscription(GraphQlRequest request) {
        return ((WebClient.RequestBodySpec)this.webClient.post().contentType(this.contentType).accept(new MediaType[]{MediaType.TEXT_EVENT_STREAM})).bodyValue(request.toMap()).attributes(attributes -> {
            if (request instanceof ClientGraphQlRequest) {
                ClientGraphQlRequest clientRequest = (ClientGraphQlRequest)request;
                attributes.putAll(clientRequest.getAttributes());
            }
        }).retrieve().bodyToFlux(SSE_TYPE).takeWhile(event -> "next".equals(event.event())).map(event -> {
            Map data = event.data() != null ? (Map)event.data() : Collections.emptyMap();
            return new ResponseMapGraphQlResponse(data);
        });
    }
}

