/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graphql.server.webflux;

import java.util.Map;
import org.reactivestreams.Publisher;
import org.springframework.core.ResolvableType;
import org.springframework.core.codec.Decoder;
import org.springframework.core.codec.Encoder;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.core.io.buffer.DefaultDataBufferFactory;
import org.springframework.graphql.server.support.SerializableGraphQlRequest;
import org.springframework.http.MediaType;
import org.springframework.http.codec.CodecConfigurer;
import org.springframework.http.codec.DecoderHttpMessageReader;
import org.springframework.http.codec.EncoderHttpMessageWriter;
import org.springframework.util.Assert;
import org.springframework.util.MimeType;
import org.springframework.util.MimeTypeUtils;
import reactor.core.publisher.Mono;

final class HttpCodecDelegate {
    private static final ResolvableType REQUEST_TYPE = ResolvableType.forClass(SerializableGraphQlRequest.class);
    private static final ResolvableType RESPONSE_TYPE = ResolvableType.forClassWithGenerics(Map.class, (Class[])new Class[]{String.class, Object.class});
    private final Decoder<?> decoder;
    private final Encoder<?> encoder;

    HttpCodecDelegate(CodecConfigurer codecConfigurer) {
        Assert.notNull((Object)codecConfigurer, (String)"CodecConfigurer is required");
        this.decoder = HttpCodecDelegate.findJsonDecoder(codecConfigurer);
        this.encoder = HttpCodecDelegate.findJsonEncoder(codecConfigurer);
    }

    private static Decoder<?> findJsonDecoder(CodecConfigurer configurer) {
        return configurer.getReaders().stream().filter(reader -> reader.canRead(REQUEST_TYPE, MediaType.APPLICATION_JSON)).map(reader -> ((DecoderHttpMessageReader)reader).getDecoder()).findFirst().orElseThrow(() -> new IllegalArgumentException("No JSON Decoder"));
    }

    private static Encoder<?> findJsonEncoder(CodecConfigurer configurer) {
        return configurer.getWriters().stream().filter(writer -> writer.canWrite(RESPONSE_TYPE, MediaType.APPLICATION_JSON)).map(writer -> ((EncoderHttpMessageWriter)writer).getEncoder()).findFirst().orElseThrow(() -> new IllegalArgumentException("No JSON Encoder"));
    }

    DataBuffer encode(Map<String, Object> resultMap) {
        return this.encoder.encodeValue(resultMap, (DataBufferFactory)DefaultDataBufferFactory.sharedInstance, RESPONSE_TYPE, MimeTypeUtils.APPLICATION_JSON, null);
    }

    Mono<SerializableGraphQlRequest> decode(Publisher<DataBuffer> inputStream, MediaType contentType) {
        return this.decoder.decodeToMono(inputStream, REQUEST_TYPE, (MimeType)contentType, null);
    }
}

