/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graphql.server;

import graphql.ExecutionResult;
import io.rsocket.exceptions.InvalidException;
import io.rsocket.exceptions.RejectedException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import org.reactivestreams.Publisher;
import org.springframework.core.ResolvableType;
import org.springframework.core.codec.Encoder;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.core.io.buffer.DefaultDataBufferFactory;
import org.springframework.graphql.ExecutionGraphQlService;
import org.springframework.graphql.GraphQlResponse;
import org.springframework.graphql.server.RSocketGraphQlInterceptor;
import org.springframework.graphql.server.RSocketGraphQlRequest;
import org.springframework.graphql.server.RSocketGraphQlResponse;
import org.springframework.util.AlternativeJdkIdGenerator;
import org.springframework.util.Assert;
import org.springframework.util.IdGenerator;
import org.springframework.util.MimeTypeUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class GraphQlRSocketHandler {
    private static final ResolvableType LIST_TYPE = ResolvableType.forClass(List.class);
    private final RSocketGraphQlInterceptor.Chain executionChain;
    private final Encoder<?> jsonEncoder;
    private final IdGenerator idGenerator = new AlternativeJdkIdGenerator();

    public GraphQlRSocketHandler(ExecutionGraphQlService graphQlService, List<RSocketGraphQlInterceptor> interceptors, Encoder<?> jsonEncoder) {
        Assert.notNull((Object)graphQlService, (String)"ExecutionGraphQlService is required");
        Assert.notNull(jsonEncoder, (String)"JSON Encoder is required");
        this.executionChain = GraphQlRSocketHandler.initChain(graphQlService, interceptors);
        this.jsonEncoder = jsonEncoder;
    }

    private static RSocketGraphQlInterceptor.Chain initChain(ExecutionGraphQlService service, List<RSocketGraphQlInterceptor> interceptors) {
        RSocketGraphQlInterceptor.Chain endOfChain = request -> service.execute(request).map(RSocketGraphQlResponse::new);
        return interceptors.isEmpty() ? endOfChain : interceptors.stream().reduce(RSocketGraphQlInterceptor::andThen).map(interceptor -> interceptor.apply(endOfChain)).orElse(endOfChain);
    }

    public Mono<Map<String, Object>> handle(Map<String, Object> payload) {
        return this.handleInternal(payload).map(GraphQlResponse::toMap);
    }

    public Flux<Map<String, Object>> handleSubscription(Map<String, Object> payload) {
        return this.handleInternal(payload).flatMapMany(response -> {
            if (response.getData() instanceof Publisher) {
                Publisher publisher = (Publisher)response.getData();
                return Flux.from((Publisher)publisher).map(ExecutionResult::toSpecification);
            }
            if (response.isValid()) {
                return Flux.error((Throwable)new InvalidException("Expected a Publisher for a subscription operation. This is either a server error or the operation is not a subscription"));
            }
            String errorData = this.encodeErrors((RSocketGraphQlResponse)response).toString(StandardCharsets.UTF_8);
            return Flux.error((Throwable)new RejectedException(errorData));
        });
    }

    private Mono<RSocketGraphQlResponse> handleInternal(Map<String, Object> payload) {
        String requestId = this.idGenerator.generateId().toString();
        return this.executionChain.next(new RSocketGraphQlRequest(payload, requestId, null));
    }

    private DataBuffer encodeErrors(RSocketGraphQlResponse response) {
        return this.jsonEncoder.encodeValue((Object)response.getExecutionResult().getErrors(), (DataBufferFactory)DefaultDataBufferFactory.sharedInstance, LIST_TYPE, MimeTypeUtils.APPLICATION_JSON, null);
    }
}

