/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graphql.data.method.annotation.support;

import graphql.schema.DataFetchingEnvironment;
import java.util.Arrays;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import org.springframework.graphql.data.method.HandlerMethod;
import org.springframework.graphql.data.method.HandlerMethodArgumentResolverComposite;
import org.springframework.graphql.data.method.annotation.support.DataFetcherHandlerMethodSupport;
import org.springframework.graphql.execution.ReactiveAdapterRegistryHelper;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import reactor.core.publisher.Mono;

public class DataFetcherHandlerMethod
extends DataFetcherHandlerMethodSupport {
    private final BiConsumer<Object, Object[]> validationHelper;
    private final boolean subscription;

    @Deprecated(since="1.3.0", forRemoval=true)
    public DataFetcherHandlerMethod(HandlerMethod handlerMethod, HandlerMethodArgumentResolverComposite resolvers, @Nullable BiConsumer<Object, Object[]> validationHelper, @Nullable Executor executor, boolean subscription) {
        this(handlerMethod, resolvers, validationHelper, executor, subscription, false);
    }

    public DataFetcherHandlerMethod(HandlerMethod handlerMethod, HandlerMethodArgumentResolverComposite resolvers, @Nullable BiConsumer<Object, Object[]> validationHelper, @Nullable Executor executor, boolean invokeAsync, boolean subscription) {
        super(handlerMethod, resolvers, executor, invokeAsync);
        Assert.isTrue((!resolvers.getResolvers().isEmpty() ? 1 : 0) != 0, (String)"No argument resolvers");
        this.validationHelper = validationHelper != null ? validationHelper : (controller, args) -> {};
        this.subscription = subscription;
    }

    @Nullable
    public Object invoke(DataFetchingEnvironment environment) {
        return this.invoke(environment, new Object[0]);
    }

    @Nullable
    public Object invoke(DataFetchingEnvironment environment, Object ... providedArgs) {
        Object[] args;
        try {
            args = this.getMethodArgumentValues(environment, providedArgs);
        }
        catch (Throwable ex) {
            return Mono.error((Throwable)ex);
        }
        if (Arrays.stream(args).noneMatch(arg -> arg instanceof Mono)) {
            return this.validateAndInvoke(args, environment);
        }
        return this.subscription ? this.toArgsMono(args).flatMapMany(argValues -> {
            Object result = this.validateAndInvoke((Object[])argValues, environment);
            return ReactiveAdapterRegistryHelper.toSubscriptionFlux(result);
        }) : this.toArgsMono(args).flatMap(argValues -> {
            Object result = this.validateAndInvoke((Object[])argValues, environment);
            return ReactiveAdapterRegistryHelper.toMono(result);
        });
    }

    @Nullable
    private Object validateAndInvoke(Object[] args, DataFetchingEnvironment environment) {
        this.validationHelper.accept(this.getBean(), args);
        return this.doInvoke(environment.getGraphQlContext(), args);
    }
}

