/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graphql.data.method.annotation.support;

import graphql.GraphQLContext;
import graphql.schema.DataFetchingEnvironment;
import java.lang.annotation.Annotation;
import java.util.Optional;
import org.springframework.core.MethodParameter;
import org.springframework.graphql.data.method.HandlerMethodArgumentResolver;
import org.springframework.graphql.data.method.annotation.ContextValue;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Mono;

public class ContextValueMethodArgumentResolver
implements HandlerMethodArgumentResolver {
    @Override
    public boolean supportsParameter(MethodParameter parameter) {
        return parameter.getParameterAnnotation(ContextValue.class) != null;
    }

    @Override
    public Object resolveArgument(MethodParameter parameter, DataFetchingEnvironment environment) {
        ContextValue annotation = (ContextValue)parameter.getParameterAnnotation(ContextValue.class);
        Assert.state((annotation != null ? 1 : 0) != 0, (String)"Expected @ContextValue annotation");
        String name = ContextValueMethodArgumentResolver.getContextValueName(parameter, annotation.name(), annotation);
        return ContextValueMethodArgumentResolver.resolveContextValue(name, annotation.required(), parameter, environment.getGraphQlContext());
    }

    static String getContextValueName(MethodParameter parameter, String nameFromAnnotation, Annotation annotation) {
        if (StringUtils.hasText((String)nameFromAnnotation)) {
            return nameFromAnnotation;
        }
        String parameterName = parameter.getParameterName();
        if (parameterName != null) {
            return parameterName;
        }
        throw new IllegalArgumentException("Name for " + annotation.getClass().getSimpleName() + " argument of type [" + parameter.getNestedParameterType().getName() + "] not specified, and parameter name information not found in class file either.");
    }

    @Nullable
    static Object resolveContextValue(String contextValueName, boolean required, MethodParameter parameter, @Nullable GraphQLContext graphQlContext) {
        Class parameterType = parameter.getParameterType();
        Optional<Object> value = graphQlContext != null ? graphQlContext.get((Object)contextValueName) : null;
        boolean isOptional = parameterType.equals(Optional.class);
        boolean isMono = parameterType.equals(Mono.class);
        if (value == null && required && !isOptional && !isMono) {
            throw new IllegalStateException("Missing required context value for " + String.valueOf(parameter));
        }
        if (isMono) {
            Mono mono;
            return Mono.just((Object)(value instanceof Mono ? (mono = (Mono)value) : Mono.justOrEmpty((Object)value)));
        }
        if (isOptional) {
            return value instanceof Optional ? value : Optional.ofNullable(value);
        }
        return value;
    }
}

