/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graphql.data;

import graphql.schema.DataFetchingEnvironment;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.reflect.KCallable;
import kotlin.reflect.KClass;
import kotlin.reflect.KClassifier;
import kotlin.reflect.KFunction;
import kotlin.reflect.KParameter;
import kotlin.reflect.KType;
import kotlin.reflect.full.KClasses;
import kotlin.reflect.jvm.KCallablesJvm;
import kotlin.reflect.jvm.ReflectJvmMapping;
import org.springframework.beans.BeanInstantiationException;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.NotWritablePropertyException;
import org.springframework.beans.PropertyAccessorFactory;
import org.springframework.beans.SimpleTypeConverter;
import org.springframework.beans.TypeMismatchException;
import org.springframework.core.CollectionFactory;
import org.springframework.core.Conventions;
import org.springframework.core.KotlinDetector;
import org.springframework.core.MethodParameter;
import org.springframework.core.ResolvableType;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.data.util.DirectFieldAccessFallbackBeanWrapper;
import org.springframework.graphql.data.ArgumentValue;
import org.springframework.lang.Nullable;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.validation.AbstractBindingResult;
import org.springframework.validation.BindException;
import org.springframework.validation.BindingResult;
import org.springframework.validation.FieldError;
import org.springframework.validation.ObjectError;

public class GraphQlArgumentBinder {
    @Nullable
    private final SimpleTypeConverter typeConverter;
    private final boolean fallBackOnDirectFieldAccess;

    public GraphQlArgumentBinder() {
        this(null);
    }

    public GraphQlArgumentBinder(@Nullable ConversionService conversionService) {
        this(conversionService, false);
    }

    public GraphQlArgumentBinder(@Nullable ConversionService conversionService, boolean fallBackOnDirectFieldAccess) {
        this.typeConverter = GraphQlArgumentBinder.initTypeConverter(conversionService);
        this.fallBackOnDirectFieldAccess = fallBackOnDirectFieldAccess;
    }

    @Nullable
    private static SimpleTypeConverter initTypeConverter(@Nullable ConversionService conversionService) {
        if (conversionService == null) {
            return null;
        }
        SimpleTypeConverter typeConverter = new SimpleTypeConverter();
        typeConverter.setConversionService(conversionService);
        return typeConverter;
    }

    @Nullable
    public Object bind(DataFetchingEnvironment environment, @Nullable String name, ResolvableType targetType) throws BindException {
        Object rawValue = name != null ? environment.getArgument(name) : environment.getArguments();
        boolean isOmitted = name != null && !environment.getArguments().containsKey(name);
        return this.bind(rawValue, isOmitted, targetType);
    }

    @Nullable
    public Object bind(@Nullable Object rawValue, boolean isOmitted, ResolvableType targetType) throws BindException {
        ArgumentsBindingResult bindingResult = new ArgumentsBindingResult(targetType);
        Class targetClass = targetType.resolve(Object.class);
        Object value = this.bindRawValue("$", rawValue, isOmitted, targetType, targetClass, bindingResult);
        if (bindingResult.hasErrors()) {
            throw new BindException((BindingResult)bindingResult);
        }
        return value;
    }

    @Nullable
    private Object bindRawValue(String name, @Nullable Object rawValue, boolean isOmitted, ResolvableType targetType, Class<?> targetClass, ArgumentsBindingResult bindingResult) {
        Object value;
        boolean isArgumentValue;
        boolean isOptional = targetClass == Optional.class;
        boolean bl = isArgumentValue = targetClass == ArgumentValue.class;
        if (isOptional || isArgumentValue) {
            targetType = targetType.getNested(2);
            targetClass = targetType.resolve();
        }
        if (rawValue == null || targetClass == Object.class) {
            value = rawValue;
        } else if (rawValue instanceof Collection) {
            value = this.bindCollection(name, (Collection)((Object)rawValue), targetType, targetClass, bindingResult);
        } else if (rawValue instanceof Map) {
            value = this.bindMap(name, (Map)((Object)rawValue), targetType, targetClass, bindingResult);
        } else {
            Object object = value = !targetClass.isAssignableFrom(rawValue.getClass()) ? this.convertValue(name, rawValue, targetType, targetClass, bindingResult) : rawValue;
        }
        if (isOptional) {
            value = Optional.ofNullable(value);
        } else if (isArgumentValue) {
            value = isOmitted ? ArgumentValue.omitted() : ArgumentValue.ofNullable(value);
        }
        return value;
    }

    private Collection<?> bindCollection(String name, Collection<Object> rawCollection, ResolvableType collectionType, Class<?> collectionClass, ArgumentsBindingResult bindingResult) {
        ResolvableType elementType = collectionType.asCollection().getGeneric(new int[]{0});
        Class elementClass = collectionType.asCollection().getGeneric(new int[]{0}).resolve();
        if (elementClass == null) {
            bindingResult.rejectArgumentValue(name, null, "unknownType", "Unknown Collection element type");
            return Collections.emptyList();
        }
        Collection collection = CollectionFactory.createCollection(collectionClass, (Class)elementClass, (int)rawCollection.size());
        int index = 0;
        for (Object rawValue : rawCollection) {
            String indexedName = name + "[" + index++ + "]";
            collection.add(this.bindRawValue(indexedName, rawValue, false, elementType, elementClass, bindingResult));
        }
        return collection;
    }

    @Nullable
    private Object bindMap(String name, Map<String, Object> rawMap, ResolvableType targetType, Class<?> targetClass, ArgumentsBindingResult bindingResult) {
        if (Map.class.isAssignableFrom(targetClass)) {
            return this.bindMapToMap(name, rawMap, targetType, targetClass, bindingResult);
        }
        bindingResult.pushNestedPath(name);
        Constructor constructor = BeanUtils.getResolvableConstructor(targetClass);
        Object value = constructor.getParameterCount() > 0 ? this.bindViaConstructorAndSetters(constructor, rawMap, targetType, bindingResult) : this.bindViaSetters(constructor, rawMap, targetType, bindingResult);
        bindingResult.popNestedPath();
        return value;
    }

    private Map<?, Object> bindMapToMap(String name, Map<String, Object> rawMap, ResolvableType targetType, Class<?> targetClass, ArgumentsBindingResult bindingResult) {
        ResolvableType valueType = targetType.asMap().getGeneric(new int[]{1});
        Class valueClass = valueType.resolve(Object.class);
        if (valueClass == Object.class) {
            return rawMap;
        }
        Map map = CollectionFactory.createMap(targetClass, (int)rawMap.size());
        for (Map.Entry<String, Object> entry : rawMap.entrySet()) {
            String key = entry.getKey();
            String indexedName = name + "[" + key + "]";
            map.put(key, this.bindRawValue(indexedName, entry.getValue(), false, valueType, valueClass, bindingResult));
        }
        return map;
    }

    @Nullable
    private Object bindViaConstructorAndSetters(Constructor<?> constructor, Map<String, Object> rawMap, ResolvableType ownerType, ArgumentsBindingResult bindingResult) {
        Object target;
        HashMap<String, Object> dataToBind = new HashMap<String, Object>(rawMap);
        String[] paramNames = BeanUtils.getParameterNames(constructor);
        Class<?>[] paramTypes = constructor.getParameterTypes();
        Object[] constructorArguments = new Object[paramNames.length];
        for (int i = 0; i < paramNames.length; ++i) {
            String name = paramNames[i];
            ResolvableType targetType = ResolvableType.forType((Type)ResolvableType.forConstructorParameter(constructor, (int)i).getType(), (ResolvableType)ownerType);
            constructorArguments[i] = this.bindRawValue(name, dataToBind.get(name), !dataToBind.containsKey(name), targetType, paramTypes[i], bindingResult);
            dataToBind.remove(name);
        }
        if (KotlinDetector.isKotlinReflectPresent() && KotlinDetector.isKotlinType(constructor.getDeclaringClass())) {
            KotlinDelegate.rebindKotlinArguments(constructorArguments, constructor);
        }
        try {
            target = BeanUtils.instantiateClass(constructor, (Object[])constructorArguments);
        }
        catch (BeanInstantiationException ex) {
            if (bindingResult.hasErrors()) {
                return null;
            }
            throw ex;
        }
        if (!dataToBind.isEmpty() && !bindingResult.hasErrors()) {
            this.bindViaSetters(target, dataToBind, ownerType, bindingResult);
        }
        return target;
    }

    private Object bindViaSetters(Constructor<?> constructor, Map<String, Object> rawMap, ResolvableType ownerType, ArgumentsBindingResult bindingResult) {
        Object target = BeanUtils.instantiateClass(constructor, (Object[])new Object[0]);
        this.bindViaSetters(target, rawMap, ownerType, bindingResult);
        return target;
    }

    private void bindViaSetters(Object target, Map<String, Object> rawMap, ResolvableType ownerType, ArgumentsBindingResult bindingResult) {
        DirectFieldAccessFallbackBeanWrapper beanWrapper = this.fallBackOnDirectFieldAccess ? new DirectFieldAccessFallbackBeanWrapper(target) : PropertyAccessorFactory.forBeanPropertyAccess((Object)target);
        for (Map.Entry<String, Object> entry : rawMap.entrySet()) {
            Field field;
            String key = entry.getKey();
            TypeDescriptor typeDescriptor = beanWrapper.getPropertyTypeDescriptor(key);
            if (typeDescriptor == null && this.fallBackOnDirectFieldAccess && (field = ReflectionUtils.findField((Class)beanWrapper.getWrappedClass(), (String)key)) != null) {
                typeDescriptor = new TypeDescriptor(field);
            }
            if (typeDescriptor == null) continue;
            ResolvableType targetType = ResolvableType.forType((Type)typeDescriptor.getResolvableType().getType(), (ResolvableType)ownerType);
            Object value = this.bindRawValue(key, entry.getValue(), false, targetType, typeDescriptor.getType(), bindingResult);
            try {
                if (value == null) continue;
                beanWrapper.setPropertyValue(key, value);
            }
            catch (NotWritablePropertyException notWritablePropertyException) {
            }
            catch (Exception ex) {
                bindingResult.rejectArgumentValue(key, value, "invalidPropertyValue", "Failed to set property value");
            }
        }
    }

    @Nullable
    private <T> T convertValue(String name, @Nullable Object rawValue, ResolvableType type, Class<T> clazz, ArgumentsBindingResult bindingResult) {
        Object value = null;
        try {
            SimpleTypeConverter converter = this.typeConverter != null ? this.typeConverter : new SimpleTypeConverter();
            value = converter.convertIfNecessary(rawValue, clazz, new TypeDescriptor(type, null, null));
        }
        catch (TypeMismatchException ex) {
            bindingResult.rejectArgumentValue(name, rawValue, ex.getErrorCode(), "Failed to convert argument value");
        }
        return (T)value;
    }

    private static class ArgumentsBindingResult
    extends AbstractBindingResult {
        ArgumentsBindingResult(ResolvableType targetType) {
            super(ArgumentsBindingResult.initObjectName(targetType));
        }

        private static String initObjectName(ResolvableType targetType) {
            String string;
            Object object = targetType.getSource();
            if (object instanceof MethodParameter) {
                MethodParameter methodParameter = (MethodParameter)object;
                string = Conventions.getVariableNameForParameter((MethodParameter)methodParameter);
            } else {
                string = ClassUtils.getShortNameAsProperty((Class)targetType.resolve(Object.class));
            }
            return string;
        }

        public Object getTarget() {
            return null;
        }

        protected Object getActualFieldValue(String field) {
            return null;
        }

        void rejectArgumentValue(String field, @Nullable Object rawValue, String code, String defaultMessage) {
            this.addError((ObjectError)new FieldError(this.getObjectName(), this.fixedField(field), rawValue, true, this.resolveMessageCodes(code), null, defaultMessage));
        }
    }

    private static final class KotlinDelegate {
        private KotlinDelegate() {
        }

        public static void rebindKotlinArguments(Object[] arguments, Constructor<?> constructor) {
            KFunction function = ReflectJvmMapping.getKotlinFunction(constructor);
            if (function == null) {
                return;
            }
            int index = 0;
            for (KParameter parameter : function.getParameters()) {
                switch (parameter.getKind()) {
                    case VALUE: 
                    case EXTENSION_RECEIVER: {
                        KFunction argConstructor;
                        KClass kClass;
                        KClassifier kClassifier;
                        KType type;
                        Object rawValue = arguments[index];
                        if (parameter.isOptional() && rawValue == null || (type = parameter.getType()).isMarkedNullable() && rawValue == null || !((kClassifier = type.getClassifier()) instanceof KClass) || !KotlinDetector.isInlineClass((Class)JvmClassMappingKt.getJavaClass((KClass)(kClass = (KClass)kClassifier))) || (argConstructor = KClasses.getPrimaryConstructor((KClass)kClass)) == null) break;
                        if (!KCallablesJvm.isAccessible((KCallable)argConstructor)) {
                            KCallablesJvm.setAccessible((KCallable)argConstructor, (boolean)true);
                        }
                        arguments[index] = argConstructor.call(new Object[]{rawValue});
                    }
                }
                ++index;
            }
        }
    }
}

