/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graphql.execution;

import graphql.GraphQLContext;
import io.micrometer.context.ContextSnapshot;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.dataloader.BatchLoaderContextProvider;
import org.dataloader.BatchLoaderEnvironment;
import org.dataloader.BatchLoaderWithContext;
import org.dataloader.DataLoader;
import org.dataloader.DataLoaderFactory;
import org.dataloader.DataLoaderOptions;
import org.dataloader.DataLoaderRegistry;
import org.dataloader.MappedBatchLoaderWithContext;
import org.springframework.graphql.execution.BatchLoaderRegistry;
import org.springframework.graphql.execution.ContextPropagationHelper;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class DefaultBatchLoaderRegistry
implements BatchLoaderRegistry {
    private final List<ReactorBatchLoader<?, ?>> loaders = new ArrayList();
    private final List<ReactorMappedBatchLoader<?, ?>> mappedLoaders = new ArrayList();
    private final Supplier<DataLoaderOptions> defaultOptionsSupplier;

    public DefaultBatchLoaderRegistry() {
        this(DataLoaderOptions::newOptions);
    }

    public DefaultBatchLoaderRegistry(Supplier<DataLoaderOptions> defaultOptionsSupplier) {
        Assert.notNull(defaultOptionsSupplier, (String)"'defaultOptionsSupplier' is required");
        this.defaultOptionsSupplier = defaultOptionsSupplier;
    }

    @Override
    public <K, V> BatchLoaderRegistry.RegistrationSpec<K, V> forTypePair(Class<K> keyType, Class<V> valueType) {
        return new DefaultRegistrationSpec(valueType);
    }

    @Override
    public <K, V> BatchLoaderRegistry.RegistrationSpec<K, V> forName(String name) {
        return new DefaultRegistrationSpec(name);
    }

    @Override
    public boolean hasRegistrations() {
        return !this.loaders.isEmpty() || !this.mappedLoaders.isEmpty();
    }

    @Override
    public void registerDataLoaders(DataLoaderRegistry registry, GraphQLContext context) {
        DataLoader dataLoader;
        DataLoaderOptions options;
        BatchLoaderContextProvider contextProvider = () -> context;
        for (ReactorBatchLoader<?, ?> reactorBatchLoader : this.loaders) {
            options = reactorBatchLoader.getOptions();
            options = options.setBatchLoaderContextProvider(contextProvider);
            dataLoader = DataLoaderFactory.newDataLoader(reactorBatchLoader, (DataLoaderOptions)options);
            this.registerDataLoader(reactorBatchLoader.getName(), dataLoader, registry);
        }
        for (ReactorMappedBatchLoader reactorMappedBatchLoader : this.mappedLoaders) {
            options = reactorMappedBatchLoader.getOptions();
            options = options.setBatchLoaderContextProvider(contextProvider);
            dataLoader = DataLoaderFactory.newMappedDataLoader((MappedBatchLoaderWithContext)reactorMappedBatchLoader, (DataLoaderOptions)options);
            this.registerDataLoader(reactorMappedBatchLoader.getName(), dataLoader, registry);
        }
    }

    private void registerDataLoader(String name, DataLoader<?, ?> dataLoader, DataLoaderRegistry registry) {
        if (registry.getDataLoader(name) != null) {
            throw new IllegalStateException("More than one DataLoader named '" + name + "'");
        }
        registry.register(name, dataLoader);
    }

    private class DefaultRegistrationSpec<K, V>
    implements BatchLoaderRegistry.RegistrationSpec<K, V> {
        @Nullable
        private final Class<?> valueType;
        @Nullable
        private String name;
        @Nullable
        private DataLoaderOptions options;
        @Nullable
        private Consumer<DataLoaderOptions> optionsConsumer;

        DefaultRegistrationSpec(Class<V> valueType) {
            this.valueType = valueType;
        }

        DefaultRegistrationSpec(String name) {
            this.name = name;
            this.valueType = null;
        }

        @Override
        public BatchLoaderRegistry.RegistrationSpec<K, V> withName(String name) {
            this.name = name;
            return this;
        }

        @Override
        public BatchLoaderRegistry.RegistrationSpec<K, V> withOptions(Consumer<DataLoaderOptions> optionsConsumer) {
            this.optionsConsumer = this.optionsConsumer != null ? this.optionsConsumer.andThen(optionsConsumer) : optionsConsumer;
            return this;
        }

        @Override
        public BatchLoaderRegistry.RegistrationSpec<K, V> withOptions(DataLoaderOptions options) {
            this.options = options;
            return this;
        }

        @Override
        public void registerBatchLoader(BiFunction<List<K>, BatchLoaderEnvironment, Flux<V>> loader) {
            DefaultBatchLoaderRegistry.this.loaders.add(new ReactorBatchLoader<K, V>(this.initName(), loader, this.initOptionsSupplier()));
        }

        @Override
        public void registerMappedBatchLoader(BiFunction<Set<K>, BatchLoaderEnvironment, Mono<Map<K, V>>> loader) {
            DefaultBatchLoaderRegistry.this.mappedLoaders.add(new ReactorMappedBatchLoader<K, V>(this.initName(), loader, this.initOptionsSupplier()));
        }

        private String initName() {
            if (StringUtils.hasText((String)this.name)) {
                return this.name;
            }
            Assert.notNull(this.valueType, (String)"Value type not available to select a default DataLoader name.");
            return StringUtils.hasText((String)this.name) ? this.name : this.valueType.getName();
        }

        private Supplier<DataLoaderOptions> initOptionsSupplier() {
            Supplier<DataLoaderOptions> optionsSupplier = () -> new DataLoaderOptions(this.options != null ? this.options : DefaultBatchLoaderRegistry.this.defaultOptionsSupplier.get());
            if (this.optionsConsumer == null) {
                return optionsSupplier;
            }
            return () -> {
                DataLoaderOptions options = (DataLoaderOptions)optionsSupplier.get();
                this.optionsConsumer.accept(options);
                return options;
            };
        }
    }

    private static final class ReactorBatchLoader<K, V>
    implements BatchLoaderWithContext<K, V> {
        private final String name;
        private final BiFunction<List<K>, BatchLoaderEnvironment, Flux<V>> loader;
        private final Supplier<DataLoaderOptions> optionsSupplier;

        private ReactorBatchLoader(String name, BiFunction<List<K>, BatchLoaderEnvironment, Flux<V>> loader, Supplier<DataLoaderOptions> optionsSupplier) {
            this.name = name;
            this.loader = loader;
            this.optionsSupplier = optionsSupplier;
        }

        String getName() {
            return this.name;
        }

        DataLoaderOptions getOptions() {
            return this.optionsSupplier.get();
        }

        public CompletionStage<List<V>> load(List<K> keys, BatchLoaderEnvironment environment) {
            GraphQLContext graphQLContext = (GraphQLContext)environment.getContext();
            ContextSnapshot snapshot = ContextPropagationHelper.captureFrom(graphQLContext);
            try {
                return (CompletionStage)snapshot.wrap(() -> this.loader.apply(keys, environment).collectList().contextWrite(arg_0 -> ((ContextSnapshot)snapshot).updateContext(arg_0)).toFuture()).call();
            }
            catch (Exception ex) {
                return CompletableFuture.failedFuture(ex);
            }
        }
    }

    private static final class ReactorMappedBatchLoader<K, V>
    implements MappedBatchLoaderWithContext<K, V> {
        private final String name;
        private final BiFunction<Set<K>, BatchLoaderEnvironment, Mono<Map<K, V>>> loader;
        private final Supplier<DataLoaderOptions> optionsSupplier;

        private ReactorMappedBatchLoader(String name, BiFunction<Set<K>, BatchLoaderEnvironment, Mono<Map<K, V>>> loader, Supplier<DataLoaderOptions> optionsSupplier) {
            this.name = name;
            this.loader = loader;
            this.optionsSupplier = optionsSupplier;
        }

        String getName() {
            return this.name;
        }

        DataLoaderOptions getOptions() {
            return this.optionsSupplier.get();
        }

        public CompletionStage<Map<K, V>> load(Set<K> keys, BatchLoaderEnvironment environment) {
            GraphQLContext graphQLContext = (GraphQLContext)environment.getContext();
            ContextSnapshot snapshot = ContextPropagationHelper.captureFrom(graphQLContext);
            try {
                return (CompletionStage)snapshot.wrap(() -> this.loader.apply(keys, environment).contextWrite(arg_0 -> ((ContextSnapshot)snapshot).updateContext(arg_0)).toFuture()).call();
            }
            catch (Exception ex) {
                return CompletableFuture.failedFuture(ex);
            }
        }
    }
}

