/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graphql.support;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.graphql.GraphQlResponse;
import org.springframework.graphql.ResponseError;
import org.springframework.graphql.ResponseField;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public abstract class AbstractGraphQlResponse
implements GraphQlResponse {
    @Override
    public ResponseField field(String path) {
        return new DefaultResponseField(this, path);
    }

    private static class DefaultResponseField
    implements ResponseField {
        private final GraphQlResponse response;
        private final String path;
        private final List<Object> parsedPath;
        @Nullable
        private final Object value;
        private final List<ResponseError> fieldErrors;

        DefaultResponseField(GraphQlResponse response, String path) {
            this.response = response;
            this.path = path;
            this.parsedPath = DefaultResponseField.parsePath(path);
            this.value = DefaultResponseField.initFieldValue(this.parsedPath, response);
            this.fieldErrors = DefaultResponseField.initFieldErrors(path, response);
        }

        private static List<Object> parsePath(String path) {
            if (!StringUtils.hasText((String)path)) {
                return Collections.emptyList();
            }
            String invalidPathMessage = "Invalid path: '" + path + "'";
            ArrayList<Object> dataPath = new ArrayList<Object>();
            StringBuilder sb = new StringBuilder();
            boolean readingIndex = false;
            block4: for (int i = 0; i < path.length(); ++i) {
                char c = path.charAt(i);
                switch (c) {
                    case '.': 
                    case '[': {
                        Assert.isTrue((!readingIndex ? 1 : 0) != 0, (String)invalidPathMessage);
                        break;
                    }
                    case ']': {
                        Assert.isTrue((boolean)readingIndex, (String)invalidPathMessage);
                        Assert.isTrue((++i == path.length() || path.charAt(i) == '.' ? 1 : 0) != 0, (String)invalidPathMessage);
                        break;
                    }
                    default: {
                        sb.append(c);
                        if (i < path.length() - 1) continue block4;
                    }
                }
                String token = sb.toString();
                Assert.hasText((String)token, (String)invalidPathMessage);
                dataPath.add(readingIndex ? Integer.valueOf(Integer.parseInt(token)) : token);
                sb.delete(0, sb.length());
                readingIndex = c == '[';
            }
            return dataPath;
        }

        @Nullable
        private static Object initFieldValue(List<Object> path, GraphQlResponse response) {
            Object value = response.isValid() ? response.getData() : null;
            for (Object segment : path) {
                if (value == null) {
                    return null;
                }
                if (segment instanceof String) {
                    Assert.isTrue((boolean)(value instanceof Map), () -> "Invalid path " + path + ", data: " + response.getData());
                    value = ((Map)value).getOrDefault(segment, null);
                    continue;
                }
                Assert.isTrue((boolean)(value instanceof List), () -> "Invalid path " + path + ", data: " + response.getData());
                int index = (Integer)segment;
                value = index < ((List)value).size() ? ((List)value).get(index) : null;
            }
            return value;
        }

        private static List<ResponseError> initFieldErrors(String path, GraphQlResponse response) {
            if (path.isEmpty() || response.getErrors().isEmpty()) {
                return Collections.emptyList();
            }
            return response.getErrors().stream().filter(error -> {
                String errorPath = error.getPath();
                return !errorPath.isEmpty() && (errorPath.startsWith(path) || path.startsWith(errorPath));
            }).collect(Collectors.toList());
        }

        @Override
        public String getPath() {
            return this.path;
        }

        @Override
        public List<Object> getParsedPath() {
            return this.parsedPath;
        }

        @Override
        public <T> T getValue() {
            return (T)this.value;
        }

        @Override
        public List<ResponseError> getErrors() {
            return this.fieldErrors;
        }
    }
}

