/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graphql.data.method.annotation.support;

import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.FieldCoordinates;
import graphql.schema.GraphQLCodeRegistry;
import graphql.schema.idl.RuntimeWiring;
import graphql.schema.idl.TypeRuntimeWiring;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.validation.Validator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dataloader.DataLoader;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.expression.BeanFactoryResolver;
import org.springframework.core.KotlinDetector;
import org.springframework.core.MethodIntrospector;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.convert.ConversionService;
import org.springframework.expression.BeanResolver;
import org.springframework.format.FormatterRegistrar;
import org.springframework.format.FormatterRegistry;
import org.springframework.format.support.DefaultFormattingConversionService;
import org.springframework.format.support.FormattingConversionService;
import org.springframework.graphql.data.GraphQlArgumentBinder;
import org.springframework.graphql.data.method.HandlerMethod;
import org.springframework.graphql.data.method.HandlerMethodArgumentResolver;
import org.springframework.graphql.data.method.HandlerMethodArgumentResolverComposite;
import org.springframework.graphql.data.method.annotation.BatchMapping;
import org.springframework.graphql.data.method.annotation.SchemaMapping;
import org.springframework.graphql.data.method.annotation.support.ArgumentMapMethodArgumentResolver;
import org.springframework.graphql.data.method.annotation.support.ArgumentMethodArgumentResolver;
import org.springframework.graphql.data.method.annotation.support.ArgumentsMethodArgumentResolver;
import org.springframework.graphql.data.method.annotation.support.AuthenticationPrincipalArgumentResolver;
import org.springframework.graphql.data.method.annotation.support.BatchLoaderHandlerMethod;
import org.springframework.graphql.data.method.annotation.support.ContextValueMethodArgumentResolver;
import org.springframework.graphql.data.method.annotation.support.ContinuationHandlerMethodArgumentResolver;
import org.springframework.graphql.data.method.annotation.support.DataFetcherHandlerMethod;
import org.springframework.graphql.data.method.annotation.support.DataFetchingEnvironmentMethodArgumentResolver;
import org.springframework.graphql.data.method.annotation.support.DataLoaderMethodArgumentResolver;
import org.springframework.graphql.data.method.annotation.support.HandlerMethodInputValidator;
import org.springframework.graphql.data.method.annotation.support.LocalContextValueMethodArgumentResolver;
import org.springframework.graphql.data.method.annotation.support.PrincipalMethodArgumentResolver;
import org.springframework.graphql.data.method.annotation.support.ProjectedPayloadMethodArgumentResolver;
import org.springframework.graphql.data.method.annotation.support.SourceMethodArgumentResolver;
import org.springframework.graphql.execution.BatchLoaderRegistry;
import org.springframework.graphql.execution.RuntimeWiringConfigurer;
import org.springframework.lang.Nullable;
import org.springframework.stereotype.Controller;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;
import org.springframework.validation.DataBinder;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class AnnotatedControllerConfigurer
implements ApplicationContextAware,
InitializingBean,
RuntimeWiringConfigurer {
    private static final Log logger = LogFactory.getLog(AnnotatedControllerConfigurer.class);
    private static final String SCOPED_TARGET_NAME_PREFIX = "scopedTarget.";
    private static final boolean springDataPresent = ClassUtils.isPresent((String)"org.springframework.data.projection.SpelAwareProxyProjectionFactory", (ClassLoader)AnnotatedControllerConfigurer.class.getClassLoader());
    private static final boolean springSecurityPresent = ClassUtils.isPresent((String)"org.springframework.security.core.context.SecurityContext", (ClassLoader)AnnotatedControllerConfigurer.class.getClassLoader());
    private static final boolean beanValidationPresent = ClassUtils.isPresent((String)"javax.validation.executable.ExecutableValidator", (ClassLoader)AnnotatedControllerConfigurer.class.getClassLoader());
    private final FormattingConversionService conversionService = new DefaultFormattingConversionService();
    @Nullable
    private Executor executor;
    @Nullable
    private ApplicationContext applicationContext;
    @Nullable
    private HandlerMethodArgumentResolverComposite argumentResolvers;
    @Nullable
    private HandlerMethodInputValidator validator;
    @Nullable
    private Consumer<DataBinder> dataBinderInitializer;

    public void addFormatterRegistrar(FormatterRegistrar registrar) {
        registrar.registerFormatters((FormatterRegistry)this.conversionService);
    }

    public void setExecutor(Executor executor) {
        this.executor = executor;
    }

    public void setDataBinderInitializer(@Nullable Consumer<DataBinder> dataBinderInitializer) {
        this.dataBinderInitializer = dataBinderInitializer;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void afterPropertiesSet() {
        this.argumentResolvers = this.initArgumentResolvers();
        if (beanValidationPresent) {
            this.validator = HandlerMethodInputValidatorFactory.create(this.obtainApplicationContext());
        }
    }

    private HandlerMethodArgumentResolverComposite initArgumentResolvers() {
        HandlerMethodArgumentResolverComposite resolvers = new HandlerMethodArgumentResolverComposite();
        if (springDataPresent) {
            resolvers.addResolver(new ProjectedPayloadMethodArgumentResolver(this.obtainApplicationContext()));
        }
        resolvers.addResolver(new ArgumentMapMethodArgumentResolver());
        GraphQlArgumentBinder argumentBinder = new GraphQlArgumentBinder((ConversionService)this.conversionService);
        if (this.dataBinderInitializer != null) {
            argumentBinder.addDataBinderInitializer(this.dataBinderInitializer);
        }
        resolvers.addResolver(new ArgumentMethodArgumentResolver(argumentBinder));
        resolvers.addResolver(new ArgumentsMethodArgumentResolver(argumentBinder));
        resolvers.addResolver(new ContextValueMethodArgumentResolver());
        resolvers.addResolver(new LocalContextValueMethodArgumentResolver());
        resolvers.addResolver(new DataFetchingEnvironmentMethodArgumentResolver());
        resolvers.addResolver(new DataLoaderMethodArgumentResolver());
        if (springSecurityPresent) {
            resolvers.addResolver(new PrincipalMethodArgumentResolver());
            BeanFactoryResolver beanResolver = new BeanFactoryResolver((BeanFactory)this.obtainApplicationContext());
            resolvers.addResolver(new AuthenticationPrincipalArgumentResolver((BeanResolver)beanResolver));
        }
        if (KotlinDetector.isKotlinPresent()) {
            resolvers.addResolver(new ContinuationHandlerMethodArgumentResolver());
        }
        resolvers.addResolver(new SourceMethodArgumentResolver());
        return resolvers;
    }

    protected final ApplicationContext obtainApplicationContext() {
        Assert.state((this.applicationContext != null ? 1 : 0) != 0, (String)"No ApplicationContext");
        return this.applicationContext;
    }

    @Override
    public void configure(RuntimeWiring.Builder runtimeWiringBuilder) {
        Assert.state((this.argumentResolvers != null ? 1 : 0) != 0, (String)"`argumentResolvers` is not initialized");
        this.findHandlerMethods().forEach(info -> {
            Object dataFetcher;
            if (!info.isBatchMapping()) {
                dataFetcher = new SchemaMappingDataFetcher((MappingInfo)info, this.argumentResolvers, this.validator, this.executor);
            } else {
                String dataLoaderKey = this.registerBatchLoader((MappingInfo)info);
                dataFetcher = new BatchMappingDataFetcher(dataLoaderKey);
            }
            runtimeWiringBuilder.type(info.getCoordinates().getTypeName(), arg_0 -> AnnotatedControllerConfigurer.lambda$null$0(info, (DataFetcher)dataFetcher, arg_0));
        });
    }

    private Collection<MappingInfo> findHandlerMethods() {
        ApplicationContext context = this.obtainApplicationContext();
        HashMap result = new HashMap();
        for (String beanName : context.getBeanNamesForType(Object.class)) {
            Class beanType;
            block3: {
                if (beanName.startsWith(SCOPED_TARGET_NAME_PREFIX)) continue;
                beanType = null;
                try {
                    beanType = context.getType(beanName);
                }
                catch (Throwable ex) {
                    if (!logger.isTraceEnabled()) break block3;
                    logger.trace((Object)("Could not resolve type for bean '" + beanName + "'"), ex);
                }
            }
            if (beanType == null || !AnnotatedElementUtils.hasAnnotation((AnnotatedElement)beanType, Controller.class)) continue;
            Class beanClass = context.getType(beanName);
            this.findHandlerMethods(beanName, beanClass).forEach(info -> {
                HandlerMethod handlerMethod = info.getHandlerMethod();
                MappingInfo existing = result.put(info.getCoordinates(), info);
                if (existing != null && !existing.getHandlerMethod().equals(handlerMethod)) {
                    throw new IllegalStateException("Ambiguous mapping. Cannot map '" + handlerMethod.getBean() + "' method \n" + handlerMethod + "\nto " + info.getCoordinates() + ": There is already '" + existing.getHandlerMethod().getBean() + "' bean method\n" + existing + " mapped.");
                }
            });
        }
        return result.values();
    }

    private Collection<MappingInfo> findHandlerMethods(Object handler, @Nullable Class<?> handlerClass) {
        if (handlerClass == null) {
            return Collections.emptyList();
        }
        Class userClass = ClassUtils.getUserClass(handlerClass);
        Map map = MethodIntrospector.selectMethods((Class)userClass, method -> this.getMappingInfo(method, handler, userClass));
        Collection<MappingInfo> mappingInfos = map.values();
        if (logger.isTraceEnabled() && !mappingInfos.isEmpty()) {
            logger.trace((Object)this.formatMappings(userClass, mappingInfos));
        }
        return mappingInfos;
    }

    @Nullable
    private MappingInfo getMappingInfo(Method method, Object handler, Class<?> handlerType) {
        String field;
        String typeName;
        Annotation mapping;
        Set annotations = AnnotatedElementUtils.findAllMergedAnnotations((AnnotatedElement)method, new LinkedHashSet<Class>(Arrays.asList(BatchMapping.class, SchemaMapping.class)));
        if (annotations.isEmpty()) {
            return null;
        }
        if (annotations.size() != 1) {
            throw new IllegalArgumentException("Expected either @BatchMapping or @SchemaMapping, not both: " + method.toGenericString());
        }
        boolean batchMapping = false;
        HandlerMethod handlerMethod = this.createHandlerMethod(method, handler, handlerType);
        Annotation annotation = (Annotation)annotations.iterator().next();
        if (annotation instanceof SchemaMapping) {
            mapping = (SchemaMapping)annotation;
            typeName = mapping.typeName();
            field = StringUtils.hasText((String)mapping.field()) ? mapping.field() : method.getName();
        } else {
            mapping = (BatchMapping)annotation;
            typeName = mapping.typeName();
            field = StringUtils.hasText((String)mapping.field()) ? mapping.field() : method.getName();
            batchMapping = true;
        }
        if (!StringUtils.hasText((String)typeName) && (mapping = (SchemaMapping)AnnotatedElementUtils.findMergedAnnotation(handlerType, SchemaMapping.class)) != null) {
            typeName = mapping.typeName();
        }
        if (!StringUtils.hasText((String)typeName)) {
            for (MethodParameter parameter : handlerMethod.getMethodParameters()) {
                if (!batchMapping) {
                    Assert.state((this.argumentResolvers != null ? 1 : 0) != 0, (String)"`argumentResolvers` is not initialized");
                    HandlerMethodArgumentResolver resolver = this.argumentResolvers.getArgumentResolver(parameter);
                    if (!(resolver instanceof SourceMethodArgumentResolver)) continue;
                    typeName = parameter.getParameterType().getSimpleName();
                    break;
                }
                if (!Collection.class.isAssignableFrom(parameter.getParameterType())) continue;
                typeName = parameter.nested().getNestedParameterType().getSimpleName();
                break;
            }
        }
        Assert.hasText((String)typeName, (String)("No parentType specified, and a source/parent method argument was also not found: " + handlerMethod.getShortLogMessage()));
        return new MappingInfo(typeName, field, batchMapping, handlerMethod);
    }

    private HandlerMethod createHandlerMethod(Method method, Object handler, Class<?> handlerType) {
        Method theMethod = AopUtils.selectInvocableMethod((Method)method, handlerType);
        return handler instanceof String ? new HandlerMethod((String)handler, (BeanFactory)this.obtainApplicationContext().getAutowireCapableBeanFactory(), theMethod) : new HandlerMethod(handler, theMethod);
    }

    private String formatMappings(Class<?> handlerType, Collection<MappingInfo> infos) {
        String formattedType = Arrays.stream(ClassUtils.getPackageName(handlerType).split("\\.")).map(p -> p.substring(0, 1)).collect(Collectors.joining(".", "", "." + handlerType.getSimpleName()));
        return infos.stream().map(mappingInfo -> {
            Method method = mappingInfo.getHandlerMethod().getMethod();
            String methodParameters = Arrays.stream(method.getGenericParameterTypes()).map(Type::getTypeName).collect(Collectors.joining(",", "(", ")"));
            return mappingInfo.getCoordinates() + " => " + method.getName() + methodParameters;
        }).collect(Collectors.joining("\n\t", "\n\t" + formattedType + ":\n\t", ""));
    }

    /*
     * Enabled aggressive block sorting
     */
    private String registerBatchLoader(MappingInfo info) {
        Class nestedClass;
        Class clazz;
        BatchLoaderHandlerMethod invocable;
        HandlerMethod handlerMethod;
        BatchLoaderRegistry registry;
        String dataLoaderKey;
        block6: {
            block5: {
                if (!info.isBatchMapping()) {
                    throw new IllegalArgumentException("Not a @BatchMapping method: " + info);
                }
                dataLoaderKey = info.getCoordinates().toString();
                registry = (BatchLoaderRegistry)this.obtainApplicationContext().getBean(BatchLoaderRegistry.class);
                handlerMethod = info.getHandlerMethod();
                invocable = new BatchLoaderHandlerMethod(handlerMethod, this.executor);
                MethodParameter returnType = handlerMethod.getReturnType();
                clazz = returnType.getParameterType();
                Class clazz2 = nestedClass = clazz.equals(Callable.class) ? returnType.nested().getNestedParameterType() : clazz;
                if (clazz.equals(Flux.class)) break block5;
                if (!Collection.class.isAssignableFrom(nestedClass)) break block6;
            }
            registry.forName(dataLoaderKey).registerBatchLoader(invocable::invokeForIterable);
            return dataLoaderKey;
        }
        if (!clazz.equals(Mono.class)) {
            if (!nestedClass.equals(Map.class)) throw new IllegalStateException("@BatchMapping method is expected to return Flux<V>, List<V>, Mono<Map<K, V>>, or Map<K, V>: " + handlerMethod);
        }
        registry.forName(dataLoaderKey).registerMappedBatchLoader(invocable::invokeForMap);
        return dataLoaderKey;
    }

    public void configure(GraphQLCodeRegistry.Builder codeRegistryBuilder) {
        RuntimeWiring.Builder wiringBuilder = RuntimeWiring.newRuntimeWiring();
        this.configure(wiringBuilder);
        RuntimeWiring runtimeWiring = wiringBuilder.build();
        runtimeWiring.getDataFetchers().forEach((typeName, dataFetcherMap) -> dataFetcherMap.forEach((key, value) -> {
            FieldCoordinates coordinates = FieldCoordinates.coordinates((String)typeName, (String)key);
            codeRegistryBuilder.dataFetcher(coordinates, value);
        }));
    }

    private static /* synthetic */ TypeRuntimeWiring.Builder lambda$null$0(MappingInfo info, DataFetcher dataFetcher, TypeRuntimeWiring.Builder typeBuilder) {
        return typeBuilder.dataFetcher(info.getCoordinates().getFieldName(), dataFetcher);
    }

    static class HandlerMethodInputValidatorFactory {
        HandlerMethodInputValidatorFactory() {
        }

        @Nullable
        static HandlerMethodInputValidator create(ApplicationContext context) {
            Validator validator = (Validator)context.getBeanProvider(Validator.class).getIfAvailable();
            return validator != null ? new HandlerMethodInputValidator(validator) : null;
        }
    }

    static class BatchMappingDataFetcher
    implements DataFetcher<Object> {
        private final String dataLoaderKey;

        public BatchMappingDataFetcher(String dataLoaderKey) {
            this.dataLoaderKey = dataLoaderKey;
        }

        public Object get(DataFetchingEnvironment env) {
            DataLoader dataLoader = env.getDataLoaderRegistry().getDataLoader(this.dataLoaderKey);
            if (dataLoader == null) {
                throw new IllegalStateException("No DataLoader for key '" + this.dataLoaderKey + "'");
            }
            return dataLoader.load(env.getSource());
        }
    }

    static class SchemaMappingDataFetcher
    implements DataFetcher<Object> {
        private final MappingInfo info;
        private final HandlerMethodArgumentResolverComposite argumentResolvers;
        @Nullable
        private final HandlerMethodInputValidator validator;
        @Nullable
        private final Executor executor;
        private final boolean subscription;

        public SchemaMappingDataFetcher(MappingInfo info, HandlerMethodArgumentResolverComposite resolvers, @Nullable HandlerMethodInputValidator validator, @Nullable Executor executor) {
            this.info = info;
            this.argumentResolvers = resolvers;
            this.validator = validator;
            this.executor = executor;
            this.subscription = this.info.getCoordinates().getTypeName().equalsIgnoreCase("Subscription");
        }

        public HandlerMethod getHandlerMethod() {
            return this.info.getHandlerMethod();
        }

        public Object get(DataFetchingEnvironment environment) throws Exception {
            DataFetcherHandlerMethod handlerMethod = new DataFetcherHandlerMethod(this.getHandlerMethod(), this.argumentResolvers, this.validator, this.executor, this.subscription);
            return handlerMethod.invoke(environment);
        }
    }

    private static class MappingInfo {
        private final FieldCoordinates coordinates;
        private final boolean batchMapping;
        private final HandlerMethod handlerMethod;

        public MappingInfo(String typeName, String field, boolean batchMapping, HandlerMethod handlerMethod) {
            this.coordinates = FieldCoordinates.coordinates((String)typeName, (String)field);
            this.handlerMethod = handlerMethod;
            this.batchMapping = batchMapping;
        }

        public FieldCoordinates getCoordinates() {
            return this.coordinates;
        }

        public boolean isBatchMapping() {
            return this.batchMapping;
        }

        public HandlerMethod getHandlerMethod() {
            return this.handlerMethod;
        }

        public String toString() {
            return this.coordinates + " -> " + this.handlerMethod;
        }
    }
}

