/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.flex.security3;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationListener;
import org.springframework.security.authentication.event.InteractiveAuthenticationSuccessEvent;
import org.springframework.web.context.request.RequestContextHolder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FlexSessionInvalidatingAuthenticationListener
implements ApplicationListener<InteractiveAuthenticationSuccessEvent> {
    private static final String FLEX_SESSION_KEY = "__flexSession";
    private static final Log log = LogFactory.getLog(FlexSessionInvalidatingAuthenticationListener.class);

    public void onApplicationEvent(InteractiveAuthenticationSuccessEvent event) {
        if (RequestContextHolder.getRequestAttributes() == null) {
            log.error((Object)"Unable to find a thread-bound RequestAttributes object.  You must install either a RequestContextListener or RequestContextFilter in order for this listener to have access to the current HttpSession to be able to clean up the FlexSession correctly.");
            return;
        }
        RequestContextHolder.getRequestAttributes().removeAttribute(FLEX_SESSION_KEY, 1);
    }
}

