/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.flex.security;

import flex.messaging.MessageException;
import flex.messaging.security.SecurityException;
import org.springframework.flex.core.ExceptionTranslator;
import org.springframework.security.AccessDeniedException;
import org.springframework.security.AuthenticationException;
import org.springframework.util.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecurityExceptionTranslator
implements ExceptionTranslator {
    @Override
    public boolean handles(Class<?> clazz) {
        return ClassUtils.isAssignable(AuthenticationException.class, clazz) || ClassUtils.isAssignable(AccessDeniedException.class, clazz);
    }

    @Override
    public MessageException translate(Throwable t) {
        if (t instanceof AuthenticationException) {
            SecurityException se = new SecurityException();
            se.setCode("Client.Authentication");
            se.setMessage(t.getLocalizedMessage());
            se.setRootCause(t);
            return se;
        }
        if (t instanceof AccessDeniedException) {
            SecurityException se = new SecurityException();
            se.setCode("Client.Authorization");
            se.setMessage(t.getLocalizedMessage());
            se.setRootCause(t);
            return se;
        }
        return null;
    }
}

