/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.flex.security;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.security.event.authentication.InteractiveAuthenticationSuccessEvent;
import org.springframework.web.context.request.RequestContextHolder;

public class FlexSessionInvalidatingAuthenticationListener
implements ApplicationListener {
    private static final String FLEX_SESSION_KEY = "__flexSession";
    private static final Log log = LogFactory.getLog(FlexSessionInvalidatingAuthenticationListener.class);

    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof InteractiveAuthenticationSuccessEvent) {
            if (RequestContextHolder.getRequestAttributes() == null) {
                log.error((Object)"Unable to find a thread-bound RequestAttributes object.  You must install either a RequestContextListener or RequestContextFilter in order for this listener to have access to the current HttpSession to be able to clean up the FlexSession correctly.");
                return;
            }
            RequestContextHolder.getRequestAttributes().removeAttribute(FLEX_SESSION_KEY, 1);
        }
    }
}

