/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.flex.core;

import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentHashMap;
import flex.management.MBeanLifecycleManager;
import flex.messaging.FlexContext;
import flex.messaging.HttpFlexSession;
import flex.messaging.MessageBroker;
import flex.messaging.VersionInfo;
import flex.messaging.config.ConfigurationManager;
import flex.messaging.config.MessagingConfiguration;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.io.ResourceLoader;
import org.springframework.flex.config.FlexConfigurationManager;
import org.springframework.flex.config.MessageBrokerConfigProcessor;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.web.context.ServletContextAware;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageBrokerFactoryBean
implements FactoryBean,
BeanClassLoaderAware,
BeanNameAware,
ResourceLoaderAware,
InitializingBean,
DisposableBean,
ServletContextAware {
    private static String FLEXDIR = "/WEB-INF/flex/";
    private static final Log logger = LogFactory.getLog(MessageBrokerFactoryBean.class);
    private MessageBroker messageBroker;
    private String name;
    private ClassLoader beanClassLoader = ClassUtils.getDefaultClassLoader();
    private ConfigurationManager configurationManager;
    private ResourceLoader resourceLoader;
    private String servicesConfigPath;
    private ServletContext servletContext;
    private Set<MessageBrokerConfigProcessor> configProcessors = new HashSet<MessageBrokerConfigProcessor>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterPropertiesSet() throws Exception {
        try {
            DelegatingServletConfig servletConfig = new DelegatingServletConfig();
            FlexContext.setThreadLocalObjects(null, null, null, null, null, (ServletConfig)servletConfig);
            if (this.configurationManager == null) {
                this.configurationManager = new FlexConfigurationManager(this.resourceLoader, this.servicesConfigPath);
            }
            MessagingConfiguration messagingConfig = this.configurationManager.getMessagingConfiguration((ServletConfig)servletConfig);
            messagingConfig.createLogAndTargets();
            this.messageBroker = messagingConfig.createBroker(this.name, this.beanClassLoader);
            FlexContext.setThreadLocalObjects(null, null, (MessageBroker)this.messageBroker, null, null, (ServletConfig)servletConfig);
            this.setupInternalPathResolver();
            this.setInitServletContext();
            if (logger.isInfoEnabled()) {
                logger.info((Object)VersionInfo.buildMessage());
            }
            messagingConfig.configureBroker(this.messageBroker);
            long timeBeforeStartup = 0L;
            if (logger.isInfoEnabled()) {
                timeBeforeStartup = System.currentTimeMillis();
                logger.info((Object)("MessageBroker with id '" + this.messageBroker.getId() + "' is starting."));
            }
            Object object = HttpFlexSession.mapLock;
            synchronized (object) {
                if (servletConfig.getServletContext().getAttribute("LCDS_HTTP_TO_FLEX_SESSION_MAP") == null) {
                    servletConfig.getServletContext().setAttribute("LCDS_HTTP_TO_FLEX_SESSION_MAP", (Object)new ConcurrentHashMap());
                }
            }
            this.messageBroker = this.processBeforeStart(this.messageBroker);
            this.messageBroker.start();
            this.messageBroker = this.processAfterStart(this.messageBroker);
            if (logger.isInfoEnabled()) {
                long timeAfterStartup = System.currentTimeMillis();
                Long diffMillis = new Long(timeAfterStartup - timeBeforeStartup);
                logger.info((Object)("MessageBroker with id '" + this.messageBroker.getId() + "' is ready (startup time: '" + diffMillis + "' ms)"));
            }
            this.configurationManager.reportTokens();
            messagingConfig.reportUnusedProperties();
        }
        catch (Throwable error) {
            this.destroy();
            throw new BeanInitializationException("MessageBroker initialization failed", error);
        }
    }

    public void destroy() throws Exception {
        FlexContext.clearThreadLocalObjects();
        if (this.messageBroker != null) {
            this.messageBroker.stop();
            if (this.messageBroker.isManaged()) {
                MBeanLifecycleManager.unregisterRuntimeMBeans((MessageBroker)this.messageBroker);
            }
        }
    }

    public Set<MessageBrokerConfigProcessor> getConfigProcessors() {
        return this.configProcessors;
    }

    public Object getObject() throws Exception {
        return this.messageBroker;
    }

    public Class<? extends MessageBroker> getObjectType() {
        return this.messageBroker != null ? this.messageBroker.getClass() : MessageBroker.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.beanClassLoader = classLoader;
    }

    public void setBeanName(String name) {
        this.name = name;
    }

    public void setConfigProcessors(Set<MessageBrokerConfigProcessor> startupProcessors) {
        this.configProcessors = startupProcessors;
    }

    public void setConfigurationManager(ConfigurationManager configurationManager) {
        this.configurationManager = configurationManager;
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public void setServicesConfigPath(String servicesConfigPath) {
        this.servicesConfigPath = servicesConfigPath;
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    private MessageBroker processAfterStart(MessageBroker broker) {
        for (MessageBrokerConfigProcessor processor : this.configProcessors) {
            broker = processor.processAfterStartup(broker);
        }
        return broker;
    }

    private MessageBroker processBeforeStart(MessageBroker broker) {
        for (MessageBrokerConfigProcessor processor : this.configProcessors) {
            broker = processor.processBeforeStartup(broker);
        }
        return broker;
    }

    private void setInitServletContext() {
        Method initMethod = ReflectionUtils.findMethod(MessageBroker.class, (String)"setServletContext", (Class[])new Class[]{ServletContext.class});
        if (initMethod == null) {
            initMethod = ReflectionUtils.findMethod(MessageBroker.class, (String)"setInitServletContext", (Class[])new Class[]{ServletContext.class});
        }
        ReflectionUtils.makeAccessible((Method)initMethod);
        ReflectionUtils.invokeMethod((Method)initMethod, (Object)this.messageBroker, (Object[])new Object[]{this.servletContext});
    }

    private void setupInternalPathResolver() {
        this.messageBroker.setInternalPathResolver(new MessageBroker.InternalPathResolver(){

            public InputStream resolve(String filename) {
                try {
                    return MessageBrokerFactoryBean.this.resourceLoader.getResource(String.valueOf(FLEXDIR) + filename).getInputStream();
                }
                catch (IOException iOException) {
                    throw new IllegalStateException("Could not resolve Flex internal resource at: " + FLEXDIR + filename);
                }
            }
        });
    }

    private class DelegatingServletConfig
    implements ServletConfig {
        private DelegatingServletConfig() {
        }

        public String getInitParameter(String paramName) {
            return null;
        }

        public Enumeration getInitParameterNames() {
            return Collections.enumeration(Collections.EMPTY_SET);
        }

        public ServletContext getServletContext() {
            return MessageBrokerFactoryBean.this.servletContext;
        }

        public String getServletName() {
            return MessageBrokerFactoryBean.this.name;
        }
    }
}

