/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.flex.config;

import flex.messaging.config.ConfigurationException;
import flex.messaging.config.ConfigurationFileResolver;
import flex.messaging.config.ConfigurationManager;
import flex.messaging.config.ConfigurationParser;
import flex.messaging.config.MessagingConfiguration;
import flex.messaging.config.ServerConfigurationParser;
import flex.messaging.config.ServicesConfiguration;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import javax.servlet.ServletConfig;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathException;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.JdkVersion;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FlexConfigurationManager
implements ConfigurationManager,
ResourceLoaderAware {
    private static final Log log = LogFactory.getLog(FlexConfigurationManager.class);
    public static final String DEFAULT_CONFIG_PATH = "/WEB-INF/flex/services-config.xml";
    private ResourceLoader resourceLoader;
    private String configurationPath;
    private ConfigurationParser parser = null;

    public FlexConfigurationManager() {
        this.configurationPath = DEFAULT_CONFIG_PATH;
    }

    public FlexConfigurationManager(ResourceLoader resourceLoader, String configurationPath) {
        this.resourceLoader = resourceLoader;
        this.configurationPath = StringUtils.hasText((String)configurationPath) ? configurationPath : DEFAULT_CONFIG_PATH;
    }

    public MessagingConfiguration getMessagingConfiguration(ServletConfig servletConfig) {
        Assert.isTrue((boolean)JdkVersion.isAtLeastJava15(), (String)"Spring BlazeDS Integration requires a minimum of Java 1.5");
        Assert.notNull((Object)servletConfig, (String)"FlexConfigurationManager requires a non-null ServletConfig - Is it being used outside a WebApplicationContext?");
        MessagingConfiguration configuration = new MessagingConfiguration();
        configuration.getSecuritySettings().setServerInfo(servletConfig.getServletContext().getServerInfo());
        if (this.parser == null) {
            this.parser = this.getDefaultConfigurationParser();
        }
        Assert.notNull((Object)this.parser, (String)"Unable to create a parser to load Flex messaging configuration.");
        this.parser.parse(this.configurationPath, (ConfigurationFileResolver)new ResourceResolverAdapter(this.resourceLoader), (ServicesConfiguration)configuration);
        return configuration;
    }

    public void reportTokens() {
        this.parser.reportTokens();
    }

    public void setConfigurationParser(ConfigurationParser parser) {
        this.parser = parser;
    }

    public void setConfigurationPath(String configurationPath) {
        this.configurationPath = configurationPath;
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    private ConfigurationParser getDefaultConfigurationParser() {
        return new CachingXPathServerConfigurationParser();
    }

    private static class CachingXPathServerConfigurationParser
    extends ServerConfigurationParser {
        private XPath xpath = null;
        private Map<String, XPathExpression> exprCache = null;

        private CachingXPathServerConfigurationParser() {
        }

        protected void initializeExpressionQuery() {
            if (this.xpath == null) {
                this.xpath = XPathFactory.newInstance().newXPath();
            } else {
                this.xpath.reset();
            }
            this.exprCache = new HashMap<String, XPathExpression>();
        }

        protected Object evaluateExpression(Node source, String expression) {
            try {
                return this.getXPathExpression(expression).evaluate(source, XPathConstants.STRING);
            }
            catch (XPathExpressionException expressionException) {
                throw this.wrapException(expressionException);
            }
        }

        protected NodeList selectNodeList(Node source, String expression) {
            try {
                return (NodeList)this.getXPathExpression(expression).evaluate(source, XPathConstants.NODESET);
            }
            catch (XPathExpressionException expressionException) {
                throw this.wrapException(expressionException);
            }
        }

        protected Node selectSingleNode(Node source, String expression) {
            try {
                return (Node)this.getXPathExpression(expression).evaluate(source, XPathConstants.NODE);
            }
            catch (XPathExpressionException expressionException) {
                throw this.wrapException(expressionException);
            }
        }

        private XPathExpression getXPathExpression(String expression) {
            try {
                XPathExpression compiledExpression = this.exprCache.get(expression);
                if (compiledExpression == null) {
                    compiledExpression = this.xpath.compile(expression);
                    this.exprCache.put(expression, compiledExpression);
                }
                return compiledExpression;
            }
            catch (XPathExpressionException ex) {
                throw this.wrapException(ex);
            }
        }

        private ConfigurationException wrapException(XPathException exception) {
            ConfigurationException result = new ConfigurationException();
            result.setDetails(10101);
            result.setRootCause((Throwable)exception);
            return result;
        }
    }

    private static class ResourceResolverAdapter
    implements ConfigurationFileResolver {
        private final Stack<Resource> configurationPathStack = new Stack();
        private final ResourceLoader resourceLoader;

        public ResourceResolverAdapter(ResourceLoader resourceLoader) {
            this.resourceLoader = resourceLoader;
        }

        public InputStream getConfigurationFile(String path) {
            try {
                Object resource;
                if (this.resourceLoader instanceof ResourcePatternResolver) {
                    ResourcePatternResolver resolver = (ResourcePatternResolver)this.resourceLoader;
                    Object[] resources = resolver.getResources(path);
                    Assert.notEmpty((Object[])resources, (String)("Flex configuration file could not be resolved using pattern: " + path));
                    Assert.isTrue((resources.length == 1 ? 1 : 0) != 0, (String)("Invalid pattern used for flex configuration file.  More than one resource resolved using pattern: " + path));
                    resource = resources[0];
                } else {
                    resource = this.resourceLoader.getResource(path);
                }
                Assert.isTrue((boolean)resource.exists(), (String)("Flex configuration file does not exist at path: " + path));
                this.pushConfigurationFile((Resource)resource);
                if (log.isInfoEnabled()) {
                    log.info((Object)("Loading Flex services configuration from: " + resource.toString()));
                }
                return resource.getInputStream();
            }
            catch (IOException iOException) {
                throw new IllegalStateException("Flex configuration file could not be loaded from path: " + path);
            }
        }

        public InputStream getIncludedFile(String relativePath) {
            Resource parent = this.configurationPathStack.peek();
            try {
                Resource resource = parent.createRelative(relativePath);
                if (resource.exists()) {
                    this.pushConfigurationFile(resource);
                    if (log.isInfoEnabled()) {
                        log.info((Object)("Including Flex services configuration from: " + resource.toString()));
                    }
                    return resource.getInputStream();
                }
                throw new IllegalStateException("Included Flex configuration file does not exist at relative path: " + relativePath);
            }
            catch (IOException iOException) {
                throw new IllegalStateException("Included Flex configuration file could not be loaded from path: " + relativePath);
            }
        }

        public void popIncludedFile() {
            this.configurationPathStack.pop();
        }

        private void pushConfigurationFile(Resource configFile) {
            this.configurationPathStack.push(configFile);
        }
    }
}

