/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.yarn.boot;

import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.security.SecurityProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.web.client.RestTemplate;

@Configuration
@ConditionalOnClass(value={HttpClient.class, RestTemplate.class, SessionCreationPolicy.class})
public class YarnRestTemplateAutoConfiguration {

    @ConditionalOnProperty(prefix="security.basic", name={"enabled"}, havingValue="true")
    @ConditionalOnMissingBean(name={"yarnRestTemplate"})
    public static class BasicAuthConfig {
        @Autowired
        private SecurityProperties securityProperties;

        @Bean(name={"yarnRestTemplate"})
        public RestTemplate restTemplate() {
            HttpClientBuilder builder = HttpClientBuilder.create();
            UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(this.securityProperties.getUser().getName(), this.securityProperties.getUser().getPassword());
            BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
            credentialsProvider.setCredentials(new AuthScope(null, -1, null), (Credentials)credentials);
            builder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
            CloseableHttpClient httpClient = builder.build();
            return new RestTemplate((ClientHttpRequestFactory)new HttpComponentsClientHttpRequestFactory((HttpClient)httpClient));
        }
    }
}

