/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.yarn.boot.support;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.context.embedded.EmbeddedServletContainerInitializedEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.web.client.RestTemplate;
import org.springframework.yarn.boot.actuate.endpoint.mvc.domain.ContainerRegisterResource;
import org.springframework.yarn.support.LifecycleObjectSupport;
import org.springframework.yarn.support.NetworkUtils;

public class ContainerRegistrar
extends LifecycleObjectSupport
implements ApplicationListener<EmbeddedServletContainerInitializedEvent> {
    private static final Log log = LogFactory.getLog(ContainerRegistrar.class);
    private String trackUrl;
    private String containerId;

    public ContainerRegistrar(String trackUrl, String containerId) {
        this.trackUrl = trackUrl;
        this.containerId = containerId;
    }

    public void onApplicationEvent(EmbeddedServletContainerInitializedEvent event) {
        String namespace = event.getApplicationContext().getNamespace();
        if ("management".equals(namespace)) {
            return;
        }
        int port = event.getEmbeddedServletContainer().getPort();
        try {
            RestTemplate restTemplate = (RestTemplate)this.getBeanFactory().getBean("yarnRestTemplate", RestTemplate.class);
            String url = "http://" + NetworkUtils.getDefaultAddress() + ":" + port;
            ContainerRegisterResource request = new ContainerRegisterResource(this.containerId, url);
            log.info((Object)("Registering containerId=[" + this.containerId + "] with url=[" + url + "]"));
            restTemplate.postForObject(this.trackUrl + "/yarn_containerregister", (Object)request, Object.class, new Object[0]);
        }
        catch (Exception e) {
            log.warn((Object)"Error registering with appmaster", (Throwable)e);
        }
    }
}

