/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.yarn.boot;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StringUtils;
import org.springframework.yarn.boot.condition.ConditionalOnMissingYarn;
import org.springframework.yarn.boot.properties.SpringHadoopProperties;
import org.springframework.yarn.boot.properties.SpringYarnClientLaunchContextProperties;
import org.springframework.yarn.boot.properties.SpringYarnClientLocalizerProperties;
import org.springframework.yarn.boot.properties.SpringYarnClientProperties;
import org.springframework.yarn.boot.properties.SpringYarnClientResourceProperties;
import org.springframework.yarn.boot.properties.SpringYarnEnvProperties;
import org.springframework.yarn.boot.properties.SpringYarnProperties;
import org.springframework.yarn.boot.support.BootLocalResourcesSelector;
import org.springframework.yarn.boot.support.ClientLauncherRunner;
import org.springframework.yarn.boot.support.SpringYarnBootUtils;
import org.springframework.yarn.client.YarnClient;
import org.springframework.yarn.config.annotation.EnableYarn;
import org.springframework.yarn.config.annotation.SpringYarnConfigurerAdapter;
import org.springframework.yarn.config.annotation.builders.YarnClientConfigurer;
import org.springframework.yarn.config.annotation.builders.YarnConfigConfigurer;
import org.springframework.yarn.config.annotation.builders.YarnEnvironmentConfigurer;
import org.springframework.yarn.config.annotation.builders.YarnResourceLocalizerConfigurer;
import org.springframework.yarn.config.annotation.configurers.LocalResourcesHdfsConfigurer;
import org.springframework.yarn.fs.LocalResourcesSelector;
import org.springframework.yarn.launch.LaunchCommandsFactoryBean;

@Configuration
@ConditionalOnMissingYarn
@ConditionalOnClass(value={EnableYarn.class})
@ConditionalOnMissingBean(value={YarnClient.class})
public class YarnClientAutoConfiguration {
    private static String explodedEntryIfZip(SpringYarnClientLaunchContextProperties syclcp) {
        return StringUtils.endsWithIgnoreCase((String)syclcp.getArchiveFile(), (String)".zip") ? "./" + syclcp.getArchiveFile() : null;
    }

    private static String[] createMasterCommands(SpringYarnClientLaunchContextProperties syclcp) throws Exception {
        LaunchCommandsFactoryBean factory = new LaunchCommandsFactoryBean();
        String appmasterJar = syclcp.getArchiveFile();
        if (StringUtils.hasText((String)appmasterJar) && appmasterJar.endsWith("jar")) {
            factory.setJarFile(syclcp.getArchiveFile());
        } else if (StringUtils.hasText((String)syclcp.getRunnerClass())) {
            factory.setRunnerClass(syclcp.getRunnerClass());
        } else if (StringUtils.hasText((String)appmasterJar) && appmasterJar.endsWith("zip")) {
            factory.setRunnerClass("org.springframework.boot.loader.PropertiesLauncher");
        }
        factory.setArgumentsList(syclcp.getArgumentsList());
        if (syclcp.getArguments() != null) {
            Properties arguments = new Properties();
            arguments.putAll(syclcp.getArguments());
            factory.setArguments(arguments);
        }
        factory.setOptions(syclcp.getOptions());
        factory.setStdout("<LOG_DIR>/Appmaster.stdout");
        factory.setStderr("<LOG_DIR>/Appmaster.stderr");
        factory.afterPropertiesSet();
        return factory.getObject();
    }

    private static Map<String, byte[]> unescapeMapKeys(Map<String, byte[]> map) {
        if (map == null || map.isEmpty()) {
            return map;
        }
        HashMap<String, byte[]> nmap = new HashMap<String, byte[]>();
        for (String key : map.keySet()) {
            nmap.put(SpringYarnBootUtils.unescapeConfigKey(key), map.get(key));
        }
        return nmap;
    }

    @Configuration
    @EnableConfigurationProperties(value={SpringHadoopProperties.class, SpringYarnProperties.class, SpringYarnEnvProperties.class, SpringYarnClientProperties.class, SpringYarnClientLaunchContextProperties.class, SpringYarnClientLocalizerProperties.class, SpringYarnClientResourceProperties.class})
    @EnableYarn(enable=EnableYarn.Enable.CLIENT)
    public static class SpringYarnConfig
    extends SpringYarnConfigurerAdapter {
        @Autowired
        private SpringYarnProperties syp;
        @Autowired
        private SpringHadoopProperties shp;
        @Autowired
        private SpringYarnClientProperties sycp;
        @Autowired
        private SpringYarnClientLaunchContextProperties syclcp;
        @Autowired
        private SpringYarnClientLocalizerProperties syclp;
        @Autowired
        private SpringYarnClientResourceProperties sycrp;
        @Autowired
        private LocalResourcesSelector localResourcesSelector;

        public void configure(YarnConfigConfigurer config) throws Exception {
            ((YarnConfigConfigurer)((YarnConfigConfigurer)config.fileSystemUri(this.shp.getFsUri()).resourceManagerAddress(this.shp.getResourceManagerAddress()).schedulerAddress(this.shp.getResourceManagerSchedulerAddress()).withProperties().properties(this.shp.getConfig()).and()).withResources().resources(this.shp.getResources()).and()).withSecurity().namenodePrincipal(this.shp.getSecurity() != null ? this.shp.getSecurity().getNamenodePrincipal() : null).rmManagerPrincipal(this.shp.getSecurity() != null ? this.shp.getSecurity().getRmManagerPrincipal() : null).authMethod(this.shp.getSecurity() != null ? this.shp.getSecurity().getAuthMethod() : null).userPrincipal(this.shp.getSecurity() != null ? this.shp.getSecurity().getUserPrincipal() : null).userKeytab(this.shp.getSecurity() != null ? this.shp.getSecurity().getUserKeytab() : null);
        }

        public void configure(YarnResourceLocalizerConfigurer localizer) throws Exception {
            String applicationDir = SpringYarnBootUtils.resolveApplicationdir(this.syp);
            localizer.stagingDirectory(this.syp.getStagingDir()).withCopy().copy(StringUtils.toStringArray(this.sycp.getFiles()), applicationDir, applicationDir == null).raw(YarnClientAutoConfiguration.unescapeMapKeys(this.syclp.getRawFileContents()), applicationDir);
            LocalResourcesHdfsConfigurer withHdfs = localizer.withHdfs();
            for (LocalResourcesSelector.Entry e : this.localResourcesSelector.select(applicationDir != null ? applicationDir : "/")) {
                withHdfs.hdfs(e.getPath(), e.getType(), applicationDir == null);
            }
        }

        public void configure(YarnEnvironmentConfigurer environment) throws Exception {
            environment.includeLocalSystemEnv(this.syclcp.isIncludeLocalSystemEnv()).withClasspath().includeBaseDirectory(this.syclcp.isIncludeBaseDirectory()).useYarnAppClasspath(this.syclcp.isUseYarnAppClasspath()).useMapreduceAppClasspath(this.syclcp.isUseMapreduceAppClasspath()).siteYarnAppClasspath(this.syp.getSiteYarnAppClasspath()).siteMapreduceAppClasspath(this.syp.getSiteMapreduceAppClasspath()).delimiter(this.syclcp.getPathSeparator()).entries(this.syclcp.getContainerAppClasspath()).entry(YarnClientAutoConfiguration.explodedEntryIfZip(this.syclcp));
        }

        public void configure(YarnClientConfigurer client) throws Exception {
            client.clientClass(this.sycp.getClientClass()).appName(this.syp.getAppName()).appType(this.syp.getAppType()).priority(this.sycp.getPriority()).queue(this.sycp.getQueue()).memory(this.sycrp.getMemory()).virtualCores(this.sycrp.getVirtualCores()).masterCommands(YarnClientAutoConfiguration.createMasterCommands(this.syclcp));
        }
    }

    @Configuration
    @EnableConfigurationProperties(value={SpringYarnClientLocalizerProperties.class})
    public static class LocalResourcesSelectorConfig {
        @Autowired
        private SpringYarnClientLocalizerProperties syclp;

        @Bean
        @ConditionalOnMissingBean(value={LocalResourcesSelector.class})
        public LocalResourcesSelector localResourcesSelector() {
            BootLocalResourcesSelector selector = new BootLocalResourcesSelector(BootLocalResourcesSelector.Mode.APPMASTER);
            if (StringUtils.hasText((String)this.syclp.getZipPattern())) {
                selector.setZipArchivePattern(this.syclp.getZipPattern());
            }
            if (this.syclp.getPropertiesNames() != null) {
                selector.setPropertiesNames(this.syclp.getPropertiesNames());
            }
            if (this.syclp.getPropertiesSuffixes() != null) {
                selector.setPropertiesSuffixes(this.syclp.getPropertiesSuffixes());
            }
            selector.addPatterns(this.syclp.getPatterns());
            return selector;
        }
    }

    @Configuration
    @EnableConfigurationProperties(value={SpringYarnClientProperties.class})
    public static class RunnerConfig {
        @Autowired
        private SpringYarnClientProperties sycp;

        @Bean
        @ConditionalOnMissingBean(value={ClientLauncherRunner.class})
        @ConditionalOnBean(value={YarnClient.class})
        public ClientLauncherRunner clientLauncherRunner() {
            return new ClientLauncherRunner(this.sycp.getStartup() != null ? this.sycp.getStartup().getAction() : null);
        }
    }
}

