/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.yarn.boot.cli;

import java.util.Properties;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import org.springframework.util.StringUtils;
import org.springframework.yarn.boot.app.YarnInfoApplication;
import org.springframework.yarn.boot.cli.AbstractApplicationCommand;
import org.springframework.yarn.boot.cli.CliSystemConstants;

public class YarnSubmittedCommand
extends AbstractApplicationCommand {
    public static final String DEFAULT_COMMAND = "submitted";
    public static final String DEFAULT_DESC = "List submitted applications";

    public YarnSubmittedCommand() {
        this(DEFAULT_COMMAND, DEFAULT_DESC, new SubmittedOptionHandler(null));
    }

    public YarnSubmittedCommand(SubmittedOptionHandler handler) {
        this(DEFAULT_COMMAND, DEFAULT_DESC, handler);
    }

    public YarnSubmittedCommand(String name, String description, SubmittedOptionHandler handler) {
        super(name, description, handler);
    }

    public static class SubmittedOptionHandler
    extends AbstractApplicationCommand.ApplicationOptionHandler<String> {
        private String defaultAppType = "BOOT";
        private OptionSpec<String> typeOption;
        private OptionSpec<Boolean> verboseOption;

        public SubmittedOptionHandler() {
            this(null);
        }

        public SubmittedOptionHandler(String defaultAppType) {
            if (StringUtils.hasText((String)defaultAppType)) {
                this.defaultAppType = defaultAppType;
            }
        }

        protected final void options() {
            this.typeOption = this.option(CliSystemConstants.OPTIONS_APPLICATION_TYPE, "Application type").withOptionalArg().defaultsTo((Object)this.defaultAppType, (Object[])new String[0]);
            this.verboseOption = this.option(CliSystemConstants.OPTIONS_VERBOSE, "Verbose output").withOptionalArg().ofType(Boolean.class).defaultsTo((Object)true, (Object[])new Boolean[0]);
        }

        @Override
        protected void runApplication(OptionSet options) throws Exception {
            YarnInfoApplication app = new YarnInfoApplication();
            Properties appProperties = new Properties();
            appProperties.setProperty("spring.yarn.internal.YarnInfoApplication.operation", "SUBMITTED");
            if (this.isFlagOn(options, this.verboseOption)) {
                appProperties.setProperty("spring.yarn.internal.YarnInfoApplication.verbose", "true");
            }
            appProperties.setProperty("spring.yarn.internal.YarnInfoApplication.type", (String)options.valueOf(this.typeOption));
            app.appProperties(appProperties);
            this.handleApplicationRun(app);
        }

        public String getDefaultAppType() {
            return this.defaultAppType;
        }

        public OptionSpec<String> getTypeOption() {
            return this.typeOption;
        }

        public OptionSpec<Boolean> getVerboseOption() {
            return this.verboseOption;
        }
    }
}

