/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.yarn.boot.cli;

import java.util.ArrayList;
import java.util.List;
import org.springframework.boot.cli.command.Command;
import org.springframework.boot.cli.command.CommandRunner;
import org.springframework.boot.cli.command.core.HelpCommand;
import org.springframework.boot.cli.command.core.VersionCommand;
import org.springframework.boot.loader.tools.LogbackInitializer;

public abstract class AbstractCli {
    private final List<Command> commands = new ArrayList<Command>();

    protected void registerCommand(Command command) {
        this.commands.add(command);
    }

    protected void registerCommands(List<Command> commands) {
        this.commands.addAll(commands);
    }

    protected void doMain(String[] args) {
        System.setProperty("java.awt.headless", Boolean.toString(true));
        LogbackInitializer.initialize();
        CommandRunner runner = new CommandRunner(this.getMainCommandName());
        runner.addCommand((Command)new HelpCommand(runner));
        for (Command command : this.commands) {
            runner.addCommand(command);
        }
        runner.setOptionCommands(new Class[]{HelpCommand.class, VersionCommand.class});
        int exitCode = runner.runAndHandleErrors(args);
        this.handleRunnerExitCode(runner, exitCode);
    }

    protected void handleRunnerExitCode(CommandRunner runner, int exitCode) {
        if (exitCode != 0) {
            System.exit(exitCode);
        }
    }

    protected String getMainCommandName() {
        return "java -jar <jar>";
    }
}

