/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.yarn.batch.partition;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.fs.Path;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.core.io.Resource;
import org.springframework.data.hadoop.fs.HdfsResourceLoader;
import org.springframework.data.hadoop.store.split.Split;
import org.springframework.data.hadoop.store.split.Splitter;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.yarn.batch.partition.AbstractPartitioner;

public class SplitterPartitioner
extends AbstractPartitioner {
    private Splitter splitter;
    private Set<String> inputPatterns;

    @Override
    protected Map<String, ExecutionContext> createPartitions() {
        HashMap<String, ExecutionContext> contexts = new HashMap<String, ExecutionContext>();
        try {
            int i = 0;
            for (Resource resource : this.resolveResources()) {
                Assert.state((boolean)resource.exists(), (String)("Resource does not exist: " + resource));
                List inputSplits = this.splitter.getSplits(new Path(resource.getURI()));
                for (Split split : inputSplits) {
                    contexts.put(this.getPartitionBaseIdentifier() + i++, this.createExecutionContext(resource, split));
                }
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Error partitioning splits", e);
        }
        return contexts;
    }

    public void setInputPatterns(String inputPatterns) {
        this.setInputPatterns(StringUtils.commaDelimitedListToSet((String)inputPatterns));
    }

    public void setInputPatterns(Set<String> inputPatterns) {
        this.inputPatterns = inputPatterns;
    }

    public void setSplitter(Splitter splitter) {
        this.splitter = splitter;
    }

    private Set<Resource> resolveResources() throws IOException {
        HashSet<Resource> resources = new HashSet<Resource>();
        HdfsResourceLoader loader = new HdfsResourceLoader(this.getConfiguration());
        if (this.inputPatterns != null) {
            for (String pattern : this.inputPatterns) {
                resources.addAll(Arrays.asList(loader.getResources(pattern)));
            }
        }
        loader.close();
        return resources;
    }
}

