/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.solr.core.query;

import java.util.Collection;
import java.util.Collections;
import org.springframework.data.geo.Box;
import org.springframework.data.geo.Distance;
import org.springframework.data.geo.Point;
import org.springframework.data.solr.core.query.Criteria;
import org.springframework.data.solr.core.query.Function;
import org.springframework.lang.Nullable;

public abstract class Node {
    @Nullable
    private Node parent;
    private boolean isOr = false;
    private boolean negating = false;

    protected Node() {
    }

    protected void setParent(@Nullable Node parent) {
        this.parent = parent;
    }

    public void setPartIsOr(boolean isOr) {
        this.isOr = isOr;
    }

    public boolean isRoot() {
        return this.parent == null;
    }

    public boolean isOr() {
        return this.isOr;
    }

    @Nullable
    public Node getParent() {
        return this.parent;
    }

    public boolean hasSiblings() {
        return !this.getSiblings().isEmpty();
    }

    public Collection<Criteria> getSiblings() {
        return Collections.emptyList();
    }

    public boolean isNegating() {
        return this.negating;
    }

    protected void setNegating(boolean negating) {
        this.negating = negating;
    }

    public abstract <T extends Node> T and(Node var1);

    public abstract <T extends Node> T and(String var1);

    public abstract <T extends Node> T or(Node var1);

    public abstract <T extends Node> T or(String var1);

    public abstract Node is(Object var1);

    public abstract Node is(Object ... var1);

    public abstract Node is(Iterable<?> var1);

    public abstract Node isNull();

    public abstract Node isNotNull();

    public abstract Node contains(String var1);

    public abstract Node contains(String ... var1);

    public abstract Node contains(Iterable<String> var1);

    public abstract Node startsWith(String var1);

    public abstract Node startsWith(String ... var1);

    public abstract Node startsWith(Iterable<String> var1);

    public abstract Node endsWith(String var1);

    public abstract Node endsWith(String ... var1);

    public abstract Node endsWith(Iterable<String> var1);

    public abstract Node not();

    public abstract Node fuzzy(String var1);

    public abstract Node fuzzy(String var1, float var2);

    public abstract Node sloppy(String var1, int var2);

    public abstract Node expression(String var1);

    public abstract Node boost(float var1);

    public abstract Node between(Object var1, Object var2);

    public abstract Node between(Object var1, Object var2, boolean var3, boolean var4);

    public abstract Node lessThan(Object var1);

    public abstract Node lessThanEqual(Object var1);

    public abstract Node greaterThan(Object var1);

    public abstract Node greaterThanEqual(Object var1);

    public abstract Node in(Object ... var1);

    public abstract Node in(Iterable<?> var1);

    public abstract Node within(Point var1, Distance var2);

    public abstract Node near(Box var1);

    public abstract Node near(Point var1, Distance var2);

    public abstract Node function(Function var1);
}

