/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.solr.core;

import java.time.Duration;
import java.util.Collection;
import java.util.Optional;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.response.SolrPingResponse;
import org.apache.solr.client.solrj.response.UpdateResponse;
import org.apache.solr.common.SolrInputDocument;
import org.springframework.data.domain.Page;
import org.springframework.data.solr.core.RequestMethod;
import org.springframework.data.solr.core.SolrCallback;
import org.springframework.data.solr.core.convert.SolrConverter;
import org.springframework.data.solr.core.query.FacetAndHighlightQuery;
import org.springframework.data.solr.core.query.FacetQuery;
import org.springframework.data.solr.core.query.HighlightQuery;
import org.springframework.data.solr.core.query.Query;
import org.springframework.data.solr.core.query.SolrDataQuery;
import org.springframework.data.solr.core.query.TermsQuery;
import org.springframework.data.solr.core.query.result.Cursor;
import org.springframework.data.solr.core.query.result.FacetAndHighlightPage;
import org.springframework.data.solr.core.query.result.FacetPage;
import org.springframework.data.solr.core.query.result.GroupPage;
import org.springframework.data.solr.core.query.result.HighlightPage;
import org.springframework.data.solr.core.query.result.ScoredPage;
import org.springframework.data.solr.core.query.result.StatsPage;
import org.springframework.data.solr.core.query.result.TermsPage;
import org.springframework.data.solr.core.schema.SchemaOperations;

public interface SolrOperations {
    public SolrClient getSolrClient();

    public SolrPingResponse ping();

    public SolrPingResponse ping(String var1);

    public long count(String var1, SolrDataQuery var2);

    public long count(String var1, SolrDataQuery var2, RequestMethod var3);

    default public UpdateResponse saveBean(String collection, Object obj) {
        return this.saveBean(collection, obj, Duration.ZERO);
    }

    public UpdateResponse saveBean(String var1, Object var2, Duration var3);

    default public UpdateResponse saveBeans(String collection, Collection<?> beans) {
        return this.saveBeans(collection, beans, Duration.ZERO);
    }

    public UpdateResponse saveBeans(String var1, Collection<?> var2, Duration var3);

    default public UpdateResponse saveDocument(String collection, SolrInputDocument document) {
        return this.saveDocument(collection, document, Duration.ZERO);
    }

    public UpdateResponse saveDocument(String var1, SolrInputDocument var2, Duration var3);

    default public UpdateResponse saveDocuments(String collection, Collection<SolrInputDocument> documents) {
        return this.saveDocuments(collection, documents, Duration.ZERO);
    }

    public UpdateResponse saveDocuments(String var1, Collection<SolrInputDocument> var2, Duration var3);

    public UpdateResponse delete(String var1, SolrDataQuery var2);

    public UpdateResponse deleteByIds(String var1, String var2);

    public UpdateResponse deleteByIds(String var1, Collection<String> var2);

    public <T> Optional<T> queryForObject(String var1, Query var2, Class<T> var3);

    public <T> Optional<T> queryForObject(String var1, Query var2, Class<T> var3, RequestMethod var4);

    public <T> ScoredPage<T> queryForPage(String var1, Query var2, Class<T> var3);

    public <T> ScoredPage<T> queryForPage(String var1, Query var2, Class<T> var3, RequestMethod var4);

    public <T> FacetPage<T> queryForFacetPage(String var1, FacetQuery var2, Class<T> var3);

    public <T> FacetPage<T> queryForFacetPage(String var1, FacetQuery var2, Class<T> var3, RequestMethod var4);

    public <T> HighlightPage<T> queryForHighlightPage(String var1, HighlightQuery var2, Class<T> var3);

    public <T> HighlightPage<T> queryForHighlightPage(String var1, HighlightQuery var2, Class<T> var3, RequestMethod var4);

    public <T> FacetAndHighlightPage<T> queryForFacetAndHighlightPage(String var1, FacetAndHighlightQuery var2, Class<T> var3);

    public <T> FacetAndHighlightPage<T> queryForFacetAndHighlightPage(String var1, FacetAndHighlightQuery var2, Class<T> var3, RequestMethod var4);

    public TermsPage queryForTermsPage(String var1, TermsQuery var2);

    public TermsPage queryForTermsPage(String var1, TermsQuery var2, RequestMethod var3);

    public <T> Cursor<T> queryForCursor(String var1, Query var2, Class<T> var3);

    public <T> GroupPage<T> queryForGroupPage(String var1, Query var2, Class<T> var3);

    public <T> GroupPage<T> queryForGroupPage(String var1, Query var2, Class<T> var3, RequestMethod var4);

    public <T> StatsPage<T> queryForStatsPage(String var1, Query var2, Class<T> var3);

    public <T> StatsPage<T> queryForStatsPage(String var1, Query var2, Class<T> var3, RequestMethod var4);

    public <T, S extends Page<T>> S query(String var1, Query var2, Class<T> var3);

    public <T, S extends Page<T>> S query(String var1, Query var2, Class<T> var3, RequestMethod var4);

    public <T> Optional<T> getById(String var1, Object var2, Class<T> var3);

    public <T> Collection<T> getByIds(String var1, Collection<?> var2, Class<T> var3);

    public void commit(String var1);

    public void softCommit(String var1);

    public void rollback(String var1);

    public SolrInputDocument convertBeanToSolrInputDocument(Object var1);

    public SolrConverter getConverter();

    public <T> T execute(SolrCallback<T> var1);

    public SchemaOperations getSchemaOperations(String var1);
}

