/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.solr.repository.query;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.data.solr.core.query.Query;
import org.springframework.data.solr.core.query.SpellcheckOptions;
import org.springframework.data.solr.repository.Facet;
import org.springframework.data.solr.repository.Highlight;
import org.springframework.data.solr.repository.Pivot;
import org.springframework.data.solr.repository.Query;
import org.springframework.data.solr.repository.SelectiveStats;
import org.springframework.data.solr.repository.Spellcheck;
import org.springframework.data.solr.repository.Stats;
import org.springframework.data.solr.repository.query.SolrEntityInformationCreator;
import org.springframework.data.solr.repository.query.SolrParameters;
import org.springframework.data.util.ClassTypeInformation;
import org.springframework.data.util.TypeInformation;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class SolrQueryMethod
extends QueryMethod {
    private final Method method;

    public SolrQueryMethod(Method method, RepositoryMetadata metadata, ProjectionFactory factory, SolrEntityInformationCreator solrInformationCreator) {
        super(method, metadata, factory);
        this.method = method;
    }

    public boolean hasAnnotatedQuery() {
        return this.getAnnotatedQuery() != null;
    }

    public boolean hasQueryAnnotation() {
        return this.method.getAnnotation(Query.class) != null;
    }

    String getAnnotatedQuery() {
        return this.getAnnotationValueAsStringOrNullIfBlank(this.getQueryAnnotation(), "value");
    }

    public boolean hasAnnotatedNamedQueryName() {
        return this.getAnnotatedNamedQueryName() != null;
    }

    String getAnnotatedNamedQueryName() {
        return this.getAnnotationValueAsStringOrNullIfBlank(this.getQueryAnnotation(), "name");
    }

    private Query getQueryAnnotation() {
        return this.method.getAnnotation(Query.class);
    }

    TypeInformation<?> getReturnType() {
        return ClassTypeInformation.fromReturnTypeOf((Method)this.method);
    }

    public boolean hasProjectionFields() {
        if (this.hasQueryAnnotation()) {
            return !CollectionUtils.isEmpty(this.getProjectionFields());
        }
        return false;
    }

    public List<String> getProjectionFields() {
        return this.getAnnotationValuesAsStringList(this.getQueryAnnotation(), "fields");
    }

    public Integer getTimeAllowed() {
        if (this.hasQueryAnnotation()) {
            return this.getAnnotationValueAsIntOrNullIfNegative(this.getQueryAnnotation(), "timeAllowed");
        }
        return null;
    }

    public boolean isFacetQuery() {
        return this.hasFacetFields() || this.hasFacetQueries() || this.hasPivotFields();
    }

    public boolean hasFacetFields() {
        if (this.hasFacetAnnotation()) {
            return !CollectionUtils.isEmpty(this.getFacetFields());
        }
        return false;
    }

    public boolean hasPivotFields() {
        if (this.hasFacetAnnotation()) {
            return !CollectionUtils.isEmpty(this.getPivotFields());
        }
        return false;
    }

    private boolean hasFacetAnnotation() {
        return this.getFacetAnnotation() != null;
    }

    public List<String> getFacetFields() {
        return this.getAnnotationValuesAsStringList(this.getFacetAnnotation(), "fields");
    }

    public List<String> getFacetQueries() {
        return this.getAnnotationValuesAsStringList(this.getFacetAnnotation(), "queries");
    }

    public List<String[]> getPivotFields() {
        List<Pivot> pivotFields = this.getAnnotationValuesList(this.getFacetAnnotation(), "pivots", Pivot.class);
        ArrayList<String[]> result = new ArrayList<String[]>();
        for (Pivot pivot : pivotFields) {
            result.add(pivot.value());
        }
        return result;
    }

    public boolean hasFacetQueries() {
        if (this.hasFacetAnnotation()) {
            return !CollectionUtils.isEmpty(this.getFacetQueries());
        }
        return false;
    }

    private Facet getFacetAnnotation() {
        return this.method.getAnnotation(Facet.class);
    }

    public Integer getFacetLimit() {
        return (Integer)AnnotationUtils.getValue((Annotation)this.getFacetAnnotation(), (String)"limit");
    }

    public Integer getFacetMinCount() {
        return (Integer)AnnotationUtils.getValue((Annotation)this.getFacetAnnotation(), (String)"minCount");
    }

    public String getFacetPrefix() {
        return this.getAnnotationValueAsStringOrNullIfBlank(this.getFacetAnnotation(), "prefix");
    }

    private Stats getStatsAnnotation() {
        return this.method.getAnnotation(Stats.class);
    }

    public boolean hasStatsDefinition() {
        return this.getStatsAnnotation() != null && (!this.getFieldStats().isEmpty() || !this.getStatsFacets().isEmpty() || !this.getStatsSelectiveFacets().isEmpty() || !this.getStatsSelectiveCountDistinctFields().isEmpty());
    }

    public boolean isFieldStatsCountDistinctEnable() {
        Stats stats = this.getStatsAnnotation();
        return stats != null && stats.distinct();
    }

    public List<String> getFieldStats() {
        return this.getAnnotationValuesAsStringList(this.getStatsAnnotation(), "value");
    }

    public List<String> getStatsFacets() {
        return this.getAnnotationValuesAsStringList(this.getStatsAnnotation(), "facets");
    }

    public Map<String, String[]> getStatsSelectiveFacets() {
        List<SelectiveStats> selective = this.getAnnotationValuesList(this.getStatsAnnotation(), "selective", SelectiveStats.class);
        LinkedHashMap<String, String[]> result = new LinkedHashMap<String, String[]>();
        for (SelectiveStats selectiveFacet : selective) {
            result.put(selectiveFacet.field(), selectiveFacet.facets());
        }
        return result;
    }

    public Collection<String> getStatsSelectiveCountDistinctFields() {
        List<SelectiveStats> selective = this.getAnnotationValuesList(this.getStatsAnnotation(), "selective", SelectiveStats.class);
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        for (SelectiveStats selectiveFacet : selective) {
            if (!selectiveFacet.distinct()) continue;
            result.add(selectiveFacet.field());
        }
        return result;
    }

    public boolean hasFilterQuery() {
        if (this.hasQueryAnnotation()) {
            return !CollectionUtils.isEmpty(this.getFilterQueries());
        }
        return false;
    }

    public boolean isDeleteQuery() {
        if (this.hasQueryAnnotation()) {
            return (Boolean)AnnotationUtils.getValue((Annotation)this.getQueryAnnotation(), (String)"delete");
        }
        return false;
    }

    private Annotation getHighlightAnnotation() {
        return this.method.getAnnotation(Highlight.class);
    }

    private boolean hasHighlightAnnotation() {
        return this.getHighlightAnnotation() != null;
    }

    public boolean isHighlightQuery() {
        return this.hasHighlightAnnotation();
    }

    public List<String> getHighlightFieldNames() {
        if (this.hasHighlightAnnotation()) {
            return this.getAnnotationValuesAsStringList(this.getHighlightAnnotation(), "fields");
        }
        return Collections.emptyList();
    }

    public String getHighlightQuery() {
        if (this.hasHighlightAnnotation()) {
            return this.getAnnotationValueAsStringOrNullIfBlank(this.getHighlightAnnotation(), "query");
        }
        return null;
    }

    public Integer getHighlighSnipplets() {
        if (this.hasHighlightAnnotation()) {
            return this.getAnnotationValueAsIntOrNullIfNegative(this.getHighlightAnnotation(), "snipplets");
        }
        return null;
    }

    public Integer getHighlightFragsize() {
        if (this.hasHighlightAnnotation()) {
            return this.getAnnotationValueAsIntOrNullIfNegative(this.getHighlightAnnotation(), "fragsize");
        }
        return null;
    }

    public String getHighlightFormatter() {
        if (this.hasHighlightAnnotation()) {
            return this.getAnnotationValueAsStringOrNullIfBlank(this.getHighlightAnnotation(), "formatter");
        }
        return null;
    }

    public String getHighlightPrefix() {
        if (this.hasHighlightAnnotation()) {
            return this.getAnnotationValueAsStringOrNullIfBlank(this.getHighlightAnnotation(), "prefix");
        }
        return null;
    }

    public String getHighlightPostfix() {
        if (this.hasHighlightAnnotation()) {
            return this.getAnnotationValueAsStringOrNullIfBlank(this.getHighlightAnnotation(), "postfix");
        }
        return null;
    }

    public boolean hasHighlightFields() {
        return !this.getHighlightFieldNames().isEmpty();
    }

    List<String> getFilterQueries() {
        return this.getAnnotationValuesAsStringList(this.getQueryAnnotation(), "filters");
    }

    public Query.Operator getDefaultOperator() {
        if (this.hasQueryAnnotation()) {
            return this.getQueryAnnotation().defaultOperator();
        }
        return Query.Operator.NONE;
    }

    public String getDefType() {
        if (this.hasQueryAnnotation()) {
            return this.getQueryAnnotation().defType();
        }
        return null;
    }

    public String getRequestHandler() {
        if (this.hasQueryAnnotation()) {
            return this.getQueryAnnotation().requestHandler();
        }
        return null;
    }

    public Spellcheck getSpellcheckAnnotation() {
        return (Spellcheck)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)this.method, Spellcheck.class);
    }

    public boolean hasSpellcheck() {
        return this.getSpellcheckAnnotation() != null;
    }

    public SpellcheckOptions getSpellcheckOptions() {
        Spellcheck spellcheck = this.getSpellcheckAnnotation();
        if (spellcheck == null) {
            return null;
        }
        SpellcheckOptions sc = SpellcheckOptions.spellcheck();
        if (spellcheck.accuracy() >= 0.0f) {
            sc = sc.accuracy(spellcheck.accuracy());
        }
        if (spellcheck.buildDictionary()) {
            sc = sc.buildDictionary();
        }
        if (spellcheck.collate()) {
            sc = sc.collate();
        }
        if (spellcheck.collateExtendedResults()) {
            sc = sc.collateExtendedResults();
        }
        if (spellcheck.onlyMorePopular()) {
            sc = sc.onlyMorePopular();
        }
        if (spellcheck.alternativeTermCount() >= 0L) {
            sc = sc.alternativeTermCount(spellcheck.alternativeTermCount());
        }
        if (spellcheck.count() >= 0L) {
            sc = sc.count(spellcheck.count());
        }
        if (!ObjectUtils.isEmpty((Object[])spellcheck.dictionaries())) {
            sc = sc.dictionaries(spellcheck.dictionaries());
        }
        if (spellcheck.maxCollationEvaluations() >= 0L) {
            sc = sc.maxCollationEvaluations(spellcheck.maxCollationEvaluations());
        }
        if (spellcheck.maxCollations() >= 0L) {
            sc = sc.maxCollations(spellcheck.maxCollations());
        }
        if (spellcheck.maxCollationsTries() >= 0L) {
            sc = sc.maxCollationTries(spellcheck.maxCollationsTries());
        }
        if (spellcheck.maxResultsForSuggest() >= 0L) {
            sc = sc.maxResultsForSuggest(spellcheck.maxResultsForSuggest());
        }
        if (spellcheck.maxCollationCollectDocs() >= 0L) {
            sc = sc.maxCollationCollectDocs(spellcheck.maxCollationCollectDocs());
        }
        if (spellcheck.extendedResults()) {
            sc = sc.extendedResults();
        }
        return sc;
    }

    private String getAnnotationValueAsStringOrNullIfBlank(Annotation annotation, String attributeName) {
        String value = (String)AnnotationUtils.getValue((Annotation)annotation, (String)attributeName);
        return StringUtils.hasText((String)value) ? value : null;
    }

    private Integer getAnnotationValueAsIntOrNullIfNegative(Annotation annotation, String attributeName) {
        Integer timeAllowed = (Integer)AnnotationUtils.getValue((Annotation)annotation, (String)attributeName);
        if (timeAllowed != null && timeAllowed > 0) {
            return timeAllowed;
        }
        return null;
    }

    private List<String> getAnnotationValuesAsStringList(Annotation annotation, String attribute) {
        String[] values = (String[])AnnotationUtils.getValue((Annotation)annotation, (String)attribute);
        if (values.length > 1 || values.length == 1 && StringUtils.hasText((String)values[0])) {
            return CollectionUtils.arrayToList((Object)values);
        }
        return Collections.emptyList();
    }

    private <T> List<T> getAnnotationValuesList(Annotation annotation, String attribute, Class<T> clazz) {
        Object[] values = (Object[])AnnotationUtils.getValue((Annotation)annotation, (String)attribute);
        return CollectionUtils.arrayToList((Object)values);
    }

    public String getNamedQueryName() {
        if (!this.hasAnnotatedNamedQueryName()) {
            return super.getNamedQueryName();
        }
        return this.getAnnotatedNamedQueryName();
    }

    protected SolrParameters createParameters(Method method) {
        return new SolrParameters(method);
    }

    public SolrParameters getParameters() {
        return (SolrParameters)super.getParameters();
    }
}

