/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.solr.core.mapping;

import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.expression.BeanFactoryAccessor;
import org.springframework.context.expression.BeanFactoryResolver;
import org.springframework.data.annotation.Reference;
import org.springframework.data.mapping.PropertyHandler;
import org.springframework.data.mapping.model.BasicPersistentEntity;
import org.springframework.data.mapping.model.MappingException;
import org.springframework.data.solr.core.mapping.SolrDocument;
import org.springframework.data.solr.core.mapping.SolrPersistentEntity;
import org.springframework.data.solr.core.mapping.SolrPersistentProperty;
import org.springframework.data.solr.repository.Score;
import org.springframework.data.util.TypeInformation;
import org.springframework.expression.BeanResolver;
import org.springframework.expression.PropertyAccessor;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.util.StringUtils;

public class SimpleSolrPersistentEntity<T>
extends BasicPersistentEntity<T, SolrPersistentProperty>
implements SolrPersistentEntity<T>,
ApplicationContextAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(SimpleSolrPersistentEntity.class);
    private final TypeInformation<T> typeInformation;
    private final StandardEvaluationContext context = new StandardEvaluationContext();
    private String solrCoreName;
    private Float boost;

    public SimpleSolrPersistentEntity(TypeInformation<T> typeInformation) {
        super(typeInformation);
        this.typeInformation = typeInformation;
        this.solrCoreName = this.derivateSolrCoreName();
        this.boost = this.derivateDocumentBoost();
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.context.addPropertyAccessor((PropertyAccessor)new BeanFactoryAccessor());
        this.context.setBeanResolver((BeanResolver)new BeanFactoryResolver((BeanFactory)applicationContext));
        this.context.setRootObject((Object)applicationContext);
    }

    private String derivateSolrCoreName() {
        String derivativeSolrCoreName = this.typeInformation.getType().getSimpleName().toLowerCase(Locale.ENGLISH);
        SolrDocument solrDocument = (SolrDocument)this.findAnnotation(SolrDocument.class);
        if (solrDocument != null && StringUtils.hasText((String)solrDocument.solrCoreName())) {
            derivativeSolrCoreName = solrDocument.solrCoreName();
        }
        return derivativeSolrCoreName;
    }

    private Float derivateDocumentBoost() {
        SolrDocument solrDocument = (SolrDocument)this.findAnnotation(SolrDocument.class);
        if (solrDocument != null && !Float.isNaN(solrDocument.boost())) {
            return Float.valueOf(solrDocument.boost());
        }
        return null;
    }

    @Override
    public String getSolrCoreName() {
        return this.solrCoreName;
    }

    @Override
    public boolean isBoosted() {
        return this.boost != null;
    }

    @Override
    public Float getBoost() {
        return this.boost;
    }

    @Override
    public boolean hasScoreProperty() {
        return this.getScoreProperty() != null;
    }

    @Override
    public SolrPersistentProperty getScoreProperty() {
        return (SolrPersistentProperty)this.getPersistentProperty(Score.class);
    }

    public void verify() {
        super.verify();
        this.verifyScoreFieldUniqueness();
        this.verifyDynamicPropertyMapping();
        this.verifyAssociations();
    }

    private void verifyScoreFieldUniqueness() {
        this.doWithProperties(new ScoreFieldUniquenessHandler());
    }

    private void verifyDynamicPropertyMapping() {
        this.doWithProperties(DynamicFieldMappingHandler.INSTANCE);
    }

    private void verifyAssociations() {
        this.doWithProperties(AssociationFieldMappingHandler.INSTANCE);
    }

    private static enum AssociationFieldMappingHandler implements PropertyHandler<SolrPersistentProperty>
    {
        INSTANCE;


        public void doWithPersistentProperty(SolrPersistentProperty property) {
            if (property.isAnnotationPresent(Reference.class)) {
                LOGGER.warn("Associations via @Reference are not supported and will be ignored by Spring Data for Apache Solr. Please check property '%s' in %s", (Object)property.getName(), (Object)property.getOwner().getName());
            }
        }
    }

    private static enum DynamicFieldMappingHandler implements PropertyHandler<SolrPersistentProperty>
    {
        INSTANCE;

        private static final String DYNAMIC_PROPERTY_NOT_A_MAP = "Invalid mapping information for property '%s' with mapped name '%s'. @Dynamic can only be applied on Map based types!";
        private static final String DYNAMIC_PROPERTY_NOT_CONTAINING_WILDCARD = "Invalid mapping information for property '%s' with mapped name '%s'. Dynamic property needs to specify wildcard.";

        public void doWithPersistentProperty(SolrPersistentProperty property) {
            if (property.isDynamicProperty()) {
                if (!property.isMap()) {
                    throw new MappingException(String.format(DYNAMIC_PROPERTY_NOT_A_MAP, property.getName(), property.getFieldName()));
                }
                if (!property.containsWildcard()) {
                    throw new MappingException(String.format(DYNAMIC_PROPERTY_NOT_CONTAINING_WILDCARD, property.getName(), property.getFieldName()));
                }
            }
        }
    }

    private static class ScoreFieldUniquenessHandler
    implements PropertyHandler<SolrPersistentProperty> {
        private static final String AMBIGUOUS_FIELD_MAPPING = "Ambiguous score field mapping detected! Both %s and %s marked as target for score value. Disambiguate using @Score annotation!";
        private SolrPersistentProperty scoreProperty;

        private ScoreFieldUniquenessHandler() {
        }

        public void doWithPersistentProperty(SolrPersistentProperty persistentProperty) {
            this.assertUniqueness(persistentProperty);
        }

        private void assertUniqueness(SolrPersistentProperty property) {
            if (property.isScoreProperty()) {
                if (this.scoreProperty != null) {
                    throw new MappingException(String.format(AMBIGUOUS_FIELD_MAPPING, property.getFieldName(), this.scoreProperty.getFieldName()));
                }
                this.scoreProperty = property;
            }
        }
    }
}

