/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.solr;

import org.springframework.util.ClassUtils;

public final class VersionUtil {
    private static final boolean IS_SOLR_3_X_AVAILABLE = ClassUtils.isPresent((String)"org.apache.solr.client.solrj.impl.CommonsHttpSolrServer", (ClassLoader)VersionUtil.class.getClassLoader());
    private static final boolean IS_JODATIME_AVAILABLE = ClassUtils.isPresent((String)"org.joda.time.DateTime", (ClassLoader)VersionUtil.class.getClassLoader());
    private static final boolean IS_SOLR_4_2_AVAILABLE = ClassUtils.isPresent((String)"org.apache.solr.parser.ParseException", (ClassLoader)VersionUtil.class.getClassLoader());
    private static final boolean IS_SOLR_4_X_AVAILABLE = ClassUtils.isPresent((String)"org.apache.solr.client.solrj.impl.CloudSolrServer", (ClassLoader)VersionUtil.class.getClassLoader());
    private static final boolean IS_SOLR_5_X_AVAILABLE = ClassUtils.isPresent((String)"org.apache.solr.client.solrj.SolrClient", (ClassLoader)VersionUtil.class.getClassLoader());

    private VersionUtil() {
    }

    public static boolean isJodaTimeAvailable() {
        return IS_JODATIME_AVAILABLE;
    }

    public static boolean isSolr3XAvailable() {
        return IS_SOLR_3_X_AVAILABLE;
    }

    public static boolean isSolr4XAvailable() {
        return IS_SOLR_4_X_AVAILABLE;
    }

    public static boolean isSolr420Available() {
        return IS_SOLR_4_2_AVAILABLE;
    }

    public static boolean isSolr5XAvailable() {
        return IS_SOLR_5_X_AVAILABLE;
    }
}

