/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc.json;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import org.jspecify.annotations.Nullable;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.context.NoSuchMessageException;
import org.springframework.context.support.DefaultMessageSourceResolvable;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.ConditionalGenericConverter;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.data.domain.Sort;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.context.PersistentEntities;
import org.springframework.data.repository.support.RepositoryInvokerFactory;
import org.springframework.data.rest.core.config.JsonSchemaFormat;
import org.springframework.data.rest.core.config.RepositoryRestConfiguration;
import org.springframework.data.rest.core.mapping.ResourceDescription;
import org.springframework.data.rest.core.mapping.ResourceMapping;
import org.springframework.data.rest.core.mapping.ResourceMetadata;
import org.springframework.data.rest.webmvc.json.JacksonMetadata;
import org.springframework.data.rest.webmvc.json.JsonSchema;
import org.springframework.data.rest.webmvc.json.JsonSchemaPropertyCustomizer;
import org.springframework.data.rest.webmvc.mapping.Associations;
import org.springframework.data.util.Optionals;
import org.springframework.data.util.TypeInformation;
import org.springframework.hateoas.mediatype.MessageResolver;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import tools.jackson.databind.ObjectMapper;
import tools.jackson.databind.ValueSerializer;
import tools.jackson.databind.introspect.AnnotatedMember;
import tools.jackson.databind.introspect.BeanPropertyDefinition;

public class PersistentEntityToJsonSchemaConverter
implements ConditionalGenericConverter {
    private static final TypeDescriptor STRING_TYPE = TypeDescriptor.valueOf(String.class);
    private static final TypeDescriptor SCHEMA_TYPE = TypeDescriptor.valueOf(JsonSchema.class);
    private static final TypeInformation<?> STRING_TYPE_INFORMATION = TypeInformation.of(String.class);
    private final Set<GenericConverter.ConvertiblePair> convertiblePairs = new HashSet<GenericConverter.ConvertiblePair>();
    private final Associations associations;
    private final PersistentEntities entities;
    private final ObjectMapper objectMapper;
    private final RepositoryRestConfiguration configuration;
    private final ValueTypeSchemaPropertyCustomizerFactory customizerFactory;
    private final InternalMessageResolver resolver;

    public PersistentEntityToJsonSchemaConverter(PersistentEntities entities, Associations associations, MessageResolver resolver, ObjectMapper objectMapper, RepositoryRestConfiguration configuration, ValueTypeSchemaPropertyCustomizerFactory customizerFactory) {
        Assert.notNull((Object)entities, (String)"PersistentEntities must not be null");
        Assert.notNull((Object)associations, (String)"AssociationLinks must not be null");
        Assert.notNull((Object)resolver, (String)"MessageResolver must not be null");
        Assert.notNull((Object)objectMapper, (String)"ObjectMapper must not be null");
        Assert.notNull((Object)configuration, (String)"RepositoryRestConfiguration must not be null");
        Assert.notNull((Object)customizerFactory, (String)"ValueTypeSchemaPropertyCustomizerFactory must not be null");
        this.entities = entities;
        this.associations = associations;
        this.objectMapper = objectMapper;
        this.configuration = configuration;
        this.customizerFactory = customizerFactory;
        this.resolver = new DefaultMessageResolver(resolver, configuration);
        for (TypeInformation domainType : entities.getManagedTypes()) {
            this.convertiblePairs.add(new GenericConverter.ConvertiblePair(domainType.getType(), JsonSchema.class));
        }
    }

    public boolean matches(TypeDescriptor sourceType, TypeDescriptor targetType) {
        return Class.class.isAssignableFrom(sourceType.getType()) && JsonSchema.class.isAssignableFrom(targetType.getType());
    }

    public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
        return this.convertiblePairs;
    }

    public JsonSchema convert(Class<?> domainType) {
        return this.convert(domainType, STRING_TYPE, SCHEMA_TYPE);
    }

    public JsonSchema convert(@Nullable Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
        Assert.notNull((Object)source, (String)"Source must not be null");
        PersistentEntity persistentEntity = this.entities.getRequiredPersistentEntity((Class)source);
        ResourceMetadata metadata = this.associations.getMappings().getRequiredMetadataFor(persistentEntity.getType());
        JsonSchema.Definitions definitions = new JsonSchema.Definitions();
        List<JsonSchema.AbstractJsonSchemaProperty<?>> propertiesFor = this.getPropertiesFor(persistentEntity.getType(), metadata, definitions);
        String title = this.resolver.resolveWithDefault((MessageSourceResolvable)new ResolvableType(persistentEntity.getType()));
        return new JsonSchema(title, this.resolver.resolve((MessageSourceResolvable)metadata.getItemResourceDescription()), propertiesFor, definitions);
    }

    private List<JsonSchema.AbstractJsonSchemaProperty<?>> getPropertiesFor(Class<?> type, ResourceMetadata metadata, JsonSchema.Definitions definitions) {
        return this.entities.getPersistentEntity(type).map(entity -> {
            JacksonMetadata jackson = new JacksonMetadata(this.objectMapper, type);
            JsonSchemaPropertyRegistrar registrar = new JsonSchemaPropertyRegistrar(jackson);
            for (BeanPropertyDefinition definition : jackson) {
                AnnotatedMember primaryMember;
                PersistentProperty persistentProperty;
                Optional<PersistentProperty> prop = Optional.ofNullable(entity.getPersistentProperty(definition.getInternalName()));
                JacksonProperty jacksonProperty = new JacksonProperty(jackson, prop, definition);
                if (prop.isPresent() && ((persistentProperty = prop.get()).isIdProperty() && !this.configuration.isIdExposedFor(type) || persistentProperty.isVersionProperty() || !definition.couldSerialize()) || (primaryMember = definition.getPrimaryMember()) == null) continue;
                TypeInformation<?> propertyType = jacksonProperty.getPropertyType();
                TypeInformation actualPropertyType = propertyType.getActualType();
                Class rawPropertyType = propertyType.getType();
                JsonSchemaFormat format = this.configuration.getMetadataConfiguration().getSchemaFormatFor(rawPropertyType);
                ResourceDescription description = prop.map(it -> this.getDescriptionFor((PersistentProperty<?>)it, metadata)).orElseGet(() -> jackson.getFallbackDescription(metadata, definition));
                JsonSchema.JsonSchemaProperty property = jacksonProperty.getSchemaProperty(description, this.resolver);
                if (format != null) {
                    registrar.register(property.withFormat(format), actualPropertyType);
                    continue;
                }
                Pattern pattern = this.configuration.getMetadataConfiguration().getPatternFor(rawPropertyType);
                if (pattern != null) {
                    registrar.register(property.withPattern(pattern), actualPropertyType);
                    continue;
                }
                if (jackson.isValueType()) {
                    registrar.register(property.with(STRING_TYPE_INFORMATION), actualPropertyType);
                    continue;
                }
                Optionals.ifPresentOrElse(prop, it -> {
                    if (this.configuration.isLookupType(it.getActualType())) {
                        registrar.register(property.with(propertyType), actualPropertyType);
                    } else if (this.associations.isLinkableAssociation((PersistentProperty<?>)it)) {
                        registrar.register(property.asAssociation(), null);
                    } else if (it.isEntity()) {
                        if (!definitions.hasDefinitionFor(propertyType)) {
                            definitions.addDefinition(propertyType, new JsonSchema.Item(propertyType, this.getNestedPropertiesFor((PersistentProperty<?>)it, definitions)));
                        }
                        registrar.register(property.with(propertyType, JsonSchema.Definitions.getReference(propertyType)), actualPropertyType);
                    } else {
                        registrar.register(property.with(propertyType), actualPropertyType);
                    }
                }, () -> registrar.register(property, actualPropertyType));
            }
            return registrar.getProperties();
        }).orElse(Collections.emptyList());
    }

    private Collection<JsonSchema.AbstractJsonSchemaProperty<?>> getNestedPropertiesFor(PersistentProperty<?> property, JsonSchema.Definitions descriptors) {
        if (!property.isEntity()) {
            return Collections.emptyList();
        }
        return this.getPropertiesFor(property.getActualType(), this.associations.getMappings().getRequiredMetadataFor(property.getActualType()), descriptors);
    }

    private ResourceDescription getDescriptionFor(PersistentProperty<?> property, ResourceMetadata metadata) {
        ResourceMapping propertyMapping = metadata.getMappingFor(property);
        return propertyMapping.getDescription();
    }

    public static class ValueTypeSchemaPropertyCustomizerFactory {
        private final RepositoryInvokerFactory factory;

        public ValueTypeSchemaPropertyCustomizerFactory(RepositoryInvokerFactory factory) {
            Assert.notNull((Object)factory, (String)"RepositoryInvokerFactory must not be null");
            this.factory = factory;
        }

        public JsonSchemaPropertyCustomizer getCustomizerFor(Class<?> type) {
            return new JsonSchemaPropertyCustomizer(){

                @Override
                public JsonSchema.JsonSchemaProperty customize(JsonSchema.JsonSchemaProperty property, TypeInformation<?> type) {
                    ArrayList<String> result = new ArrayList<String>();
                    for (Object element : factory.getInvokerFor(type.getType()).invokeFindAll((Sort)null)) {
                        result.add(element.toString());
                    }
                    Collections.sort(result);
                    return new JsonSchema.EnumProperty(property.getName(), property.getTitle(), result, property.description, true);
                }
            };
        }
    }

    private static class DefaultMessageResolver
    implements InternalMessageResolver {
        private final MessageResolver resolver;
        private final RepositoryRestConfiguration configuration;

        public DefaultMessageResolver(MessageResolver resolver, RepositoryRestConfiguration configuration) {
            Assert.notNull((Object)resolver, (String)"MessageResolver must not be null");
            Assert.notNull((Object)configuration, (String)"RepositoryRestConfiguration must not be null");
            this.resolver = resolver;
            this.configuration = configuration;
        }

        @Override
        public @Nullable String resolve(@Nullable MessageSourceResolvable resolvable) {
            if (resolvable == null) {
                return null;
            }
            try {
                return this.resolver.resolve(resolvable);
            }
            catch (NoSuchMessageException o_O) {
                if (this.configuration.getMetadataConfiguration().omitUnresolvableDescriptionKeys()) {
                    return null;
                }
                throw o_O;
            }
        }
    }

    private static interface InternalMessageResolver {
        public String resolve(MessageSourceResolvable var1);

        default public String resolveWithDefault(MessageSourceResolvable resolvable) {
            return this.resolve(new DefaultingMessageSourceResolvable(resolvable));
        }
    }

    private static class ResolvableType
    extends DefaultMessageSourceResolvable {
        private static final long serialVersionUID = -7199875272753949857L;

        public ResolvableType(Class<?> type) {
            super(ResolvableType.getTitleCodes(type));
        }

        private static String[] getTitleCodes(Class<?> type) {
            Assert.notNull(type, (String)"Type must not be null");
            return new String[]{type.getName().concat("._title"), type.getSimpleName().concat("._title")};
        }
    }

    private class JsonSchemaPropertyRegistrar {
        private final JacksonMetadata metadata;
        private final List<JsonSchema.AbstractJsonSchemaProperty<?>> properties;

        public JsonSchemaPropertyRegistrar(JacksonMetadata metadata) {
            Assert.notNull((Object)metadata, (String)"Metadata must not be null");
            this.metadata = metadata;
            this.properties = new ArrayList();
        }

        public void register(JsonSchema.JsonSchemaProperty property, @Nullable TypeInformation<?> type) {
            if (type == null) {
                this.properties.add(property);
                return;
            }
            ValueSerializer<?> serializer = this.metadata.getTypeSerializer(type.getType());
            if (serializer instanceof JsonSchemaPropertyCustomizer) {
                this.properties.add(((JsonSchemaPropertyCustomizer)serializer).customize(property, type));
                return;
            }
            if (PersistentEntityToJsonSchemaConverter.this.configuration.isLookupType(type.getType())) {
                this.properties.add(PersistentEntityToJsonSchemaConverter.this.customizerFactory.getCustomizerFor(type.getType()).customize(property, type));
                return;
            }
            this.properties.add(property);
        }

        public List<JsonSchema.AbstractJsonSchemaProperty<?>> getProperties() {
            return this.properties;
        }
    }

    private static class JacksonProperty {
        private final JacksonMetadata metadata;
        private final Optional<? extends PersistentProperty<?>> property;
        private final BeanPropertyDefinition definition;

        public JacksonProperty(JacksonMetadata metadata, Optional<? extends PersistentProperty<?>> property, BeanPropertyDefinition definition) {
            Assert.notNull((Object)metadata, (String)"JacksonMetadata must not be null");
            Assert.notNull(property, (String)"PersistentProperty must not be null");
            Assert.notNull((Object)definition, (String)"BeanPropertyDefinition must not be null");
            this.metadata = metadata;
            this.property = property;
            this.definition = definition;
        }

        public TypeInformation<?> getPropertyType() {
            return this.property.map(it -> it.getTypeInformation()).orElseGet(() -> TypeInformation.of((Class)this.definition.getPrimaryMember().getRawType()));
        }

        public JsonSchema.JsonSchemaProperty getSchemaProperty(ResourceDescription description, InternalMessageResolver resolver) {
            JsonSchema.JsonSchemaProperty result = this.getSchemaProperty(this.definition, this.getPropertyType(), description, resolver);
            boolean isSyntheticProperty = this.property.isEmpty();
            boolean isNotWritable = this.property.map(it -> !it.isWritable()).orElse(false);
            boolean isJacksonReadOnly = this.property.map(it -> this.metadata.isReadOnly((PersistentProperty<?>)it)).orElse(false);
            if (isSyntheticProperty || isNotWritable || isJacksonReadOnly) {
                result = (JsonSchema.JsonSchemaProperty)result.withReadOnly();
            }
            return result;
        }

        private JsonSchema.JsonSchemaProperty getSchemaProperty(BeanPropertyDefinition definition, TypeInformation<?> type, ResourceDescription description, InternalMessageResolver resolver) {
            String name = definition.getName();
            String title = resolver.resolveWithDefault((MessageSourceResolvable)new ResolvableProperty(definition));
            String resolvedDescription = resolver.resolve((MessageSourceResolvable)description);
            boolean required = definition.isRequired();
            Class rawType = type.getType();
            if (!rawType.isEnum()) {
                return new JsonSchema.JsonSchemaProperty(name, title, resolvedDescription, required).with(type);
            }
            String message = resolver.resolve((MessageSourceResolvable)new DefaultMessageSourceResolvable(description.getMessage()));
            return new JsonSchema.EnumProperty(name, title, rawType, description.getDefaultMessage().equals(resolvedDescription) ? message : resolvedDescription, required);
        }
    }

    private static class DefaultingMessageSourceResolvable
    implements MessageSourceResolvable {
        private static Pattern SPLIT_CAMEL_CASE = Pattern.compile("(?<!(^|[A-Z]))(?=[A-Z])|(?<!^)(?=[A-Z][a-z])");
        private final MessageSourceResolvable delegate;

        public DefaultingMessageSourceResolvable(MessageSourceResolvable delegate) {
            this.delegate = delegate;
        }

        public Object[] getArguments() {
            return this.delegate.getArguments();
        }

        public String[] getCodes() {
            return this.delegate.getCodes();
        }

        public String getDefaultMessage() {
            String defaultMessage = this.delegate.getDefaultMessage();
            if (defaultMessage != null) {
                return defaultMessage;
            }
            String[] split = this.getCodes()[0].split("\\.");
            String tail = split[split.length - 1];
            tail = "_title".equals(tail) ? split[split.length - 2] : tail;
            return StringUtils.capitalize((String)StringUtils.collectionToDelimitedString(Arrays.asList(SPLIT_CAMEL_CASE.split(tail)), (String)" ").toLowerCase(Locale.US));
        }
    }

    private static class ResolvableProperty
    extends DefaultMessageSourceResolvable {
        private static final long serialVersionUID = -5603381674553244480L;

        public ResolvableProperty(BeanPropertyDefinition property) {
            super(ResolvableProperty.getCodes(property));
        }

        private static String[] getCodes(BeanPropertyDefinition property) {
            Assert.notNull((Object)property, (String)"BeanPropertyDefinition must not be null");
            Class owner = property.getPrimaryMember().getDeclaringClass();
            String propertyTitle = property.getInternalName().concat("._title");
            String localName = owner.getSimpleName().concat(".").concat(propertyTitle);
            String fullName = owner.getName().concat(".").concat(propertyTitle);
            return new String[]{fullName, localName, propertyTitle};
        }
    }
}

