/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc.json;

import java.util.Iterator;
import java.util.List;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.rest.core.annotation.Description;
import org.springframework.data.rest.core.mapping.AnnotationBasedResourceDescription;
import org.springframework.data.rest.core.mapping.ResourceDescription;
import org.springframework.data.rest.core.mapping.ResourceMetadata;
import org.springframework.data.rest.core.mapping.TypedResourceDescription;
import org.springframework.hateoas.LinkRelation;
import org.springframework.util.Assert;
import tools.jackson.databind.BeanDescription;
import tools.jackson.databind.DeserializationConfig;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.ObjectMapper;
import tools.jackson.databind.SerializationConfig;
import tools.jackson.databind.ValueSerializer;
import tools.jackson.databind.introspect.AnnotatedClass;
import tools.jackson.databind.introspect.AnnotatedMember;
import tools.jackson.databind.introspect.BeanPropertyDefinition;

public class Jackson3Metadata
implements Iterable<BeanPropertyDefinition> {
    private final ObjectMapper mapper;
    private final List<BeanPropertyDefinition> definitions;
    private final List<BeanPropertyDefinition> deserializationDefinitions;
    private final boolean isValue;

    public Jackson3Metadata(ObjectMapper mapper, Class<?> type) {
        Assert.notNull((Object)mapper, (String)"ObjectMapper must not be null");
        Assert.notNull(type, (String)"Type must not be null");
        this.mapper = mapper;
        SerializationConfig serializationConfig = mapper.serializationConfig();
        JavaType javaType = serializationConfig.constructType(type);
        AnnotatedClass annotatedClass = serializationConfig.classIntrospectorInstance().introspectClassAnnotations(javaType);
        BeanDescription description = serializationConfig.classIntrospectorInstance().introspectForSerialization(javaType, annotatedClass);
        this.definitions = description.findProperties();
        this.isValue = description.findJsonValueAccessor() != null;
        DeserializationConfig deserializationConfig = mapper.deserializationConfig();
        JavaType deserializationType = deserializationConfig.constructType(type);
        this.deserializationDefinitions = deserializationConfig.classIntrospectorInstance().introspectForDeserialization(deserializationType, annotatedClass).findProperties();
    }

    public BeanPropertyDefinition getDefinitionFor(PersistentProperty<?> property) {
        Assert.notNull(property, (String)"PersistentProperty must not be null");
        return Jackson3Metadata.getDefinitionFor(property, this.definitions);
    }

    public ResourceDescription getFallbackDescription(ResourceMetadata ownerMetadata, BeanPropertyDefinition definition) {
        Assert.notNull((Object)ownerMetadata, (String)"Owner's resource metadata must not be null");
        Assert.notNull((Object)definition, (String)"BeanPropertyDefinition must not be null");
        AnnotatedMember member = definition.getPrimaryMember();
        Description description = (Description)member.getAnnotation(Description.class);
        ResourceDescription fallback = TypedResourceDescription.defaultFor((LinkRelation)ownerMetadata.getItemResourceRel(), (String)definition.getInternalName(), (Class)definition.getPrimaryMember().getRawType());
        return description == null ? fallback : new AnnotationBasedResourceDescription(description, fallback);
    }

    public boolean isExported(PersistentProperty<?> property) {
        Assert.notNull(property, (String)"PersistentProperty must not be null");
        return this.getDefinitionFor(property) != null;
    }

    public boolean isValueType() {
        return this.isValue;
    }

    public boolean isReadOnly(PersistentProperty<?> property) {
        BeanPropertyDefinition definition = Jackson3Metadata.getDefinitionFor(property, this.deserializationDefinitions);
        return definition == null ? false : !definition.couldDeserialize();
    }

    public ValueSerializer<?> getTypeSerializer(Class<?> type) {
        Assert.notNull(type, (String)"Type must not be null");
        return this.mapper._serializationContext().findValueSerializer(type);
    }

    @Override
    public Iterator<BeanPropertyDefinition> iterator() {
        return this.definitions.iterator();
    }

    private static BeanPropertyDefinition getDefinitionFor(PersistentProperty<?> property, Iterable<BeanPropertyDefinition> definitions) {
        for (BeanPropertyDefinition definition : definitions) {
            if (!definition.getInternalName().equals(property.getName())) continue;
            return definition;
        }
        return null;
    }
}

