/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationContext;
import org.springframework.context.EmbeddedValueResolverAware;
import org.springframework.context.MessageSource;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.Ordered;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.core.convert.support.ConfigurableConversionService;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.SpringFactoriesLoader;
import org.springframework.data.auditing.AuditableBeanWrapperFactory;
import org.springframework.data.auditing.MappingAuditableBeanWrapperFactory;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.geo.GeoJacksonModule;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mapping.context.PersistentEntities;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.projection.SpelAwareProxyProjectionFactory;
import org.springframework.data.querydsl.QuerydslUtils;
import org.springframework.data.querydsl.binding.QuerydslBindingsFactory;
import org.springframework.data.querydsl.binding.QuerydslPredicateBuilder;
import org.springframework.data.repository.support.DefaultRepositoryInvokerFactory;
import org.springframework.data.repository.support.Repositories;
import org.springframework.data.repository.support.RepositoryInvokerFactory;
import org.springframework.data.rest.core.StringToLdapNameConverter;
import org.springframework.data.rest.core.UriToEntityConverter;
import org.springframework.data.rest.core.config.MetadataConfiguration;
import org.springframework.data.rest.core.config.Projection;
import org.springframework.data.rest.core.config.ProjectionDefinitionConfiguration;
import org.springframework.data.rest.core.config.RepositoryRestConfiguration;
import org.springframework.data.rest.core.event.AnnotatedEventHandlerInvoker;
import org.springframework.data.rest.core.event.ValidatingRepositoryEventListener;
import org.springframework.data.rest.core.mapping.RepositoryResourceMappings;
import org.springframework.data.rest.core.mapping.ResourceMappings;
import org.springframework.data.rest.core.projection.ProjectionDefinitions;
import org.springframework.data.rest.core.support.DefaultSelfLinkProvider;
import org.springframework.data.rest.core.support.EntityLookup;
import org.springframework.data.rest.core.support.RepositoryRelProvider;
import org.springframework.data.rest.core.support.SelfLinkProvider;
import org.springframework.data.rest.core.support.UnwrappingRepositoryInvokerFactory;
import org.springframework.data.rest.webmvc.BasePathAwareHandlerMapping;
import org.springframework.data.rest.webmvc.BaseUri;
import org.springframework.data.rest.webmvc.EmbeddedResourcesAssembler;
import org.springframework.data.rest.webmvc.HttpHeadersPreparer;
import org.springframework.data.rest.webmvc.ProfileResourceProcessor;
import org.springframework.data.rest.webmvc.RepositoryRestExceptionHandler;
import org.springframework.data.rest.webmvc.RepositoryRestHandlerAdapter;
import org.springframework.data.rest.webmvc.RepositoryRestHandlerMapping;
import org.springframework.data.rest.webmvc.RestMediaTypes;
import org.springframework.data.rest.webmvc.alps.AlpsJackson3JsonHttpMessageConverter;
import org.springframework.data.rest.webmvc.alps.RootResourceInformationToAlpsDescriptorConverter;
import org.springframework.data.rest.webmvc.config.ArgumentResolverPagingAndSortingTemplateVariables;
import org.springframework.data.rest.webmvc.config.CorsConfigurationAware;
import org.springframework.data.rest.webmvc.config.DelegatingHandlerMapping;
import org.springframework.data.rest.webmvc.config.HalFormsAdaptingResponseBodyAdvice;
import org.springframework.data.rest.webmvc.config.PersistentEntityResourceAssemblerArgumentResolver;
import org.springframework.data.rest.webmvc.config.PersistentEntityResourceHandlerMethodArgumentResolver;
import org.springframework.data.rest.webmvc.config.ProjectionDefinitionRegistar;
import org.springframework.data.rest.webmvc.config.QuerydslAwareRootResourceInformationHandlerMethodArgumentResolver;
import org.springframework.data.rest.webmvc.config.RepositoryCorsRegistry;
import org.springframework.data.rest.webmvc.config.RepositoryRestConfigurer;
import org.springframework.data.rest.webmvc.config.RepositoryRestConfigurerDelegate;
import org.springframework.data.rest.webmvc.config.RepresentationModelAssemblersArgumentResolver;
import org.springframework.data.rest.webmvc.config.ResourceMetadataHandlerMethodArgumentResolver;
import org.springframework.data.rest.webmvc.config.RestControllerImportSelector;
import org.springframework.data.rest.webmvc.config.RootResourceInformationHandlerMethodArgumentResolver;
import org.springframework.data.rest.webmvc.config.StaticResourceProvider;
import org.springframework.data.rest.webmvc.config.StringToAggregateReferenceConverter;
import org.springframework.data.rest.webmvc.config.WebMvcRepositoryRestConfiguration;
import org.springframework.data.rest.webmvc.convert.UriListHttpMessageConverter;
import org.springframework.data.rest.webmvc.json.AggregateReferenceResolvingModule;
import org.springframework.data.rest.webmvc.json.DomainObjectReader;
import org.springframework.data.rest.webmvc.json.EnumTranslator;
import org.springframework.data.rest.webmvc.json.Jackson3MappingAwareSortTranslator;
import org.springframework.data.rest.webmvc.json.Jackson3Serializers;
import org.springframework.data.rest.webmvc.json.MappingAwareDefaultedPageableArgumentResolver;
import org.springframework.data.rest.webmvc.json.MappingAwarePageableArgumentResolver;
import org.springframework.data.rest.webmvc.json.MappingAwareSortArgumentResolver;
import org.springframework.data.rest.webmvc.json.PersistentEntitiesBindContextFactory;
import org.springframework.data.rest.webmvc.json.PersistentEntityJackson3Module;
import org.springframework.data.rest.webmvc.json.PersistentEntityToJsonSchemaConverter;
import org.springframework.data.rest.webmvc.mapping.Associations;
import org.springframework.data.rest.webmvc.mapping.DefaultLinkCollector;
import org.springframework.data.rest.webmvc.mapping.LinkCollector;
import org.springframework.data.rest.webmvc.spi.BackendIdConverter;
import org.springframework.data.rest.webmvc.support.BackendIdHandlerMethodArgumentResolver;
import org.springframework.data.rest.webmvc.support.DefaultExcerptProjector;
import org.springframework.data.rest.webmvc.support.DomainClassResolver;
import org.springframework.data.rest.webmvc.support.ETagArgumentResolver;
import org.springframework.data.rest.webmvc.support.ExcerptProjector;
import org.springframework.data.rest.webmvc.support.HttpMethodHandlerMethodArgumentResolver;
import org.springframework.data.rest.webmvc.support.JpaHelper;
import org.springframework.data.rest.webmvc.support.PagingAndSortingTemplateVariables;
import org.springframework.data.rest.webmvc.support.RepositoryEntityLinks;
import org.springframework.data.util.AnnotatedTypeScanner;
import org.springframework.data.util.Lazy;
import org.springframework.data.util.StreamUtils;
import org.springframework.data.web.HateoasPageableHandlerMethodArgumentResolver;
import org.springframework.data.web.HateoasSortHandlerMethodArgumentResolver;
import org.springframework.data.web.PageableArgumentResolver;
import org.springframework.data.web.PageableHandlerMethodArgumentResolver;
import org.springframework.data.web.PagedResourcesAssembler;
import org.springframework.data.web.SlicedResourcesAssembler;
import org.springframework.data.web.SortArgumentResolver;
import org.springframework.data.web.config.EnableSpringDataWebSupport;
import org.springframework.data.web.config.HateoasAwareSpringDataWebConfiguration;
import org.springframework.data.web.config.SpringDataJackson3Configuration;
import org.springframework.format.FormatterRegistry;
import org.springframework.format.support.DefaultFormattingConversionService;
import org.springframework.hateoas.MediaTypes;
import org.springframework.hateoas.RepresentationModel;
import org.springframework.hateoas.config.EnableHypermediaSupport;
import org.springframework.hateoas.mediatype.MessageResolver;
import org.springframework.hateoas.mediatype.hal.CurieProvider;
import org.springframework.hateoas.mediatype.hal.DefaultCurieProvider;
import org.springframework.hateoas.mediatype.hal.HalConfiguration;
import org.springframework.hateoas.mediatype.hal.HalJacksonModule;
import org.springframework.hateoas.mediatype.hal.forms.HalFormsConfiguration;
import org.springframework.hateoas.mediatype.hal.forms.HalFormsHttpMessageConverter;
import org.springframework.hateoas.mediatype.hal.forms.HalFormsJacksonModule;
import org.springframework.hateoas.server.EntityLinks;
import org.springframework.hateoas.server.LinkRelationProvider;
import org.springframework.hateoas.server.core.EvoInflectorLinkRelationProvider;
import org.springframework.hateoas.server.mvc.RepresentationModelProcessorInvoker;
import org.springframework.hateoas.server.mvc.TypeConstrainedJacksonJsonHttpMessageConverter;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.json.JacksonJsonHttpMessageConverter;
import org.springframework.plugin.core.PluginRegistry;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringValueResolver;
import org.springframework.validation.Validator;
import org.springframework.web.bind.support.ConfigurableWebBindingInitializer;
import org.springframework.web.bind.support.WebBindingInitializer;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.servlet.HandlerExceptionResolver;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.mvc.method.annotation.ExceptionHandlerExceptionResolver;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerAdapter;
import org.springframework.web.util.pattern.PathPatternParser;
import tools.jackson.databind.DeserializationFeature;
import tools.jackson.databind.JacksonModule;
import tools.jackson.databind.ObjectMapper;
import tools.jackson.databind.SerializationFeature;
import tools.jackson.databind.cfg.HandlerInstantiator;
import tools.jackson.databind.cfg.MapperBuilder;
import tools.jackson.databind.json.JsonMapper;

@Configuration(proxyBeanMethods=false)
@EnableHypermediaSupport(type={EnableHypermediaSupport.HypermediaType.HAL, EnableHypermediaSupport.HypermediaType.HAL_FORMS})
@Import(value={RestControllerImportSelector.class, SpringDataJackson3Configuration.class, EnableSpringDataWebSupport.QuerydslActivator.class})
public class RepositoryRestMvcConfiguration
extends HateoasAwareSpringDataWebConfiguration
implements BeanClassLoaderAware,
EmbeddedValueResolverAware {
    private static final boolean IS_JPA_AVAILABLE = ClassUtils.isPresent((String)"jakarta.persistence.EntityManager", (ClassLoader)RepositoryRestMvcConfiguration.class.getClassLoader());
    private final ApplicationContext applicationContext;
    private final ConversionService defaultConversionService;
    private final ObjectProvider<LinkRelationProvider> relProvider;
    private final ObjectProvider<CurieProvider> curieProvider;
    private final ObjectProvider<HalConfiguration> halConfiguration;
    private final ObjectProvider<JsonMapper> objectMapper;
    private final ObjectProvider<JsonMapper.Builder> objectMapperBuilder;
    private final ObjectProvider<RepresentationModelProcessorInvoker> invoker;
    private final ObjectProvider<MessageResolver> resolver;
    private final ObjectProvider<GeoJacksonModule> geoModule;
    private final ObjectProvider<PathPatternParser> parser;
    private final Lazy<JsonMapper> mapper;
    private final Lazy<? extends List<EntityLookup<?>>> lookups;
    private final Lazy<? extends List<HttpMessageConverter<?>>> defaultMessageConverters;
    private final Lazy<RepositoryRestConfigurerDelegate> configurerDelegate;
    private final Lazy<SelfLinkProvider> selfLinkProvider;
    private final Lazy<PersistentEntityResourceHandlerMethodArgumentResolver> persistentEntityArgumentResolver;
    private final Lazy<RootResourceInformationHandlerMethodArgumentResolver> repoRequestArgumentResolver;
    private final Lazy<BaseUri> baseUri;
    private final Lazy<RepositoryResourceMappings> resourceMappings;
    private final Lazy<Repositories> repositories;
    private final Lazy<ResourceMetadataHandlerMethodArgumentResolver> resourceMetadataHandlerMethodArgumentResolver;
    private final Lazy<ExcerptProjector> excerptProjector;
    private final Lazy<PersistentEntities> persistentEntities;
    private final Lazy<BackendIdHandlerMethodArgumentResolver> backendIdHandlerMethodArgumentResolver;
    private final Lazy<Associations> associationLinks;
    private final Lazy<EnumTranslator> enumTranslator;
    private final Lazy<ETagArgumentResolver> eTagArgumentResolver;
    private final Lazy<RepositoryInvokerFactory> repositoryInvokerFactory;
    private final Lazy<RepositoryRestConfiguration> repositoryRestConfiguration;
    private final Lazy<HateoasPageableHandlerMethodArgumentResolver> pageableResolver;
    private final Lazy<HateoasSortHandlerMethodArgumentResolver> sortResolver;
    private final Lazy<PersistentEntityResourceAssemblerArgumentResolver> persistentEntityResourceAssemblerArgumentResolver;
    private @Nullable ClassLoader beanClassLoader;
    private @Nullable StringValueResolver stringValueResolver;

    public RepositoryRestMvcConfiguration(ApplicationContext context, @Qualifier(value="mvcConversionService") ObjectFactory<ConversionService> conversionService, ObjectProvider<LinkRelationProvider> relProvider, ObjectProvider<CurieProvider> curieProvider, ObjectProvider<HalConfiguration> halConfiguration, ObjectProvider<JsonMapper> objectMapper, ObjectProvider<JsonMapper.Builder> objectMapperBuilder, ObjectProvider<RepresentationModelProcessorInvoker> invoker, ObjectProvider<MessageResolver> resolver, ObjectProvider<GeoJacksonModule> geoModule, ObjectProvider<PathPatternParser> parser) {
        super(context, conversionService);
        this.applicationContext = context;
        this.relProvider = relProvider;
        this.curieProvider = curieProvider;
        this.halConfiguration = halConfiguration;
        this.objectMapper = objectMapper;
        this.objectMapperBuilder = objectMapperBuilder;
        this.invoker = invoker;
        this.resolver = resolver;
        this.geoModule = geoModule;
        this.parser = parser;
        this.defaultConversionService = new DefaultFormattingConversionService();
        this.mapper = Lazy.of(() -> {
            JsonMapper.Builder mapper = this.basicObjectMapperBuilder();
            LinkCollector linkCollector = (LinkCollector)context.getBean(LinkCollector.class);
            mapper.addModule(this.persistentEntityJackson3Module(linkCollector));
            return mapper.build();
        });
        this.selfLinkProvider = Lazy.of(() -> (SelfLinkProvider)context.getBean(SelfLinkProvider.class));
        this.persistentEntityArgumentResolver = Lazy.of(() -> (PersistentEntityResourceHandlerMethodArgumentResolver)context.getBean(PersistentEntityResourceHandlerMethodArgumentResolver.class));
        this.repoRequestArgumentResolver = Lazy.of(() -> (RootResourceInformationHandlerMethodArgumentResolver)context.getBean(RootResourceInformationHandlerMethodArgumentResolver.class));
        this.baseUri = Lazy.of(() -> (BaseUri)context.getBean(BaseUri.class));
        this.resourceMappings = Lazy.of(() -> (RepositoryResourceMappings)context.getBean(RepositoryResourceMappings.class));
        this.repositories = Lazy.of(() -> (Repositories)context.getBean(Repositories.class));
        this.resourceMetadataHandlerMethodArgumentResolver = Lazy.of(() -> (ResourceMetadataHandlerMethodArgumentResolver)context.getBean(ResourceMetadataHandlerMethodArgumentResolver.class));
        this.excerptProjector = Lazy.of(() -> (ExcerptProjector)context.getBean(ExcerptProjector.class));
        this.persistentEntities = Lazy.of(() -> (PersistentEntities)context.getBean(PersistentEntities.class));
        this.backendIdHandlerMethodArgumentResolver = Lazy.of(() -> (BackendIdHandlerMethodArgumentResolver)context.getBean(BackendIdHandlerMethodArgumentResolver.class));
        this.associationLinks = Lazy.of(() -> (Associations)context.getBean(Associations.class));
        this.enumTranslator = Lazy.of(() -> (EnumTranslator)context.getBean(EnumTranslator.class));
        this.eTagArgumentResolver = Lazy.of(() -> (ETagArgumentResolver)context.getBean(ETagArgumentResolver.class));
        this.repositoryInvokerFactory = Lazy.of(() -> new UnwrappingRepositoryInvokerFactory((RepositoryInvokerFactory)new DefaultRepositoryInvokerFactory((Repositories)this.repositories.get(), this.defaultConversionService), this.getEntityLookups()));
        this.configurerDelegate = Lazy.of(() -> new RepositoryRestConfigurerDelegate(context.getBeanProvider(RepositoryRestConfigurer.class).orderedStream().collect(Collectors.toList())));
        this.repositoryRestConfiguration = Lazy.of(() -> (RepositoryRestConfiguration)context.getBean(RepositoryRestConfiguration.class));
        this.pageableResolver = Lazy.of(() -> (HateoasPageableHandlerMethodArgumentResolver)context.getBean(HateoasPageableHandlerMethodArgumentResolver.class));
        this.sortResolver = Lazy.of(() -> (HateoasSortHandlerMethodArgumentResolver)context.getBean(HateoasSortHandlerMethodArgumentResolver.class));
        this.persistentEntityResourceAssemblerArgumentResolver = Lazy.of(() -> (PersistentEntityResourceAssemblerArgumentResolver)context.getBean(PersistentEntityResourceAssemblerArgumentResolver.class));
        this.lookups = RepositoryRestMvcConfiguration.beansOfType(context, EntityLookup.class);
        this.defaultMessageConverters = RepositoryRestMvcConfiguration.beansOfType(context, HttpMessageConverter.class);
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.beanClassLoader = classLoader;
    }

    public void setEmbeddedValueResolver(StringValueResolver resolver) {
        this.stringValueResolver = resolver;
    }

    @Bean
    public Repositories repositories() {
        return new Repositories((ListableBeanFactory)this.applicationContext);
    }

    @Bean
    public RepositoryRelProvider repositoryRelProvider(ObjectFactory<ResourceMappings> resourceMappings) {
        return new RepositoryRelProvider(resourceMappings);
    }

    @Bean
    public PersistentEntities persistentEntities() {
        return new PersistentEntities(() -> BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)this.applicationContext, MappingContext.class).values().iterator());
    }

    @Bean
    @Qualifier
    public DefaultFormattingConversionService defaultConversionService(PersistentEntities persistentEntities, RepositoryInvokerFactory repositoryInvokerFactory) {
        DefaultFormattingConversionService conversionService = (DefaultFormattingConversionService)this.defaultConversionService;
        Supplier<ConversionService> supplier = () -> conversionService;
        conversionService.addConverter((GenericConverter)new UriToEntityConverter(persistentEntities, repositoryInvokerFactory, supplier));
        conversionService.addConverter((GenericConverter)new StringToAggregateReferenceConverter(supplier));
        conversionService.addConverter((Converter)StringToLdapNameConverter.INSTANCE);
        this.addFormatters((FormatterRegistry)conversionService);
        ((RepositoryRestConfigurerDelegate)this.configurerDelegate.get()).configureConversionService((ConfigurableConversionService)conversionService);
        return conversionService;
    }

    @Bean
    public ValidatingRepositoryEventListener validatingRepositoryEventListener(ObjectFactory<PersistentEntities> entities) {
        ValidatingRepositoryEventListener listener = new ValidatingRepositoryEventListener(entities);
        ((RepositoryRestConfigurerDelegate)this.configurerDelegate.get()).configureValidatingRepositoryEventListener(listener);
        return listener;
    }

    @Bean
    public @Nullable JpaHelper jpaHelper() {
        if (IS_JPA_AVAILABLE) {
            return new JpaHelper();
        }
        return null;
    }

    @Bean
    public <T extends RepositoryRestConfiguration> T repositoryRestConfiguration() {
        ProjectionDefinitionConfiguration configuration = new ProjectionDefinitionConfiguration();
        for (Class<?> projection : this.getProjections((Repositories)this.repositories.get())) {
            configuration.addProjection(projection);
        }
        RepositoryCorsRegistry registry = new RepositoryCorsRegistry();
        WebMvcRepositoryRestConfiguration config = new WebMvcRepositoryRestConfiguration(configuration, new MetadataConfiguration(), new EnumTranslator(MessageResolver.DEFAULTS_ONLY), registry);
        ((RepositoryRestConfigurerDelegate)this.configurerDelegate.get()).configureRepositoryRestConfiguration(config, registry);
        return (T)config;
    }

    @Bean
    public static ProjectionDefinitionRegistar projectionDefinitionRegistrar(ObjectFactory<RepositoryRestConfiguration> config) {
        return new ProjectionDefinitionRegistar(config);
    }

    @Bean
    public MetadataConfiguration metadataConfiguration() {
        return new MetadataConfiguration();
    }

    @Bean
    public BaseUri baseUri(RepositoryRestConfiguration repositoryRestConfiguration) {
        return new BaseUri(repositoryRestConfiguration.getBasePath());
    }

    @Bean
    public static AnnotatedEventHandlerInvoker annotatedEventHandlerInvoker() {
        return new AnnotatedEventHandlerInvoker();
    }

    @Bean
    public RootResourceInformationHandlerMethodArgumentResolver repoRequestArgumentResolver(Repositories repositories, ResourceMetadataHandlerMethodArgumentResolver resourceMetadataHandlerMethodArgumentResolver, @Qualifier(value="repositoryInvokerFactory") RepositoryInvokerFactory repositoryInvokerFactory) {
        if (QuerydslUtils.QUERY_DSL_PRESENT) {
            QuerydslBindingsFactory factory = (QuerydslBindingsFactory)this.applicationContext.getBean(QuerydslBindingsFactory.class);
            QuerydslPredicateBuilder predicateBuilder = new QuerydslPredicateBuilder(this.defaultConversionService, factory.getEntityPathResolver());
            return new QuerydslAwareRootResourceInformationHandlerMethodArgumentResolver(repositories, repositoryInvokerFactory, resourceMetadataHandlerMethodArgumentResolver, predicateBuilder, factory);
        }
        return new RootResourceInformationHandlerMethodArgumentResolver(repositories, repositoryInvokerFactory, resourceMetadataHandlerMethodArgumentResolver);
    }

    @Bean
    public ResourceMetadataHandlerMethodArgumentResolver resourceMetadataHandlerMethodArgumentResolver(Repositories repositories, RepositoryResourceMappings resourceMappings, BaseUri baseUri) {
        return new ResourceMetadataHandlerMethodArgumentResolver(repositories, (ResourceMappings)resourceMappings, baseUri);
    }

    @Bean
    public BackendIdHandlerMethodArgumentResolver backendIdHandlerMethodArgumentResolver(PluginRegistry<BackendIdConverter, Class<?>> backendIdConverterRegistry, ResourceMetadataHandlerMethodArgumentResolver resourceMetadataHandlerMethodArgumentResolver, BaseUri baseUri) {
        return new BackendIdHandlerMethodArgumentResolver(backendIdConverterRegistry, resourceMetadataHandlerMethodArgumentResolver, baseUri);
    }

    @Bean
    public ETagArgumentResolver eTagArgumentResolver() {
        return new ETagArgumentResolver();
    }

    @Bean
    public RepositoryEntityLinks entityLinks(ObjectFactory<HateoasPageableHandlerMethodArgumentResolver> pageableResolver, Repositories repositories, RepositoryResourceMappings resourceMappings, PluginRegistry<BackendIdConverter, Class<?>> backendIdConverterRegistry, RepositoryRestConfiguration repositoryRestConfiguration, ObjectFactory<HateoasSortHandlerMethodArgumentResolver> sortResolver) {
        Lazy templateVariables = Lazy.of(() -> new ArgumentResolverPagingAndSortingTemplateVariables((HateoasPageableHandlerMethodArgumentResolver)pageableResolver.getObject(), (HateoasSortHandlerMethodArgumentResolver)sortResolver.getObject()));
        return new RepositoryEntityLinks(repositories, (ResourceMappings)resourceMappings, repositoryRestConfiguration, (Lazy<PagingAndSortingTemplateVariables>)templateVariables, backendIdConverterRegistry);
    }

    @Bean
    public PersistentEntityResourceHandlerMethodArgumentResolver persistentEntityArgumentResolver(@Qualifier(value="defaultMessageConverters") List<HttpMessageConverter<?>> defaultMessageConverters, RootResourceInformationHandlerMethodArgumentResolver repoRequestArgumentResolver, Associations associationLinks, BackendIdHandlerMethodArgumentResolver backendIdHandlerMethodArgumentResolver, PersistentEntities entities) {
        PluginRegistry lookups = PluginRegistry.of(this.getEntityLookups());
        DomainObjectReader reader = new DomainObjectReader(entities, associationLinks);
        PersistentEntitiesBindContextFactory factory = new PersistentEntitiesBindContextFactory(entities, this.defaultConversionService);
        return new PersistentEntityResourceHandlerMethodArgumentResolver(defaultMessageConverters, repoRequestArgumentResolver, backendIdHandlerMethodArgumentResolver, reader, lookups, factory);
    }

    @Bean
    public PersistentEntityToJsonSchemaConverter jsonSchemaConverter(PersistentEntities persistentEntities, Associations associationLinks, @Qualifier(value="repositoryInvokerFactory") RepositoryInvokerFactory repositoryInvokerFactory, RepositoryRestConfiguration repositoryRestConfiguration) {
        return new PersistentEntityToJsonSchemaConverter(persistentEntities, associationLinks, (MessageResolver)this.resolver.getObject(), (ObjectMapper)this.objectMapper(), repositoryRestConfiguration, new PersistentEntityToJsonSchemaConverter.ValueTypeSchemaPropertyCustomizerFactory(repositoryInvokerFactory));
    }

    public JsonMapper objectMapper() {
        return (JsonMapper)this.mapper.get();
    }

    @Bean
    public TypeConstrainedJacksonJsonHttpMessageConverter jacksonHttpMessageConverter(RepositoryRestConfiguration repositoryRestConfiguration) {
        ArrayList<MediaType> mediaTypes = new ArrayList<MediaType>();
        if (!repositoryRestConfiguration.useHalAsDefaultJsonMediaType()) {
            mediaTypes.add(MediaType.APPLICATION_JSON);
        }
        int order = repositoryRestConfiguration.useHalAsDefaultJsonMediaType() ? 0x7FFFFFFE : 0x7FFFFFF5;
        mediaTypes.addAll(Arrays.asList(RestMediaTypes.SCHEMA_JSON, RestMediaTypes.JSON_PATCH_JSON, RestMediaTypes.MERGE_PATCH_JSON, RestMediaTypes.SPRING_DATA_VERBOSE_JSON, RestMediaTypes.SPRING_DATA_COMPACT_JSON));
        return new ResourceSupportHttpMessageConverter(mediaTypes, this.objectMapper(), order);
    }

    @Bean
    public TypeConstrainedJacksonJsonHttpMessageConverter halJacksonHttpMessageConverter(LinkCollector linkCollector, RepositoryRestConfiguration repositoryRestConfiguration) {
        ArrayList<MediaType> mediaTypes = new ArrayList<MediaType>();
        mediaTypes.add(MediaTypes.VND_HAL_JSON);
        mediaTypes.add(MediaTypes.HAL_JSON);
        if (repositoryRestConfiguration.useHalAsDefaultJsonMediaType()) {
            mediaTypes.add(MediaType.APPLICATION_JSON);
        }
        int order = repositoryRestConfiguration.useHalAsDefaultJsonMediaType() ? 0x7FFFFFF5 : 0x7FFFFFFE;
        return new ResourceSupportHttpMessageConverter(mediaTypes, this.halObjectMapper(linkCollector), order);
    }

    @Bean
    TypeConstrainedJacksonJsonHttpMessageConverter halFormsJacksonHttpMessageConverter(LinkCollector linkCollector) {
        LinkRelationProvider defaultedRelProvider = (LinkRelationProvider)this.relProvider.getIfUnique(EvoInflectorLinkRelationProvider::new);
        HalFormsConfiguration configuration = new HalFormsConfiguration((HalConfiguration)this.halConfiguration.getIfUnique(() -> new HalConfiguration()));
        CurieProvider curieProvider = (CurieProvider)this.curieProvider.getIfUnique(() -> new DefaultCurieProvider(Collections.emptyMap()));
        JsonMapper.Builder builder = this.basicObjectMapperBuilder();
        builder.addModule(this.persistentEntityJackson3Module(linkCollector));
        builder.addModule((JacksonModule)new HalFormsJacksonModule());
        builder.handlerInstantiator((HandlerInstantiator)new HalJacksonModule.HalHandlerInstantiator(defaultedRelProvider, curieProvider, (MessageResolver)this.resolver.getObject(), configuration.getHalConfiguration(), this.applicationContext.getAutowireCapableBeanFactory()));
        return new HalFormsHttpMessageConverter((BeanFactory)this.applicationContext, builder.build());
    }

    public JsonMapper halObjectMapper(LinkCollector linkCollector) {
        LinkRelationProvider defaultedRelProvider = (LinkRelationProvider)this.relProvider.getIfUnique(EvoInflectorLinkRelationProvider::new);
        HalConfiguration halConfiguration = (HalConfiguration)this.halConfiguration.getIfUnique(HalConfiguration::new);
        CurieProvider curieProvider = (CurieProvider)this.curieProvider.getIfUnique(() -> new DefaultCurieProvider(Collections.emptyMap()));
        HalJacksonModule.HalHandlerInstantiator instantiator = new HalJacksonModule.HalHandlerInstantiator(defaultedRelProvider, curieProvider, (MessageResolver)this.resolver.getObject(), halConfiguration, this.applicationContext.getAutowireCapableBeanFactory());
        return ((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)this.basicObjectMapperBuilder().addModule(this.persistentEntityJackson3Module(linkCollector))).addModule((JacksonModule)new HalJacksonModule())).handlerInstantiator((HandlerInstantiator)instantiator)).build();
    }

    @Bean
    public UriListHttpMessageConverter uriListHttpMessageConverter() {
        return new UriListHttpMessageConverter();
    }

    @Bean
    public RequestMappingHandlerAdapter repositoryExporterHandlerAdapter(@Qualifier(value="mvcValidator") ObjectProvider<Validator> validator, @Qualifier(value="defaultMessageConverters") List<HttpMessageConverter<?>> defaultMessageConverters, AlpsJackson3JsonHttpMessageConverter alpsJsonHttpMessageConverter, SelfLinkProvider selfLinkProvider, PersistentEntityResourceHandlerMethodArgumentResolver persistentEntityArgumentResolver, PersistentEntityResourceAssemblerArgumentResolver persistentEntityResourceAssemblerArgumentResolver, RootResourceInformationHandlerMethodArgumentResolver repoRequestArgumentResolver, RepositoryRestConfiguration repositoryRestConfiguration) {
        ConfigurableWebBindingInitializer initializer = new ConfigurableWebBindingInitializer();
        initializer.setConversionService(this.defaultConversionService);
        initializer.setValidator((Validator)validator.getIfUnique());
        RepositoryRestHandlerAdapter handlerAdapter = new RepositoryRestHandlerAdapter(this.defaultMethodArgumentResolvers(selfLinkProvider, persistentEntityArgumentResolver, persistentEntityResourceAssemblerArgumentResolver, repoRequestArgumentResolver));
        handlerAdapter.setWebBindingInitializer((WebBindingInitializer)initializer);
        handlerAdapter.setMessageConverters(defaultMessageConverters);
        ArrayList advices = new ArrayList();
        advices.add(new HalFormsAdaptingResponseBodyAdvice());
        if (repositoryRestConfiguration.getMetadataConfiguration().alpsEnabled()) {
            advices.addAll(Arrays.asList(alpsJsonHttpMessageConverter));
        }
        handlerAdapter.setResponseBodyAdvice(advices);
        return handlerAdapter;
    }

    @Bean
    public DelegatingHandlerMapping restHandlerMapping(Repositories repositories, RepositoryResourceMappings resourceMappings, Optional<JpaHelper> jpaHelper, RepositoryRestConfiguration repositoryRestConfiguration, CorsConfigurationAware corsRestConfiguration) {
        Map<String, CorsConfiguration> corsConfigurations = corsRestConfiguration.getCorsConfigurations();
        PathPatternParser parser = (PathPatternParser)this.parser.getIfAvailable();
        RepositoryRestHandlerMapping repositoryMapping = new RepositoryRestHandlerMapping((ResourceMappings)resourceMappings, repositoryRestConfiguration, repositories);
        repositoryMapping.setJpaHelper(jpaHelper.orElse(null));
        repositoryMapping.setApplicationContext(this.applicationContext);
        repositoryMapping.setCorsConfigurations(corsConfigurations);
        repositoryMapping.setPatternParser(parser);
        if (this.stringValueResolver != null) {
            repositoryMapping.setEmbeddedValueResolver(this.stringValueResolver);
        }
        repositoryMapping.afterPropertiesSet();
        BasePathAwareHandlerMapping basePathMapping = new BasePathAwareHandlerMapping(repositoryRestConfiguration);
        basePathMapping.setApplicationContext(this.applicationContext);
        basePathMapping.setCorsConfigurations(corsConfigurations);
        basePathMapping.setPatternParser(parser);
        if (this.stringValueResolver != null) {
            basePathMapping.setEmbeddedValueResolver(this.stringValueResolver);
        }
        basePathMapping.afterPropertiesSet();
        ArrayList<HandlerMapping> mappings = new ArrayList<HandlerMapping>();
        mappings.add((HandlerMapping)basePathMapping);
        mappings.add((HandlerMapping)repositoryMapping);
        return new DelegatingHandlerMapping(mappings, parser);
    }

    @Bean
    public RepositoryResourceMappings resourceMappings(Repositories repositories, PersistentEntities persistentEntities, RepositoryRestConfiguration repositoryRestConfiguration) {
        return new RepositoryResourceMappings(repositories, persistentEntities, repositoryRestConfiguration);
    }

    protected JacksonModule persistentEntityJackson3Module(LinkCollector linkCollector) {
        EmbeddedResourcesAssembler assembler = new EmbeddedResourcesAssembler((PersistentEntities)this.persistentEntities.get(), (Associations)this.associationLinks.get(), (ExcerptProjector)this.excerptProjector.get());
        PersistentEntityJackson3Module.LookupObjectSerializer lookupObjectSerializer = new PersistentEntityJackson3Module.LookupObjectSerializer(PluginRegistry.of(this.getEntityLookups()));
        return new PersistentEntityJackson3Module((Associations)this.associationLinks.get(), (PersistentEntities)this.persistentEntities.get(), new UriToEntityConverter((PersistentEntities)this.persistentEntities.get(), (RepositoryInvokerFactory)this.repositoryInvokerFactory.get(), () -> this.defaultConversionService), linkCollector, (RepositoryInvokerFactory)this.repositoryInvokerFactory.get(), lookupObjectSerializer, (RepresentationModelProcessorInvoker)this.invoker.getObject(), assembler);
    }

    @Bean
    protected LinkCollector linkCollector(PersistentEntities persistentEntities, SelfLinkProvider selfLinkProvider, Associations associationLinks) {
        return ((RepositoryRestConfigurerDelegate)this.configurerDelegate.get()).customizeLinkCollector(new DefaultLinkCollector(persistentEntities, selfLinkProvider, associationLinks));
    }

    @Bean
    public ExcerptProjector excerptProjector(RepositoryResourceMappings resourceMappings) {
        SpelAwareProxyProjectionFactory projectionFactory = new SpelAwareProxyProjectionFactory();
        projectionFactory.setBeanFactory((BeanFactory)this.applicationContext);
        return new DefaultExcerptProjector((ProjectionFactory)projectionFactory, (ResourceMappings)resourceMappings);
    }

    public void extendHandlerExceptionResolvers(List<HandlerExceptionResolver> exceptionResolvers) {
        ExceptionHandlerExceptionResolver er = new ExceptionHandlerExceptionResolver();
        er.setApplicationContext(this.applicationContext);
        er.setCustomArgumentResolvers(this.defaultMethodArgumentResolvers((SelfLinkProvider)this.selfLinkProvider.get(), (PersistentEntityResourceHandlerMethodArgumentResolver)this.persistentEntityArgumentResolver.get(), (PersistentEntityResourceAssemblerArgumentResolver)this.persistentEntityResourceAssemblerArgumentResolver.get(), (RootResourceInformationHandlerMethodArgumentResolver)this.repoRequestArgumentResolver.get()));
        er.setMessageConverters((List)this.defaultMessageConverters.get());
        ((RepositoryRestConfigurerDelegate)this.configurerDelegate.get()).configureExceptionHandlerExceptionResolver(er);
        er.afterPropertiesSet();
        exceptionResolvers.add(0, (HandlerExceptionResolver)er);
    }

    @Bean
    public RepositoryRestExceptionHandler repositoryRestExceptionHandler() {
        return new RepositoryRestExceptionHandler((MessageSource)this.applicationContext);
    }

    @Bean
    @Qualifier
    public RepositoryInvokerFactory repositoryInvokerFactory() {
        return new UnwrappingRepositoryInvokerFactory((RepositoryInvokerFactory)new DefaultRepositoryInvokerFactory((Repositories)this.repositories.get(), this.defaultConversionService), this.getEntityLookups());
    }

    @Bean
    public List<HttpMessageConverter<?>> defaultMessageConverters(@Qualifier(value="jacksonHttpMessageConverter") TypeConstrainedJacksonJsonHttpMessageConverter jacksonHttpMessageConverter, @Qualifier(value="halJacksonHttpMessageConverter") TypeConstrainedJacksonJsonHttpMessageConverter halJacksonHttpMessageConverter, @Qualifier(value="halFormsJacksonHttpMessageConverter") TypeConstrainedJacksonJsonHttpMessageConverter halFormsJacksonHttpMessageConverter, AlpsJackson3JsonHttpMessageConverter alpsJsonHttpMessageConverter, UriListHttpMessageConverter uriListHttpMessageConverter, RepositoryRestConfiguration repositoryRestConfiguration) {
        ArrayList messageConverters = new ArrayList();
        if (repositoryRestConfiguration.getMetadataConfiguration().alpsEnabled()) {
            messageConverters.add((HttpMessageConverter<?>)alpsJsonHttpMessageConverter);
        }
        if (List.of(MediaTypes.HAL_JSON, MediaTypes.VND_HAL_JSON).contains(repositoryRestConfiguration.getDefaultMediaType())) {
            messageConverters.add((HttpMessageConverter<?>)halJacksonHttpMessageConverter);
            messageConverters.add((HttpMessageConverter<?>)jacksonHttpMessageConverter);
        } else {
            messageConverters.add((HttpMessageConverter<?>)jacksonHttpMessageConverter);
            messageConverters.add((HttpMessageConverter<?>)halJacksonHttpMessageConverter);
        }
        messageConverters.add((HttpMessageConverter<?>)halFormsJacksonHttpMessageConverter);
        JacksonJsonHttpMessageConverter fallbackJsonConverter = new JacksonJsonHttpMessageConverter(this.basicObjectMapperBuilder().build());
        messageConverters.add((HttpMessageConverter<?>)fallbackJsonConverter);
        messageConverters.add(uriListHttpMessageConverter);
        ((RepositoryRestConfigurerDelegate)this.configurerDelegate.get()).configureHttpMessageConverters(messageConverters);
        return messageConverters;
    }

    @Bean
    public AlpsJackson3JsonHttpMessageConverter alpsJsonHttpMessageConverter(RootResourceInformationToAlpsDescriptorConverter alpsConverter) {
        return new AlpsJackson3JsonHttpMessageConverter(alpsConverter);
    }

    @Bean
    public HateoasPageableHandlerMethodArgumentResolver pageableResolver() {
        HateoasPageableHandlerMethodArgumentResolver resolver = super.pageableResolver();
        resolver.setPageParameterName(((RepositoryRestConfiguration)this.repositoryRestConfiguration.get()).getPageParamName());
        resolver.setSizeParameterName(((RepositoryRestConfiguration)this.repositoryRestConfiguration.get()).getLimitParamName());
        resolver.setFallbackPageable((Pageable)PageRequest.of((int)0, (int)((RepositoryRestConfiguration)this.repositoryRestConfiguration.get()).getDefaultPageSize()));
        resolver.setMaxPageSize(((RepositoryRestConfiguration)this.repositoryRestConfiguration.get()).getMaxPageSize());
        return resolver;
    }

    @Bean
    public HateoasSortHandlerMethodArgumentResolver sortResolver() {
        HateoasSortHandlerMethodArgumentResolver resolver = super.sortResolver();
        resolver.setSortParameter(((RepositoryRestConfiguration)this.repositoryRestConfiguration.get()).getSortParamName());
        return resolver;
    }

    @Bean
    public PluginRegistry<BackendIdConverter, Class<?>> backendIdConverterRegistry(List<BackendIdConverter> backendIdConverter) {
        ArrayList<BackendIdConverter> converters = new ArrayList<BackendIdConverter>(backendIdConverter);
        converters.add(BackendIdConverter.DefaultIdConverter.INSTANCE);
        return PluginRegistry.of(converters);
    }

    @Bean
    public AuditableBeanWrapperFactory auditableBeanWrapperFactory(PersistentEntities persistentEntities) {
        MappingAuditableBeanWrapperFactory factory = new MappingAuditableBeanWrapperFactory(persistentEntities);
        return ((RepositoryRestConfigurerDelegate)this.configurerDelegate.get()).customizeAuditableBeanWrapperFactory((AuditableBeanWrapperFactory)factory);
    }

    @Bean
    public HttpHeadersPreparer httpHeadersPreparer(AuditableBeanWrapperFactory auditableBeanWrapperFactory) {
        return new HttpHeadersPreparer(auditableBeanWrapperFactory);
    }

    @Bean
    public SelfLinkProvider selfLinkProvider(PersistentEntities persistentEntities, RepositoryEntityLinks entityLinks, @Qualifier(value="mvcConversionService") ObjectProvider<ConversionService> conversionService) {
        return new DefaultSelfLinkProvider(persistentEntities, (EntityLinks)entityLinks, this.getEntityLookups(), (ConversionService)conversionService.getIfUnique(() -> this.defaultConversionService));
    }

    @Bean
    public Associations associationLinks(RepositoryResourceMappings resourceMappings, RepositoryRestConfiguration repositoryRestConfiguration) {
        return new Associations((ResourceMappings)resourceMappings, repositoryRestConfiguration);
    }

    protected List<EntityLookup<?>> getEntityLookups() {
        ArrayList lookups = new ArrayList();
        lookups.addAll(((RepositoryRestConfiguration)this.repositoryRestConfiguration.get()).getEntityLookups((Repositories)this.repositories.get()));
        lookups.addAll((Collection)this.lookups.get());
        return lookups;
    }

    protected List<HandlerMethodArgumentResolver> defaultMethodArgumentResolvers(SelfLinkProvider selfLinkProvider, PersistentEntityResourceHandlerMethodArgumentResolver persistentEntityArgumentResolver, PersistentEntityResourceAssemblerArgumentResolver persistentEntityResourceAssemblerArgumentResolver, RootResourceInformationHandlerMethodArgumentResolver repoRequestArgumentResolver) {
        Jackson3MappingAwareSortTranslator sortTranslator = new Jackson3MappingAwareSortTranslator((ObjectMapper)this.objectMapper(), (Repositories)this.repositories.get(), DomainClassResolver.of((Repositories)this.repositories.get(), (ResourceMappings)this.resourceMappings.get(), (BaseUri)this.baseUri.get()), (PersistentEntities)this.persistentEntities.get(), (Associations)this.associationLinks.get());
        return Arrays.asList(new HandlerMethodArgumentResolver[]{new MappingAwareDefaultedPageableArgumentResolver(sortTranslator, (PageableHandlerMethodArgumentResolver)this.pageableResolver.get()), new MappingAwarePageableArgumentResolver(sortTranslator, (PageableArgumentResolver)this.pageableResolver.get()), new MappingAwareSortArgumentResolver(sortTranslator, (SortArgumentResolver)this.sortResolver.get()), repoRequestArgumentResolver, persistentEntityArgumentResolver, (HandlerMethodArgumentResolver)this.resourceMetadataHandlerMethodArgumentResolver.get(), HttpMethodHandlerMethodArgumentResolver.INSTANCE, persistentEntityResourceAssemblerArgumentResolver, (HandlerMethodArgumentResolver)this.applicationContext.getBean(RepresentationModelAssemblersArgumentResolver.class), (HandlerMethodArgumentResolver)this.backendIdHandlerMethodArgumentResolver.get(), (HandlerMethodArgumentResolver)this.eTagArgumentResolver.get()});
    }

    @Bean
    RepresentationModelAssemblersArgumentResolver representationModelAssemblersArgumentResolver(PagedResourcesAssembler<Object> pagedResourcesAssembler, SlicedResourcesAssembler<Object> slicedResourcesAssembler, PersistentEntityResourceAssemblerArgumentResolver delegate) {
        return new RepresentationModelAssemblersArgumentResolver(pagedResourcesAssembler, slicedResourcesAssembler, delegate);
    }

    @Bean
    PersistentEntityResourceAssemblerArgumentResolver persistentEntityResourceAssemblerArgumentResolver() {
        SpelAwareProxyProjectionFactory projectionFactory = new SpelAwareProxyProjectionFactory();
        projectionFactory.setBeanFactory((BeanFactory)this.applicationContext);
        if (this.beanClassLoader != null) {
            projectionFactory.setBeanClassLoader(this.beanClassLoader);
        }
        return new PersistentEntityResourceAssemblerArgumentResolver((PersistentEntities)this.persistentEntities.get(), (SelfLinkProvider)this.selfLinkProvider.get(), (ProjectionDefinitions)((RepositoryRestConfiguration)this.repositoryRestConfiguration.get()).getProjectionConfiguration(), (ProjectionFactory)projectionFactory, (Associations)this.associationLinks.get());
    }

    protected JsonMapper.Builder basicObjectMapperBuilder() {
        JsonMapper.Builder mapperBuilder = this.getMapperBuilder();
        mapperBuilder.configure(SerializationFeature.INDENT_OUTPUT, true);
        mapperBuilder.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        ((RepositoryRestConfigurerDelegate)this.configurerDelegate.get()).configureJacksonObjectMapper((MapperBuilder<? extends ObjectMapper, ? extends MapperBuilder<?, ?>>)mapperBuilder);
        mapperBuilder.addModule((JacksonModule)this.geoModule.getObject());
        mapperBuilder.addModule((JacksonModule)new AggregateReferenceResolvingModule(new UriToEntityConverter((PersistentEntities)this.persistentEntities.get(), (RepositoryInvokerFactory)this.repositoryInvokerFactory.get(), () -> this.defaultConversionService), (ResourceMappings)this.resourceMappings.get()));
        if (((RepositoryRestConfiguration)this.repositoryRestConfiguration.get()).isEnableEnumTranslation()) {
            mapperBuilder.addModule((JacksonModule)new Jackson3Serializers((EnumTranslator)this.enumTranslator.get()));
        }
        return mapperBuilder;
    }

    protected JsonMapper.Builder getMapperBuilder() {
        return (JsonMapper.Builder)this.objectMapperBuilder.getIfAvailable(() -> {
            JsonMapper mapper = (JsonMapper)this.objectMapper.getIfAvailable();
            return mapper != null ? mapper.rebuild() : JsonMapper.builder();
        });
    }

    @Bean
    public EnumTranslator enumTranslator(MessageResolver resolver) {
        return new EnumTranslator(resolver);
    }

    private Set<Class<?>> getProjections(Repositories repositories) {
        HashSet<String> packagesToScan = new HashSet<String>();
        for (Class domainType : repositories) {
            packagesToScan.add(domainType.getPackage().getName());
        }
        AnnotatedTypeScanner scanner = new AnnotatedTypeScanner(new Class[]{Projection.class});
        scanner.setEnvironment(this.applicationContext.getEnvironment());
        scanner.setResourceLoader((ResourceLoader)this.applicationContext);
        return scanner.findTypes(packagesToScan);
    }

    @Bean
    public RootResourceInformationToAlpsDescriptorConverter alpsConverter(Repositories repositories, PersistentEntities persistentEntities, RepositoryEntityLinks entityLinks, EnumTranslator enumTranslator, Associations associationLinks, RepositoryRestConfiguration repositoryRestConfiguration) {
        return new RootResourceInformationToAlpsDescriptorConverter(associationLinks, repositories, persistentEntities, (EntityLinks)entityLinks, (MessageResolver)this.resolver.getObject(), repositoryRestConfiguration, (ObjectMapper)this.objectMapper(), enumTranslator);
    }

    @Bean
    public ProfileResourceProcessor profileResourceProcessor(RepositoryRestConfiguration repositoryRestConfiguration) {
        return new ProfileResourceProcessor(repositoryRestConfiguration);
    }

    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        SpringFactoriesLoader.loadFactories(StaticResourceProvider.class, (ClassLoader)this.beanClassLoader).forEach(it -> it.customizeResources(registry, (RepositoryRestConfiguration)this.repositoryRestConfiguration.get()));
    }

    private static <S> Lazy<List<S>> beansOfType(ApplicationContext context, Class<?> type) {
        return Lazy.of(() -> (List)context.getBeanProvider(type).orderedStream().collect(StreamUtils.toUnmodifiableList()));
    }

    private static class ResourceSupportHttpMessageConverter
    extends TypeConstrainedJacksonJsonHttpMessageConverter
    implements Ordered {
        private final int order;

        ResourceSupportHttpMessageConverter(List<MediaType> supportedMediaTypes, JsonMapper mapper, int order) {
            super(RepresentationModel.class, supportedMediaTypes, mapper);
            this.order = order;
        }

        public int getOrder() {
            return this.order;
        }
    }
}

