/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc.config;

import java.util.List;
import org.springframework.core.convert.support.ConfigurableConversionService;
import org.springframework.data.auditing.AuditableBeanWrapperFactory;
import org.springframework.data.rest.core.config.RepositoryRestConfiguration;
import org.springframework.data.rest.core.event.ValidatingRepositoryEventListener;
import org.springframework.data.rest.webmvc.config.RepositoryRestConfigurer;
import org.springframework.data.rest.webmvc.mapping.LinkCollector;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.util.Assert;
import org.springframework.web.servlet.config.annotation.CorsRegistry;
import org.springframework.web.servlet.mvc.method.annotation.ExceptionHandlerExceptionResolver;
import tools.jackson.databind.ObjectMapper;
import tools.jackson.databind.cfg.MapperBuilder;

class RepositoryRestConfigurerDelegate
implements RepositoryRestConfigurer {
    private final Iterable<RepositoryRestConfigurer> delegates;

    public RepositoryRestConfigurerDelegate(Iterable<RepositoryRestConfigurer> delegates) {
        Assert.notNull(delegates, (String)"RepositoryRestConfigurers must not be null");
        this.delegates = delegates;
    }

    @Override
    public void configureRepositoryRestConfiguration(RepositoryRestConfiguration config, CorsRegistry cors) {
        for (RepositoryRestConfigurer configurer : this.delegates) {
            configurer.configureRepositoryRestConfiguration(config, cors);
        }
    }

    @Override
    public void configureConversionService(ConfigurableConversionService conversionService) {
        for (RepositoryRestConfigurer configurer : this.delegates) {
            configurer.configureConversionService(conversionService);
        }
    }

    @Override
    public void configureExceptionHandlerExceptionResolver(ExceptionHandlerExceptionResolver exceptionResolver) {
        for (RepositoryRestConfigurer configurer : this.delegates) {
            configurer.configureExceptionHandlerExceptionResolver(exceptionResolver);
        }
    }

    @Override
    public void configureHttpMessageConverters(List<HttpMessageConverter<?>> messageConverters) {
        for (RepositoryRestConfigurer configurer : this.delegates) {
            configurer.configureHttpMessageConverters(messageConverters);
        }
    }

    @Override
    public void configureJacksonObjectMapper(MapperBuilder<? extends ObjectMapper, ? extends MapperBuilder<?, ?>> mapperBuilder) {
        for (RepositoryRestConfigurer configurer : this.delegates) {
            configurer.configureJacksonObjectMapper(mapperBuilder);
        }
    }

    @Override
    public void configureValidatingRepositoryEventListener(ValidatingRepositoryEventListener validatingListener) {
        for (RepositoryRestConfigurer configurer : this.delegates) {
            configurer.configureValidatingRepositoryEventListener(validatingListener);
        }
    }

    @Override
    public AuditableBeanWrapperFactory customizeAuditableBeanWrapperFactory(AuditableBeanWrapperFactory factory) {
        for (RepositoryRestConfigurer configurer : this.delegates) {
            factory = configurer.customizeAuditableBeanWrapperFactory(factory);
        }
        return factory;
    }

    @Override
    public LinkCollector customizeLinkCollector(LinkCollector collector) {
        for (RepositoryRestConfigurer configurer : this.delegates) {
            collector = configurer.customizeLinkCollector(collector);
        }
        return collector;
    }
}

