/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc;

import java.lang.reflect.InvocationTargetException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.MessageSource;
import org.springframework.context.support.MessageSourceAccessor;
import org.springframework.core.convert.ConversionFailedException;
import org.springframework.core.log.LogFormatUtils;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.dao.OptimisticLockingFailureException;
import org.springframework.data.rest.core.RepositoryConstraintViolationException;
import org.springframework.data.rest.webmvc.ResourceNotFoundException;
import org.springframework.data.rest.webmvc.support.ETagDoesntMatchException;
import org.springframework.data.rest.webmvc.support.ExceptionMessage;
import org.springframework.data.rest.webmvc.support.RepositoryConstraintViolationExceptionMessage;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;

@ControllerAdvice(basePackageClasses={RepositoryRestExceptionHandler.class})
public class RepositoryRestExceptionHandler {
    private static final Logger LOG = LoggerFactory.getLogger(RepositoryRestExceptionHandler.class);
    private final MessageSourceAccessor messageSourceAccessor;

    public RepositoryRestExceptionHandler(MessageSource messageSource) {
        Assert.notNull((Object)messageSource, (String)"MessageSource must not be null");
        this.messageSourceAccessor = new MessageSourceAccessor(messageSource);
    }

    @ExceptionHandler
    ResponseEntity<?> handleNotFound(ResourceNotFoundException o_O) {
        return RepositoryRestExceptionHandler.notFound(new HttpHeaders());
    }

    @ExceptionHandler
    ResponseEntity<ExceptionMessage> handleNotReadable(HttpMessageNotReadableException o_O) {
        return RepositoryRestExceptionHandler.badRequest(new HttpHeaders(), (Exception)o_O);
    }

    @ExceptionHandler(value={InvocationTargetException.class, IllegalArgumentException.class, ClassCastException.class, ConversionFailedException.class, NullPointerException.class})
    ResponseEntity<ExceptionMessage> handleMiscFailures(Exception o_O) {
        return RepositoryRestExceptionHandler.errorResponse(HttpStatus.INTERNAL_SERVER_ERROR, new HttpHeaders(), o_O);
    }

    @ExceptionHandler
    ResponseEntity<RepositoryConstraintViolationExceptionMessage> handleRepositoryConstraintViolationException(RepositoryConstraintViolationException o_O) {
        return RepositoryRestExceptionHandler.response(HttpStatus.BAD_REQUEST, new HttpHeaders(), new RepositoryConstraintViolationExceptionMessage(o_O, this.messageSourceAccessor));
    }

    @ExceptionHandler(value={OptimisticLockingFailureException.class, DataIntegrityViolationException.class})
    ResponseEntity<ExceptionMessage> handleConflict(Exception o_O) {
        return RepositoryRestExceptionHandler.errorResponse(HttpStatus.CONFLICT, new HttpHeaders(), o_O);
    }

    @ExceptionHandler
    ResponseEntity<Void> handle(HttpRequestMethodNotSupportedException o_O) {
        HttpHeaders headers = new HttpHeaders();
        headers.setAllow(o_O.getSupportedHttpMethods());
        return RepositoryRestExceptionHandler.response(HttpStatus.METHOD_NOT_ALLOWED, headers);
    }

    @ExceptionHandler
    ResponseEntity<Void> handle(ETagDoesntMatchException o_O) {
        HttpHeaders headers = o_O.getExpectedETag().addTo(new HttpHeaders());
        return RepositoryRestExceptionHandler.response(HttpStatus.PRECONDITION_FAILED, headers);
    }

    private static ResponseEntity<?> notFound(HttpHeaders headers) {
        return RepositoryRestExceptionHandler.response(HttpStatus.NOT_FOUND, headers, null);
    }

    private static ResponseEntity<ExceptionMessage> badRequest(HttpHeaders headers, Exception throwable) {
        return RepositoryRestExceptionHandler.errorResponse(HttpStatus.BAD_REQUEST, headers, throwable);
    }

    private static ResponseEntity<ExceptionMessage> errorResponse(HttpStatus status, HttpHeaders headers, Exception exception) {
        if (exception != null) {
            String message = exception.getMessage();
            LOG.debug(LogFormatUtils.formatValue((Object)message, (int)-1, (boolean)true), (Throwable)exception);
            if (StringUtils.hasText((String)message)) {
                return RepositoryRestExceptionHandler.response(status, headers, new ExceptionMessage(exception));
            }
        }
        return RepositoryRestExceptionHandler.response(status, headers, null);
    }

    private static <T> ResponseEntity<T> response(HttpStatus status, HttpHeaders headers) {
        return RepositoryRestExceptionHandler.response(status, headers, null);
    }

    private static <T> ResponseEntity<T> response(HttpStatus status, HttpHeaders headers, T body) {
        Assert.notNull((Object)headers, (String)"Headers must not be null");
        Assert.notNull((Object)status, (String)"HttpStatus must not be null");
        return new ResponseEntity(body, headers, (HttpStatusCode)status);
    }
}

