/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.springframework.data.domain.Page;
import org.springframework.data.rest.core.mapping.ResourceMetadata;
import org.springframework.data.rest.webmvc.ControllerUtils;
import org.springframework.data.rest.webmvc.PersistentEntityResource;
import org.springframework.data.rest.webmvc.PersistentEntityResourceAssembler;
import org.springframework.data.rest.webmvc.RootResourceInformation;
import org.springframework.data.web.PagedResourcesAssembler;
import org.springframework.hateoas.CollectionModel;
import org.springframework.hateoas.EntityModel;
import org.springframework.hateoas.IanaLinkRelations;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.LinkRelation;
import org.springframework.hateoas.server.RepresentationModelAssembler;
import org.springframework.hateoas.server.core.EmbeddedWrappers;
import org.springframework.util.Assert;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;

class AbstractRepositoryRestController {
    private static final EmbeddedWrappers WRAPPERS = new EmbeddedWrappers(false);
    private final PagedResourcesAssembler<Object> pagedResourcesAssembler;

    public AbstractRepositoryRestController(PagedResourcesAssembler<Object> pagedResourcesAssembler) {
        Assert.notNull(pagedResourcesAssembler, (String)"PagedResourcesAssembler must not be null!");
        this.pagedResourcesAssembler = pagedResourcesAssembler;
    }

    protected Link resourceLink(RootResourceInformation resourceLink, EntityModel resource) {
        ResourceMetadata repoMapping = resourceLink.getResourceMetadata();
        Link selfLink = resource.getRequiredLink(IanaLinkRelations.SELF);
        LinkRelation rel = repoMapping.getItemResourceRel();
        return new Link(selfLink.getHref(), rel);
    }

    protected CollectionModel<?> toCollectionModel(Iterable<?> source, PersistentEntityResourceAssembler assembler, Class<?> domainType, Optional<Link> baseLink) {
        if (source instanceof Page) {
            Page page = (Page)source;
            return this.entitiesToResources((Page<Object>)page, assembler, domainType, baseLink);
        }
        if (source instanceof Iterable) {
            return this.entitiesToResources(source, assembler, domainType);
        }
        return new CollectionModel(ControllerUtils.EMPTY_RESOURCE_LIST, new Link[0]);
    }

    protected CollectionModel<?> entitiesToResources(Page<Object> page, PersistentEntityResourceAssembler assembler, Class<?> domainType, Optional<Link> baseLink) {
        if (page.getContent().isEmpty()) {
            return (CollectionModel)baseLink.map(it -> this.pagedResourcesAssembler.toEmptyModel(page, domainType, it)).orElseGet(() -> this.pagedResourcesAssembler.toEmptyModel(page, domainType));
        }
        return (CollectionModel)baseLink.map(it -> this.pagedResourcesAssembler.toModel(page, (RepresentationModelAssembler)assembler, it)).orElseGet(() -> this.pagedResourcesAssembler.toModel(page, (RepresentationModelAssembler)assembler));
    }

    protected CollectionModel<?> entitiesToResources(Iterable<Object> entities, PersistentEntityResourceAssembler assembler, Class<?> domainType) {
        if (!entities.iterator().hasNext()) {
            List<Object> content = Arrays.asList(WRAPPERS.emptyCollectionOf(domainType));
            return new CollectionModel(content, new Link[]{this.getDefaultSelfLink()});
        }
        ArrayList<PersistentEntityResource> resources = new ArrayList<PersistentEntityResource>();
        for (Object obj : entities) {
            resources.add(obj == null ? null : assembler.toModel(obj));
        }
        return new CollectionModel(resources, new Link[]{this.getDefaultSelfLink()});
    }

    protected Link getDefaultSelfLink() {
        return new Link(ServletUriComponentsBuilder.fromCurrentRequest().build().toUriString());
    }
}

