/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc.mapping;

import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.data.mapping.Association;
import org.springframework.data.mapping.IdentifierAccessor;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.data.mapping.SimpleAssociationHandler;
import org.springframework.data.mapping.context.PersistentEntities;
import org.springframework.data.rest.core.mapping.ResourceMapping;
import org.springframework.data.rest.core.mapping.ResourceMappings;
import org.springframework.data.rest.core.mapping.ResourceMetadata;
import org.springframework.hateoas.EntityLinks;
import org.springframework.hateoas.Link;

public class NestedLinkCollectingAssociationHandler
implements SimpleAssociationHandler {
    private final EntityLinks entityLinks;
    private final PersistentEntities entities;
    private final PersistentPropertyAccessor accessor;
    private final ResourceMappings mappings;
    private final List<Link> links = new ArrayList<Link>();

    public void doWithAssociation(Association<? extends PersistentProperty<?>> association) {
        PersistentProperty property = association.getInverse();
        Object propertyValue = this.accessor.getProperty(property);
        ResourceMetadata metadata = this.mappings.getMetadataFor(property.getOwner().getType());
        ResourceMapping propertyMapping = metadata.getMappingFor(property);
        if (property.isCollectionLike()) {
            for (Object element : (Collection)propertyValue) {
                IdentifierAccessor identifierAccessor = this.entities.getPersistentEntity(element.getClass()).getIdentifierAccessor(element);
                this.links.add(this.entityLinks.linkForSingleResource(element.getClass(), identifierAccessor.getIdentifier()).withRel(propertyMapping.getRel()));
            }
        } else {
            IdentifierAccessor identifierAccessor = this.entities.getPersistentEntity(propertyValue.getClass()).getIdentifierAccessor(propertyValue);
            this.links.add(this.entityLinks.linkForSingleResource(propertyValue.getClass(), identifierAccessor.getIdentifier()).withRel(propertyMapping.getRel()));
        }
    }

    @ConstructorProperties(value={"entityLinks", "entities", "accessor", "mappings"})
    public NestedLinkCollectingAssociationHandler(EntityLinks entityLinks, PersistentEntities entities, PersistentPropertyAccessor accessor, ResourceMappings mappings) {
        this.entityLinks = entityLinks;
        this.entities = entities;
        this.accessor = accessor;
        this.mappings = mappings;
    }

    public List<Link> getLinks() {
        return this.links;
    }
}

