/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc.json;

import java.beans.ConstructorProperties;
import lombok.NonNull;
import org.springframework.core.MethodParameter;
import org.springframework.data.domain.Sort;
import org.springframework.data.rest.webmvc.json.JacksonMappingAwareSortTranslator;
import org.springframework.data.web.SortHandlerMethodArgumentResolver;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;

public class MappingAwareSortArgumentResolver
implements HandlerMethodArgumentResolver {
    @NonNull
    private final JacksonMappingAwareSortTranslator translator;
    @NonNull
    private final SortHandlerMethodArgumentResolver delegate;

    public boolean supportsParameter(MethodParameter parameter) {
        return this.delegate.supportsParameter(parameter);
    }

    public Sort resolveArgument(MethodParameter parameter, ModelAndViewContainer mavContainer, NativeWebRequest webRequest, WebDataBinderFactory binderFactory) throws Exception {
        Sort sort = this.delegate.resolveArgument(parameter, mavContainer, webRequest, binderFactory);
        return sort == null ? null : this.translator.translateSort(sort, parameter, webRequest);
    }

    @ConstructorProperties(value={"translator", "delegate"})
    public MappingAwareSortArgumentResolver(@NonNull JacksonMappingAwareSortTranslator translator, @NonNull SortHandlerMethodArgumentResolver delegate) {
        if (translator == null) {
            throw new IllegalArgumentException("translator is null");
        }
        if (delegate == null) {
            throw new IllegalArgumentException("delegate is null");
        }
        this.translator = translator;
        this.delegate = delegate;
    }
}

