/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc;

import java.util.List;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.data.rest.core.config.RepositoryRestConfiguration;
import org.springframework.data.rest.core.mapping.ResourceMappings;
import org.springframework.data.rest.webmvc.BaseUriAwareHandlerMapping;
import org.springframework.data.rest.webmvc.RepositoryRestController;
import org.springframework.data.rest.webmvc.support.JpaHelper;
import org.springframework.util.Assert;
import org.springframework.web.context.request.WebRequestInterceptor;

public class RepositoryRestHandlerMapping
extends BaseUriAwareHandlerMapping {
    private final ResourceMappings mappings;
    private JpaHelper jpaHelper;

    public RepositoryRestHandlerMapping(ResourceMappings mappings, RepositoryRestConfiguration config) {
        super(config);
        Assert.notNull((Object)mappings, (String)"ResourceMappings must not be null!");
        Assert.notNull((Object)config, (String)"RepositoryRestConfiguration must not be null!");
        this.mappings = mappings;
        this.setOrder(2147483547);
    }

    public void setJpaHelper(JpaHelper jpaHelper) {
        this.jpaHelper = jpaHelper;
    }

    @Override
    protected boolean supportsLookupPath(String lookupPath) {
        if ("/".equals(lookupPath)) {
            return true;
        }
        String[] parts = lookupPath.split("/");
        return this.mappings.exportsTopLevelResourceFor(parts[lookupPath.startsWith("/") ? 1 : 0]);
    }

    @Override
    protected boolean isHandler(Class<?> beanType) {
        return AnnotationUtils.findAnnotation(beanType, RepositoryRestController.class) != null;
    }

    protected void extendInterceptors(List<Object> interceptors) {
        if (null != this.jpaHelper) {
            for (WebRequestInterceptor o : this.jpaHelper.getInterceptors()) {
                interceptors.add(o);
            }
        }
    }
}

