/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.rest.webmvc.ResourceProcessorHandlerMethodReturnValueHandler;
import org.springframework.hateoas.ResourceProcessor;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;
import org.springframework.web.method.support.HandlerMethodReturnValueHandler;
import org.springframework.web.method.support.HandlerMethodReturnValueHandlerComposite;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerAdapter;

public class ResourceProcessorInvokingHandlerAdapter
extends RequestMappingHandlerAdapter {
    private static final Method RETURN_VALUE_HANDLER_METHOD = ReflectionUtils.findMethod(ResourceProcessorInvokingHandlerAdapter.class, (String)"getReturnValueHandlers");
    private final List<ResourceProcessor<?>> resourcesProcessors;

    @Autowired(required=false)
    public ResourceProcessorInvokingHandlerAdapter(List<ResourceProcessor<?>> resourcesProcessors) {
        Assert.notNull(resourcesProcessors);
        this.resourcesProcessors = resourcesProcessors;
    }

    public void afterPropertiesSet() {
        super.afterPropertiesSet();
        HandlerMethodReturnValueHandlerComposite oldHandlers = this.getReturnValueHandlersComposite();
        ArrayList<ResourceProcessorHandlerMethodReturnValueHandler> newHandlers = new ArrayList<ResourceProcessorHandlerMethodReturnValueHandler>();
        newHandlers.add(new ResourceProcessorHandlerMethodReturnValueHandler((HandlerMethodReturnValueHandler)oldHandlers, this.resourcesProcessors));
        this.setReturnValueHandlers(newHandlers);
    }

    private HandlerMethodReturnValueHandlerComposite getReturnValueHandlersComposite() {
        Object handlers = ReflectionUtils.invokeMethod((Method)RETURN_VALUE_HANDLER_METHOD, (Object)((Object)this));
        if (handlers instanceof HandlerMethodReturnValueHandlerComposite) {
            return (HandlerMethodReturnValueHandlerComposite)handlers;
        }
        return new HandlerMethodReturnValueHandlerComposite().addHandlers((List)handlers);
    }
}

